/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.handler.WSATConsumer;
import com.ibm.ws.wstx.handler.WSBAConsumer;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class WSTXServerTCMImpl
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(WSTXServerTCMImpl.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public void migrateContextToThread(MessageContext mc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateContextToThread", mc);
        }
        if (!WSTXHelper.DISABLED) {
            try {
                WSATConsumer.establishContext(mc);
                WSBAConsumer.establishContext(mc);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.WSTXServerTCMImpl.migrateContextToThread", "42", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "migrateContextToThread", e);
                }
                throw AxisFault.makeFault(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateContextToThread");
        }
    }

    public void cleanupThread(MessageContext inboundContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupThread", new Object[]{inboundContext, this});
        }
        WSTXHelper.traceMessageContext(inboundContext);
        Object threadCleanedUp = inboundContext.getProperty(WSTXHelper.THREAD_CLEANED_UP);
        if (threadCleanedUp == null) {
            inboundContext.setProperty(WSTXHelper.THREAD_CLEANED_UP, Boolean.TRUE);
            try {
                MessageContext outboundContext = inboundContext.getOperationContext().getMessageContext("Out");
                this.handleOutbound(inboundContext, outboundContext);
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.WSTXServerTCMImpl.cleanupThread", "71", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "cleanupThread", e);
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Thread already cleaned up");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupThread");
        }
    }

    public void migrateThreadToContext(MessageContext outboundContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext", outboundContext);
        }
        MessageContext inboundContext = outboundContext.getOperationContext().getMessageContext("In");
        this.cleanupThread(inboundContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    public void cleanupContext(MessageContext mc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanupContext", mc);
        }
        WSTXHelper.traceMessageContext(mc);
    }

    private void handleOutbound(MessageContext inboundContext, MessageContext outboundContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleOutbound", new Object[]{inboundContext, outboundContext});
        }
        if (!WSTXHelper.DISABLED) {
            try {
                WSBAConsumer.removeContext(inboundContext);
                WSATConsumer.handleOutbound(inboundContext, outboundContext);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.WSTXServerTCMImpl.cleanupThread", "63", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleOutbound", e);
                }
                throw AxisFault.makeFault(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleOutbound");
        }
    }
}

