/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.tx.config.WASConfigurationProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.List;
import java.util.Properties;

public class WSTXComponentImpl
extends WsComponentImpl
implements DeployedObjectHandler {
    private static final TraceComponent tc = Tr.register(WSTXComponentImpl.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public void initialize(Object obj) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{obj, this});
        }
        super.initialize(obj);
        if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "WebServices Server disabled in z/OS CRA");
            }
            throw new ComponentDisabledException("WebServices Server disabled in z/OS CRA");
        }
        String procType = AdminServiceFactory.getAdminService().getProcessType();
        if (!procType.equals("ManagedProcess")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", "Disabling component");
            }
            throw new ComponentDisabledException("Disabling component in non managed process");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
    }

    private boolean isClusterMixedVersion() throws RuntimeError {
        boolean result;
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "isClusterMixedVersion");
            }
            result = false;
            try {
                ConfigService configService = WsServiceRegistry.getService(this, ConfigService.class);
                String localClusterName = configService.getClusterName();
                if (localClusterName == null) break block11;
                String localNodeName = configService.getNodeName();
                ConfigScope scope = configService.createScope(0);
                String[] clusterList = scope.list("clusters");
                if (clusterList == null) break block11;
                ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                for (int cluster = 0; cluster < clusterList.length; ++cluster) {
                    scope = configService.createScope(2);
                    scope.set(2, clusterList[cluster]);
                    List resource = configService.getDocumentObjects(scope, "cluster.xml");
                    ConfigObject clusterConfig = (ConfigObject)resource.get(0);
                    String clusterName = clusterConfig.getString("name", null);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster = " + clusterName);
                    }
                    if (!clusterName.equals(localClusterName)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking cluster configuration for cluster " + clusterName);
                    }
                    List members = clusterConfig.getObjectList("members");
                    for (ConfigObject member : members) {
                        String nodeName = member.getString("nodeName", null);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing " + nodeName);
                        }
                        if (nodeName.equals(localNodeName)) continue;
                        String version = helper.getNodeBaseProductVersion(nodeName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node " + nodeName + " is release " + version);
                        }
                        if (Utils.compareVersions((String)version, (String)"7.0.0.0") >= 0) continue;
                        result = true;
                        break block11;
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.WSTXComponentImpl.isClusterMixedVersion", "157", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "isClusterMixedVersion", e);
                }
                throw new RuntimeError(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isClusterMixedVersion", result);
        }
        return result;
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.isClusterMixedVersion()) {
            try {
                ApplicationMgr mgr = WsServiceRegistry.getService(this, ApplicationMgr.class);
                mgr.addDeployedObjectHandler(this);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.WSTXComponentImpl.start", "184", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", e);
                }
                throw new RuntimeError(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
    }

    private boolean validatePolicyAndLevel(PolicySetAttachments atts, ClassLoader cl) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validatePolicyAndLevel", new Object[]{atts, cl});
        }
        boolean result = true;
        List<String> resources = atts.getResourceNames();
        if (resources != null) {
            boolean serverLevel11 = ((WASConfigurationProvider)ConfigurationProviderManager.getConfigurationProvider()).getDefaultWSTXSpecLevel() == 1;
            for (String resource : resources) {
                PolicySetConfiguration psc = atts.getPolicySet(resource, cl, cl);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "psc", psc);
                }
                if (psc == null) continue;
                Object ptc = psc.getPolicyTypeConfiguration("ENABLE_WSTRANSACTION");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ptc", ptc);
                }
                if (ptc == null || !(ptc instanceof Properties)) continue;
                Properties props = (Properties)ptc;
                if (props.isEmpty()) {
                    if (!serverLevel11) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "policy specifies no level and default is 1.1 in mixed cluster");
                    }
                    result = false;
                    break;
                }
                String ATpolicy = props.getProperty("ATAssertion", "never");
                if (!ATpolicy.equals("never") && serverLevel11) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "policy specifies AT and default is 1.1 in mixed cluster");
                    }
                    result = false;
                    break;
                }
                String BApolicy = props.getProperty("BAAtomicOutcomeAssertion", "never");
                if (BApolicy.equals("never") || !serverLevel11) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "policy specifies BA and default is 1.1 in mixed cluster");
                }
                result = false;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validatePolicyAndLevel", result);
        }
        return result;
    }

    public boolean start(DeployedObjectEvent doe) throws RuntimeError, RuntimeWarning {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start", doe);
        }
        boolean result = true;
        DeployedObject dobj = doe.getDeployedObject();
        if (dobj instanceof DeployedApplication) {
            ApplicationMetaData amd = (ApplicationMetaData)dobj.getMetaData();
            String appName = amd.getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "app name", appName);
            }
            try {
                ClassLoader appCL = dobj.getClassLoader();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "appCL", appCL);
                }
                PolicySetAttachments atts = null;
                String cuName = PolicySetUtil._CU_NAME.get();
                if (cuName != null) {
                    Properties props = new Properties();
                    props.setProperty("cuName", cuName);
                    atts = PolicySetUtil.getInstance(appCL).getAttachments(props);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "attachments", atts);
                    }
                    if (atts != null) {
                        result = this.validatePolicyAndLevel(atts, appCL);
                    }
                    atts = PolicySetUtil.getInstance(appCL).getClientAttachments(props);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "client attachments", atts);
                    }
                    if (atts != null && !this.validatePolicyAndLevel(atts, appCL)) {
                        result = false;
                    }
                } else {
                    atts = PolicySetUtil.getInstance(appCL).getAttachments(appName);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "attachments", atts);
                    }
                    if (atts != null) {
                        result = this.validatePolicyAndLevel(atts, appCL);
                    }
                    atts = PolicySetUtil.getInstance(appCL).getClientAttachments(appName);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "client attachments", atts);
                    }
                    if (atts != null && !this.validatePolicyAndLevel(atts, appCL)) {
                        result = false;
                    }
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", e);
                }
                throw new RuntimeError(e);
            }
            if (!result) {
                Tr.error(tc, "WTRN0128_WSTX_APP_START_FAILURE", appName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", result);
                }
                throw new RuntimeWarning("WS Transaction Specification Level invalid for mixed version cluster");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start", result);
        }
        return result;
    }

    public void stop(DeployedObjectEvent doe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", doe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }
}

