/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wstx.WSTXHelper;
import com.ibm.ws.wstx.handler.WSATGenerator;
import com.ibm.ws.wstx.handler.WSBAGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class WSTXClientTCMImpl
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(WSTXClientTCMImpl.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public void migrateContextToThread(MessageContext inboundContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "migrateContextToThread", inboundContext.getEnvelope());
        }
    }

    public void cleanupThread(MessageContext mc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "cleanupThread", mc);
        }
    }

    public void migrateThreadToContext(MessageContext outboundContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext", outboundContext);
        }
        if (!WSTXHelper.DISABLED) {
            WSATGenerator.handleOutbound(outboundContext);
            WSBAGenerator.handleOutbound(outboundContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    public void cleanupContext(MessageContext outboundContext) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupContext", outboundContext);
            }
            WSTXHelper.traceMessageContext(outboundContext);
            if (!WSTXHelper.DISABLED) {
                try {
                    MessageContext inboundContext = outboundContext.getOperationContext().getMessageContext("In");
                    this.handleInbound(inboundContext);
                }
                catch (AxisFault e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wstx.WSTXClientTCMImpl.cleanupContext", "79", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "cleanupContext", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContext");
        }
    }

    private void handleInbound(MessageContext inboundContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInbound", inboundContext);
        }
        if (!WSTXHelper.DISABLED) {
            WSBAGenerator.handleInbound(inboundContext);
            WSATGenerator.handleInbound(inboundContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInbound");
        }
    }
}

