/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wstx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.WSTXVersion;
import com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2CoordinationContext
extends CoordinationContext {
    private static final TraceComponent tc = Tr.register(Axis2CoordinationContext.class, "WSTX", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final QName REGISTRATION_SERVICE = new QName(WSTXVersion.getWSCNamespace((int)0), "RegistrationService", "wscoor");

    public Axis2CoordinationContext(AttributedURI identifier, URI coordinationType, String expires, EndpointReference registrationService, Map extensibilityElements) {
        super(identifier, coordinationType, expires, registrationService, extensibilityElements);
    }

    public Axis2CoordinationContext(CoordinationContext cc) {
        this(cc.getIdentifier(), cc.getCoordinationType(), cc.getExpires(), cc.getRegistrationService(), cc.getExtensiblityElements());
        Iterator attrNames = cc.getAttributeNames();
        while (attrNames.hasNext()) {
            Name attrName = (Name)attrNames.next();
            this.addAttribute(attrName, cc.getAttributeValue(attrName));
        }
    }

    public void insertIntoSOAPHeader(int wstxVersion, SOAPHeader sh) throws WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertIntoSOAPHeader", new Object[]{sh, this});
        }
        OMFactory omFactory = sh.getOMFactory();
        SOAPHeaderBlock shb = sh.addHeaderBlock("CoordinationContext", OMAbstractFactory.getOMFactory().createOMNamespace(WSTXVersion.getWSCNamespace((int)wstxVersion), "wscoor"));
        shb.setMustUnderstand(true);
        OMElement element = omFactory.createOMElement(new QName(WSTXVersion.getWSCNamespace((int)wstxVersion), "Identifier", "wscoor"), shb);
        OMText text = omFactory.createOMText((OMContainer)element, this._identifier.getURI().toString());
        element.addChild(text);
        shb.addChild(element);
        if (this._expires != null && this._expires.length() > 0) {
            element = omFactory.createOMElement(new QName(WSTXVersion.getWSCNamespace((int)wstxVersion), "Expires", "wscoor"), shb);
            text = omFactory.createOMText((OMContainer)element, this._expires);
            element.addChild(text);
            shb.addChild(element);
        }
        element = omFactory.createOMElement(new QName(WSTXVersion.getWSCNamespace((int)wstxVersion), "CoordinationType", "wscoor"), shb);
        text = omFactory.createOMText((OMContainer)element, this._coordinationType.toString());
        element.addChild(text);
        shb.addChild(element);
        element = EndpointReferenceConverter.serializeEndpointReference(this._registrationService, new QName(WSTXVersion.getWSCNamespace((int)wstxVersion), "RegistrationService", "wscoor"));
        shb.addChild(element);
        Iterator attributeNames = this.getAttributeNames();
        while (attributeNames.hasNext()) {
            Name attributeName = (Name)attributeNames.next();
            OMAttribute attribute = omFactory.createOMAttribute(attributeName.getLocalName(), OMAbstractFactory.getOMFactory().createOMNamespace(WSTXVersion.getWSCNamespace((int)wstxVersion), "wscoor"), this.getAttributeValue(attributeName));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute", attribute);
            }
            shb.addAttribute(attribute);
        }
        if (this._extensibilityElements != null) {
            for (QName qname : this._extensibilityElements.keySet()) {
                element = omFactory.createOMElement(qname, shb);
                String value = (String)this._extensibilityElements.get(qname);
                text = omFactory.createOMText((OMContainer)element, value);
                element.addChild(text);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extensibility Element", element);
                }
                shb.addChild(element);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertIntoSOAPHeader", sh);
        }
    }

    public static Axis2CoordinationContext extractFromSOAPHeader(SOAPHeader sh, String requiredCoordinationType, List extensibilityElementNames) {
        HashSet<String> hs = new HashSet<String>(1);
        hs.add(requiredCoordinationType);
        return Axis2CoordinationContext.extractFromSOAPHeader(sh, hs, extensibilityElementNames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Axis2CoordinationContext extractFromSOAPHeader(SOAPHeader sh, Set<String> requiredCoordinationTypes, List extensibilityElementNames) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractFromSOAPHeader", new Object[]{sh, requiredCoordinationTypes, extensibilityElementNames});
        }
        Iterator headerBlocks = sh.getChildElements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "headerBlocks", headerBlocks);
        }
        SOAPHeaderBlock hb = null;
        String expires = null;
        URI type = null;
        AttributedURI identifier = null;
        EndpointReference registrationService = null;
        HashMap<QName, String> extensibilityElements = null;
        while (headerBlocks.hasNext()) {
            block35: {
                OMElement nextElement;
                Iterator childElements;
                block34: {
                    String typeText;
                    block33: {
                        block36: {
                            block32: {
                                hb = (SOAPHeaderBlock)headerBlocks.next();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SOAPHeaderBlock", hb);
                                }
                                if (!"CoordinationContext".equals(hb.getLocalName())) continue;
                                childElements = hb.getChildElements();
                                identifier = null;
                                if (childElements.hasNext()) {
                                    nextElement = (OMElement)childElements.next();
                                    if ("Identifier".equals(nextElement.getLocalName())) {
                                        try {
                                            identifier = WSAddressingFactory.createAttributedURI(new URI(nextElement.getText()));
                                            break block32;
                                        }
                                        catch (URISyntaxException e) {
                                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                            Tr.debug(tc, "Invalid identifier");
                                            continue;
                                        }
                                    }
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "First element not Identifier");
                                    continue;
                                }
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "No child elements");
                                continue;
                            }
                            expires = null;
                            type = null;
                            if (!childElements.hasNext()) break block36;
                            nextElement = (OMElement)childElements.next();
                            if ("Expires".equals(nextElement.getLocalName())) {
                                expires = nextElement.getText();
                                break block33;
                            } else {
                                if ("CoordinationType".equals(nextElement.getLocalName())) {
                                    typeText = nextElement.getText();
                                    if (!requiredCoordinationTypes.contains(typeText)) {
                                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "Doesn't match required coordination type");
                                        continue;
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found CC with coordination type: " + typeText);
                                    }
                                    try {
                                        type = new URI(typeText);
                                        break block33;
                                    }
                                    catch (URISyntaxException e) {
                                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "Bad syntax for type");
                                        continue;
                                    }
                                }
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "No expires or type");
                                continue;
                            }
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No second child element");
                        continue;
                    }
                    if (type == null) {
                        if (childElements.hasNext()) {
                            nextElement = (OMElement)childElements.next();
                            if ("CoordinationType".equals(nextElement.getLocalName())) {
                                typeText = nextElement.getText();
                                if (!requiredCoordinationTypes.contains(typeText)) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Doesn't match required coordination type");
                                    continue;
                                }
                                try {
                                    type = new URI(typeText);
                                    break block34;
                                }
                                catch (URISyntaxException e) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Bad syntax for type");
                                    continue;
                                }
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "No type element");
                            continue;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No type element");
                        continue;
                    }
                }
                registrationService = null;
                if (childElements.hasNext()) {
                    nextElement = (OMElement)childElements.next();
                    if ("RegistrationService".equals(nextElement.getLocalName())) {
                        try {
                            registrationService = EndpointReferenceConverter.createEndpointReferenceFromOMElement(nextElement);
                            break block35;
                        }
                        catch (EndpointReferenceCreationException e) {
                            FFDCFilter.processException(e, "com.ibm.ws.wstx.Axis2CoordinationContext.extractFromSOAPHeader", "283");
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Couldn't deserialize registration service element");
                            continue;
                        }
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "fail 11");
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "fail 11");
                continue;
            }
            extensibilityElements = new HashMap<QName, String>();
            if (extensibilityElementNames == null) break;
            for (QName qname : extensibilityElementNames) {
                Iterator children = hb.getChildrenWithName(qname);
                String element = null;
                if (children.hasNext()) {
                    element = ((OMElement)children.next()).getText();
                }
                if (element == null) continue;
                extensibilityElements.put(qname, element);
            }
        }
        Axis2CoordinationContext wcc = null;
        if (type != null) {
            if (identifier == null || registrationService == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractFromSOAPHeader", null);
                }
                return null;
            }
            wcc = new Axis2CoordinationContext(identifier, type, expires, registrationService, extensibilityElements);
            Iterator attribIter = hb.getAllAttributes();
            while (attribIter.hasNext()) {
                OMAttribute attr = (OMAttribute)attribIter.next();
                OMNamespace ns = attr.getNamespace();
                wcc.addAttribute(attr.getLocalName(), ns.getPrefix(), ns.getName(), attr.getAttributeValue());
            }
            hb.detach();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractFromSOAPHeader", wcc);
        }
        return wcc;
    }
}

