/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.util;

import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyName;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class KeyStoreKeyInfoResolver
extends KeyInfoResolverBase {
    private static final boolean DEBUG = false;
    private KeyStore fKeyStore;
    private Map fPasswords;

    public KeyStoreKeyInfoResolver(KeyStore store) {
        this.fKeyStore = store;
        this.fPasswords = new HashMap();
    }

    public void putAliasAndPassword(String alias, char[] password) {
        this.fPasswords.put(alias, password);
    }

    public char[] getPassword(String alias) {
        return (char[])this.fPasswords.get(alias);
    }

    protected String getAlias(String name) {
        return name;
    }

    @Override
    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        String a;
        String n;
        if (key == null) {
            key = super.resolveKeyName(keyName, encMeth, key);
        }
        if (key == null && (n = keyName.getName()) != null && (a = this.getAlias(n)) != null) {
            if (this.fKeyStore == null) {
                throw new KeyInfoResolvingException("Keystore not specified");
            }
            try {
                char[] p;
                Certificate c;
                if (this.fInEncryptMode && (c = this.fKeyStore.getCertificate(a)) != null) {
                    key = c.getPublicKey();
                }
                if (key == null && (p = this.getPassword(a)) != null) {
                    key = this.fKeyStore.getKey(a, p);
                }
            }
            catch (KeyStoreException e) {
                throw new KeyInfoResolvingException(e.getMessage());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return key;
    }
}

