/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DsTransforms;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class RetrievalMethod
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "RetrievalMethod";
    private static final String ATTR_URI = "URI";
    private static final String ATTR_TYPE = "Type";
    private static final QName ATTR_URI_Q = new QName("", "URI");
    private static final QName ATTR_TYPE_Q = new QName("", "Type");
    private String fUri;
    private String fType;
    private DsTransforms fTransforms;

    public RetrievalMethod() {
        this((OMElement)null);
    }

    public RetrievalMethod(OMElement retMeth) {
        super(retMeth);
        if (retMeth != null) {
            if (!RetrievalMethod.isOfType(retMeth)) {
                throw new IllegalArgumentException("Not RetrievalMethod element");
            }
            this.fUri = retMeth.getAttributeValue(ATTR_URI_Q);
            this.fType = retMeth.getAttributeValue(ATTR_TYPE_Q);
            this.init(retMeth);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (!DsTransforms.isOfType(e)) continue block4;
                    this.fTransforms = new DsTransforms(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    public void setURI(String uri) {
        this.fUri = uri;
    }

    public String getURI() {
        return this.fUri;
    }

    public void setType(String type) {
        this.fType = type;
    }

    public String getType() {
        return this.fType;
    }

    public void setTransforms(DsTransforms transs) {
        this.fTransforms = transs;
    }

    public DsTransforms getTransforms() {
        return this.fTransforms;
    }

    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    @Override
    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement retMeth = DOMUtils.createDsigOMElement(NAME, factory, parent);
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        retMeth.addAttribute(ATTR_URI, Util.normalize(this.fUri), null);
        if (this.fType != null) {
            retMeth.addAttribute(ATTR_TYPE, Util.normalize(this.fType), null);
        }
        if (this.fTransforms != null) {
            OMElement e = this.fTransforms.createElement(factory, retMeth);
            retMeth.addChild(e);
        }
        return retMeth;
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        throw new StructureException("Internal error: creation of RetrievalMethod element not supported with WSSObject");
    }
}

