/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class EncryptionProperty
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionProperty";
    private static final String ATTR_TARGET = "Target";
    private static final String ATTR_ID = "Id";
    private String fTarget;
    private String fId;
    private List fAttributes = new ArrayList();

    public EncryptionProperty() {
        this((OMElement)null);
    }

    public EncryptionProperty(OMElement encProp) {
        super(encProp);
        if (encProp != null) {
            if (!EncryptionProperty.isOfType(encProp)) {
                throw new IllegalArgumentException("Not EncryptionProperty element");
            }
            Iterator attrs = encProp.getAllAttributes();
            while (attrs.hasNext()) {
                OMAttribute a = (OMAttribute)attrs.next();
                String s = a.getLocalName();
                if (s.equals(ATTR_TARGET)) {
                    this.fTarget = a.getAttributeValue();
                    continue;
                }
                if (s.equals(ATTR_ID)) {
                    this.fId = a.getAttributeValue();
                    continue;
                }
                this.fAttributes.add(a);
            }
            this.init(encProp);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespace().getName()) && NAME.equals(elem.getLocalName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(OMElement elem) {
        String s = elem.getNamespace() == null ? null : elem.getNamespace().getName();
        return s != null && !s.equals(NAMESPACE);
    }

    public void setTarget(String uri) {
        this.fTarget = uri;
    }

    public String getTarget() {
        return this.fTarget;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public List getAttributes() {
        return this.fAttributes;
    }

    public void addParameter(OMElement param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    @Override
    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement encProp = DOMUtils.createEncOMElement(NAME, factory, parent);
        if (this.fTarget != null) {
            encProp.addAttribute(ATTR_TARGET, Util.normalize(this.fTarget), null);
        }
        if (this.fId != null) {
            encProp.addAttribute(ATTR_ID, Util.normalize(this.fId), null);
        }
        for (OMAttribute a : this.fAttributes) {
            encProp.addAttribute(a);
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Parameters not specified");
        }
        super.addChildElement(encProp, factory);
        return encProp;
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        throw new StructureException("Internal error: creation of EncryptionProperty element not supported with WSSObject");
    }
}

