/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ElementsType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeySize;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.OAEPParams;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class EncryptionMethod
extends ElementsType {
    private static final TraceComponent tc = Tr.register(EncryptionMethod.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KW_AES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KW_AES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KW_AES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final QName ATTR_ALGORITHM_Q = new QName("", "Algorithm");
    private String fAlgorithm;
    private KeySize fKeySize;
    private OAEPParams fOaepParams;
    private AlgorithmParameterSpec fSpec;
    private boolean fDoneSpecCreation;
    private AlgorithmFactory fEngineFactory;

    public EncryptionMethod() {
        this((OMElement)null);
    }

    public EncryptionMethod(OMElement encMeth) {
        super(encMeth);
        if (encMeth != null) {
            if (!EncryptionMethod.isOfType(encMeth)) {
                throw new IllegalArgumentException("Not EncryptionMethod element");
            }
            this.fAlgorithm = encMeth.getAttributeValue(ATTR_ALGORITHM_Q);
            this.init(encMeth);
        }
        this.fDoneSpecCreation = false;
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (KeySize.isOfType(e)) {
                        this.fKeySize = new KeySize(e);
                        continue block4;
                    }
                    if (OAEPParams.isOfType(e)) {
                        this.fOaepParams = new OAEPParams(e);
                        continue block4;
                    }
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(OMElement elem) {
        String s = elem.getNamespace() == null ? null : elem.getNamespace().getName();
        return s != null && !s.equals(NAMESPACE);
    }

    public void setAlgorithm(String uri) {
        this.fAlgorithm = uri;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public AlgorithmParameterSpec getParameterSpec(AlgorithmFactory factory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.fDoneSpecCreation) {
            return this.fSpec;
        }
        this.fEngineFactory = factory;
        this.fSpec = factory.unmarshalParameter(this.fAlgorithm, this.getBase());
        this.fDoneSpecCreation = true;
        return this.fSpec;
    }

    public void setParameterSpec(AlgorithmFactory factory, AlgorithmParameterSpec spec) {
        this.fEngineFactory = factory;
        this.fSpec = spec;
        this.fDoneSpecCreation = true;
    }

    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    @Override
    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement encMeth = DOMUtils.createEncOMElement(NAME, factory, parent);
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        encMeth.addAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm), null);
        if (this.fEngineFactory != null) {
            try {
                this.fEngineFactory.marshalParameter(this.fAlgorithm, this.fSpec, encMeth);
            }
            catch (Exception ex) {
                throw new StructureException(ex.getMessage());
            }
        } else {
            OMElement e;
            if (this.fKeySize != null) {
                e = this.fKeySize.createElement(factory, encMeth);
                encMeth.addChild(e);
            }
            if (this.fOaepParams != null) {
                e = this.fOaepParams.createElement(factory, encMeth);
                encMeth.addChild(e);
            }
            super.addChildElement(encMeth, factory);
        }
        return encMeth;
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptionMethod encMeth = new com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptionMethod(doc);
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        encMeth.setAlgorithm(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fAlgorithm)));
        if (this.fEngineFactory != null) {
            try {
                this.fEngineFactory.marshalParameter(this.fAlgorithm, this.fSpec, encMeth);
            }
            catch (Exception ex) {
                throw new StructureException(ex.getMessage());
            }
        } else {
            if (this.fKeySize != null) {
                encMeth.setKeySize(VariablePartFactory.getInstance().createTextValueWithString(Integer.toString(this.fKeySize.getSize())));
            }
            if (this.fOaepParams != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OAEP marshalled parameter bytes (base64): " + Base64.encode(this.fOaepParams.getParameters()));
                }
                encMeth.setOAEPparams(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(this.fOaepParams.getParameters()));
            }
            super.createElement(encMeth, doc);
        }
        return encMeth;
    }
}

