/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CarriedKeyName;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class EncryptedKey
extends EncryptedType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptedKey";
    private static final String ATTR_RECIPIENT = "Recipient";
    private static final QName ATTR_RECIPIENT_Q = new QName("", "Recipient");
    public static final String TYPE = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    private String fRecipient;
    private ReferenceList fReferenceList;
    private CarriedKeyName fKeyName;

    public EncryptedKey() {
        this((OMElement)null);
    }

    public EncryptedKey(OMElement encKey) {
        super(encKey);
        if (encKey != null) {
            if (!EncryptedKey.isOfType(encKey)) {
                throw new IllegalArgumentException("Not EncryptedKey element");
            }
            this.fRecipient = encKey.getAttributeValue(ATTR_RECIPIENT_Q);
            this.init(encKey);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (ReferenceList.isOfType(e)) {
                        this.fReferenceList = new ReferenceList(e);
                        continue block4;
                    }
                    if (!CarriedKeyName.isOfType(e)) continue block4;
                    this.fKeyName = new CarriedKeyName(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    public void setRecipient(String recipient) {
        this.fRecipient = recipient;
    }

    public String getRecipient() {
        return this.fRecipient;
    }

    public void setReferenceList(ReferenceList refList) {
        this.fReferenceList = refList;
    }

    public ReferenceList getReferenceList() {
        return this.fReferenceList;
    }

    public void setCarriedKeyName(CarriedKeyName keyName) {
        this.fKeyName = keyName;
    }

    public CarriedKeyName getCarriedKeyName() {
        return this.fKeyName;
    }

    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    @Override
    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        OMElement e;
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement encKey = DOMUtils.createEncOMElement(NAME, factory, parent);
        super.createElement(encKey, factory);
        if (this.fRecipient != null) {
            encKey.addAttribute(ATTR_RECIPIENT, Util.normalize(this.fRecipient), null);
        }
        if (this.fReferenceList != null) {
            e = this.fReferenceList.createElement(factory, encKey);
            encKey.addChild(e);
        }
        if (this.fKeyName != null) {
            e = this.fKeyName.createElement(factory, encKey);
            encKey.addChild(e);
        }
        return encKey;
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        WSSObjectElement e;
        com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedKey encKey = new com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptedKey(doc);
        super.createElement(encKey, doc);
        if (this.fRecipient != null && !this.fRecipient.isEmpty()) {
            encKey.setRecipient(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(this.fRecipient)));
        }
        if (this.fReferenceList != null) {
            e = this.fReferenceList.createElement(doc);
            encKey.addChild(e);
        }
        if (this.fKeyName != null) {
            e = this.fKeyName.createElement(doc);
            encKey.addChild(e);
        }
        return encKey;
    }
}

