/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;

public class EncryptedHeader
extends EncryptedData {
    private static final String HEADERNAMESPACE = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    private static final String HEADERNAME = "EncryptedHeader";
    private static final String ATTR_ACTOR = "actor";
    private static final String ATTR_ROLE = "role";
    private static final String ATTR_RELAY = "relay";
    private static final String ATTR_MU = "mustUnderstand";
    private static final QName ATTR_ACTOR_Q = new QName("", "actor");
    private static final QName ATTR_ROLE_Q = new QName("", "role");
    private static final QName ATTR_RELAY_Q = new QName("", "relay");
    private static final QName ATTR_MU_Q = new QName("", "mustUnderstand");
    private String fActor;
    private String fRole;
    private String fRelay;
    private String fMustUnderstand;
    private String fSoapNs;
    private String fWsuNs;
    private String fSoapNsPrefix;
    private String fWsuNsPrefix;
    private String fWsse11NsPrefix;
    private boolean fPreV7Compatibility;

    public EncryptedHeader() {
        this((OMElement)null);
    }

    public EncryptedHeader(OMElement encHeader) {
        super(encHeader);
        if (encHeader != null) {
            if (!EncryptedHeader.isOfType(encHeader)) {
                throw new IllegalArgumentException("Not EncryptedHeader element");
            }
            if (encHeader != null) {
                this.fActor = encHeader.getAttributeValue(ATTR_ACTOR_Q);
                this.fRole = encHeader.getAttributeValue(ATTR_ROLE_Q);
                this.fRelay = encHeader.getAttributeValue(ATTR_RELAY_Q);
                this.fMustUnderstand = encHeader.getAttributeValue(ATTR_MU_Q);
            }
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && HEADERNAME.equals(elem.getLocalName()) && HEADERNAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    public void setMustUnderstand(String mu) {
        this.fMustUnderstand = mu;
    }

    public String getMustUnderstand() {
        return this.fMustUnderstand;
    }

    public void setActor(String actor) {
        this.fActor = actor;
    }

    public String getActor() {
        return this.fActor;
    }

    public void setPreV7Compatibility(boolean preV7Compatibility) {
        this.fPreV7Compatibility = preV7Compatibility;
    }

    public boolean getPreV7Compatibility() {
        return this.fPreV7Compatibility;
    }

    public void setRole(String role) {
        this.fRole = role;
    }

    public String getRole() {
        return this.fRole;
    }

    public void setRelay(String relay) {
        this.fRelay = relay;
    }

    public String getRelay() {
        return this.fRelay;
    }

    public void setSoapNs(String ns) {
        this.fSoapNs = ns;
    }

    public String getSoapNs() {
        return this.fSoapNs;
    }

    public void setSoapNsPrefix(String prefix) {
        this.fSoapNsPrefix = prefix;
    }

    public String getSoapNsPrefix() {
        return this.fSoapNsPrefix;
    }

    public void setWsuNs(String ns) {
        this.fWsuNs = ns;
    }

    public String getWsuNs() {
        return this.fWsuNs;
    }

    public void setWsuNsPrefix(String prefix) {
        this.fWsuNsPrefix = prefix;
    }

    public String getWsuNsPrefix() {
        return this.fWsuNsPrefix;
    }

    public void setWsse11NsPrefix(String prefix) {
        this.fWsse11NsPrefix = prefix;
    }

    public String getWsse11NsPrefix() {
        return this.fWsse11NsPrefix;
    }

    @Override
    public String getNamespaceURI() {
        return HEADERNAMESPACE;
    }

    public OMElement createElement(OMFactory factory, boolean withNsDecl, boolean withSoapNsDecl, boolean withWsuNsDecl, boolean withWsse11NsDecl) throws StructureException {
        OMElement encHeader;
        boolean encHeaderNSDecl;
        OMNamespace encHeaderNS;
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        if (this.fWsse11NsPrefix != null) {
            encHeaderNS = factory.createOMNamespace(HEADERNAMESPACE, this.fWsse11NsPrefix);
            encHeaderNSDecl = withWsse11NsDecl;
        } else {
            encHeaderNS = DOMUtils.WSSE11_NS;
            encHeaderNSDecl = withNsDecl;
        }
        if (factory instanceof SOAPFactory) {
            SOAPFactory soapFactory = (SOAPFactory)factory;
            encHeader = soapFactory.createSOAPHeaderBlock(HEADERNAME, encHeaderNS);
        } else {
            encHeader = factory.createOMElement(HEADERNAME, encHeaderNS);
        }
        if (encHeaderNSDecl) {
            encHeader.declareNamespace(encHeaderNS);
        }
        OMNamespace soapNs = null;
        OMNamespace wsuNs = null;
        if (this.fSoapNsPrefix != null) {
            soapNs = factory.createOMNamespace(this.fSoapNs, this.fSoapNsPrefix);
            if (withSoapNsDecl) {
                encHeader.declareNamespace(this.fSoapNs, this.fSoapNsPrefix);
            }
        }
        if (this.fWsuNsPrefix != null) {
            wsuNs = factory.createOMNamespace(this.fWsuNs, this.fWsuNsPrefix);
            if (withWsuNsDecl) {
                encHeader.declareNamespace(this.fWsuNs, this.fWsuNsPrefix);
            }
        }
        if (this.fActor != null) {
            encHeader.addAttribute(ATTR_ACTOR, Util.normalize(this.fActor), soapNs);
        }
        if (this.fRole != null) {
            encHeader.addAttribute(ATTR_ROLE, Util.normalize(this.fRole), soapNs);
        }
        if (this.fRelay != null) {
            encHeader.addAttribute(ATTR_RELAY, Util.normalize(this.fRelay), soapNs);
        }
        if (this.fMustUnderstand != null) {
            encHeader.addAttribute(ATTR_MU, Util.normalize(this.fMustUnderstand), soapNs);
        }
        super.createElement(encHeader, factory, withNsDecl, wsuNs);
        return encHeader;
    }

    public void initFromEncryptedData(EncryptedData ed) {
        if (ed != null) {
            this.setCipherData(ed.getCipherData());
            this.setEncoding(ed.getEncoding());
            this.setEncryptionMethod(ed.getEncryptionMethod());
            this.setEncryptionProperties(ed.getEncryptionProperties());
            this.setId(ed.getId());
            this.setKeyInfo(ed.getKeyInfo());
            this.setMimeType(ed.getMimeType());
            this.setType(ed.getType());
        }
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader encHeader = new com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader(doc);
        if (this.fActor != null) {
            encHeader.setSoapActor(VariablePartFactory.getInstance().createAttrValueWithString(this.fActor));
        }
        if (this.fRole != null) {
            encHeader.setSoap12Role(VariablePartFactory.getInstance().createAttrValueWithString(this.fRole));
        }
        if (this.fRelay != null) {
            encHeader.setSoap12Relay(VariablePartFactory.getInstance().createAttrValueWithString(this.fRelay));
        }
        if (this.fMustUnderstand != null) {
            VariablePartAttributeValue muAttr = "1".equals(this.fMustUnderstand) ? Utf8ByteConstantsVariableParts.VPA_1 : ("true".equals(this.fMustUnderstand) ? Utf8ByteConstantsVariableParts.VPA_TRUE : ("0".equals(this.fMustUnderstand) ? Utf8ByteConstantsVariableParts.VPA_0 : ("false".equals(this.fMustUnderstand) ? Utf8ByteConstantsVariableParts.VPA_FALSE : VariablePartFactory.getInstance().createAttrValueWithString(this.fMustUnderstand))));
            if (Constants.NS_SOAP.equals(this.fSoapNs)) {
                encHeader.setSoapMustUnderstand(muAttr);
            } else {
                encHeader.setSoap12MustUnderstand(muAttr);
            }
        }
        super.createElement(doc, encHeader);
        return encHeader;
    }
}

