/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Transforms;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class CipherReference
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherReference";
    private static final String ATTR_URI = "URI";
    private static final QName ATTR_URI_Q = new QName("", "URI");
    private String fUri;
    private Transforms fTransforms;

    public CipherReference() {
        this((OMElement)null);
    }

    public CipherReference(OMElement ciphRef) {
        super(ciphRef);
        if (ciphRef != null) {
            if (!CipherReference.isOfType(ciphRef)) {
                throw new IllegalArgumentException("Not CipherReference element");
            }
            this.fUri = ciphRef.getAttributeValue(ATTR_URI_Q);
            this.init(ciphRef);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (!Transforms.isOfType(e)) continue block4;
                    this.fTransforms = new Transforms(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    public void setURI(String uri) {
        this.fUri = uri;
    }

    public String getURI() {
        return this.fUri;
    }

    public void setTransforms(Transforms transs) {
        this.fTransforms = transs;
    }

    public Transforms getTransforms() {
        return this.fTransforms;
    }

    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    @Override
    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement ciphRef = DOMUtils.createEncOMElement(NAME, factory, parent);
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        ciphRef.addAttribute(ATTR_URI, Util.normalize(this.fUri), null);
        if (this.fTransforms != null) {
            OMElement e = this.fTransforms.createElement(factory, ciphRef);
            ciphRef.addChild(e);
        }
        return ciphRef;
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        throw new StructureException("Internal error: creation of CipherReference element not supported with WSSObject");
    }
}

