/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc.type;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class CipherData
extends Type {
    private static final TraceComponent tc = Tr.register(CipherData.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CipherData.class.getName();
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherData";
    private Type fCipherData;

    public CipherData() {
        this((OMElement)null);
    }

    public CipherData(OMElement ciphData) {
        super(ciphData);
        if (ciphData != null) {
            if (!CipherData.isOfType(ciphData)) {
                throw new IllegalArgumentException("Not CipherData element");
            }
            this.init(ciphData);
        }
    }

    public static boolean isOfType(OMElement elem) {
        return elem != null && NAME.equals(elem.getLocalName()) && NAMESPACE.equals(elem.getNamespace() == null ? "" : elem.getNamespace().getName());
    }

    private void init(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return;
        }
        block4: for (OMNode n = ((OMContainer)((Object)node)).getFirstOMChild(); n != null; n = n.getNextOMSibling()) {
            switch (n.getType()) {
                case 1: {
                    OMElement e = (OMElement)n;
                    if (CipherValue.isOfType(e)) {
                        this.fCipherData = new CipherValue(e);
                        continue block4;
                    }
                    if (!CipherReference.isOfType(e)) continue block4;
                    this.fCipherData = new CipherReference(e);
                    continue block4;
                }
                case 9: {
                    this.init(n);
                }
            }
        }
    }

    public void setCipherValue(CipherValue ciphVal) {
        this.fCipherData = ciphVal;
    }

    public void setCipherReference(CipherReference ciphRef) {
        this.fCipherData = ciphRef;
    }

    public Type getCipherData() {
        return this.fCipherData;
    }

    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    @Override
    public OMElement createElement(OMFactory factory, OMElement parent) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        OMElement ciphData = DOMUtils.createEncOMElement(NAME, factory, parent);
        if (this.fCipherData == null) {
            throw new StructureException("Neither CipherValue nor CipherReference specified");
        }
        OMElement e = this.fCipherData.createElement(factory, ciphData);
        ciphData.addChild(e);
        return ciphData;
    }

    @Override
    public WSSObjectElement createElement(WSSObjectDocumentImpl doc) throws StructureException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling CipherData.createElement()");
        }
        com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData cipherData = new com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData(doc);
        if (this.fCipherData != null) {
            if (this.fCipherData instanceof CipherValue) {
                CipherValue cipherValue = (CipherValue)this.fCipherData;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CipherValue.getValue() is " + (cipherValue.getValue() == null ? "null" : "non-null"));
                    Tr.debug(tc, "CipherValue.getByteArrayHolder() is " + (cipherValue.getByteArrayHolder() == null ? "null" : "non-null"));
                }
                if (cipherValue.getByteArrayHolder() != null) {
                    cipherData.setCipherValue(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(cipherValue.getByteArrayHolder()));
                } else if (cipherValue.getValue() != null) {
                    cipherData.setCipherValue(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(cipherValue.getValue()));
                }
                cipherValue.setWSSObjectBase(cipherData);
            } else if (this.fCipherData instanceof CipherReference) {
                WSSObjectElement e = this.fCipherData.createElement(doc);
                cipherData.setCipherReference((com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherReference)e);
                this.fCipherData.setWSSObjectBase(e);
            }
        } else {
            throw new StructureException("Neither CipherValue nor CipherReference specified");
        }
        this.setWSSObjectBase(cipherData);
        return cipherData;
    }
}

