/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;

class ResourceInputStream
extends FilterInputStream {
    private ResourceShower fResourceShower;
    private Object fData;
    private OMElement fEncryptedType;
    private ByteArrayOutputStream fBuffer;

    ResourceInputStream(InputStream in, ResourceShower shower, Object data, OMElement encType) {
        super(in);
        this.fResourceShower = shower;
        this.fData = data;
        this.fEncryptedType = encType;
        this.fBuffer = new ByteArrayOutputStream();
    }

    InputStream getInputStream() {
        return this.in;
    }

    void showResource() {
        try {
            this.fBuffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fResourceShower.showEncryptedResource(this.fBuffer.toByteArray(), this.fData, this.fEncryptedType);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b < 0) {
            this.fBuffer.flush();
            this.showResource();
        } else {
            this.fBuffer.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = super.read(b, off, len);
        if (i < 0) {
            this.fBuffer.flush();
            this.showResource();
        } else {
            this.fBuffer.write(b, off, i);
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        byte[] b = new byte[(int)n];
        int i = this.read(b, 0, b.length);
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fBuffer.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

