/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.PseudoIOException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionInputStream
extends FilterInputStream {
    private EncryptionEngine fEncryptionEngine;
    private AlgorithmFactory fAlgorithmFactory;
    private byte[] fBuffer;
    private int fIndex;
    private boolean fDoneFinal;
    private byte[] fInputBuffer = new byte[65536];
    private static final int BUFFER_SIZE = 65536;

    public EncryptionInputStream(InputStream in, EncryptionEngine engine2, AlgorithmFactory factory) {
        super(in);
        this.fEncryptionEngine = engine2;
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        this.fAlgorithmFactory = factory;
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
    }

    private byte[] getNextBytes() throws IOException {
        byte[] next = null;
        while (!this.fDoneFinal) {
            if (this.in == null) {
                throw new IOException("Input stream closed");
            }
            int readLen = this.in.read(this.fInputBuffer);
            byte[] o = null;
            if (readLen < 0) {
                try {
                    o = this.fEncryptionEngine.doFinal();
                }
                catch (BadPaddingException e) {
                    throw new PseudoIOException(e);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PseudoIOException(e);
                }
                finally {
                    this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
                }
                this.fDoneFinal = true;
            } else {
                o = this.fEncryptionEngine.update(this.fInputBuffer, 0, readLen);
            }
            if (o == null || o.length <= 0) continue;
            next = o;
            break;
        }
        return next;
    }

    private void pour() throws IOException {
        if (this.fBuffer == null || this.fIndex >= this.fBuffer.length) {
            this.fBuffer = this.getNextBytes();
            this.fIndex = 0;
        }
    }

    @Override
    public int read() throws IOException {
        this.pour();
        int next = -1;
        if (this.fBuffer != null) {
            next = this.fBuffer[this.fIndex++] & 0xFF;
        }
        return next;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off >= b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.pour();
        if (this.fBuffer == null) {
            return -1;
        }
        int copyLen = this.fBuffer.length - this.fIndex;
        if (len < copyLen) {
            copyLen = len;
        }
        System.arraycopy(this.fBuffer, this.fIndex, b, off, copyLen);
        this.fIndex += copyLen;
        return copyLen;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining;
        int i;
        if (n <= 0L) {
            return 0L;
        }
        byte[] b = new byte[2048];
        for (remaining = n; remaining > 0L && (i = this.read(b, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)i) {
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

