/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.core.KeyGenerationEngine;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.axiom.OMWSSObjectDataSource;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsse11.EncryptedHeader;
import com.ibm.ws.wssecurity.wssobject.interfaces.Parent;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectNormalWriter;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsNSPrefixPair;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.BufferedEncryptionOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DOMSerializationEngine;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedTypeContainer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;

public class EncryptionContext {
    private static final TraceComponent tc = Tr.register(EncryptionContext.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final boolean DEBUG = false;
    private Object fData;
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private Key fKey;
    private OutputStream fOut;
    private AlgorithmFactory fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private HWKeyCache fHWKeyCache;
    private OMElement fEncryptedType;
    private WSSObjectElement fWSSObjectEncryptedType;
    private Object fEncryptedData;
    private ResourceShower shower;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private String _hwConfigName = null;
    private String _hwKeyStoreName = null;
    private String allCryptoOffload = null;
    private String encAlgorithm = null;
    private Boolean _offload = Boolean.TRUE;
    private boolean _mtomOptimize = false;
    private String _endpointReference = null;
    private boolean _encryptEmptyContent = true;
    private boolean debug = false;

    public EncryptionContext() {
        this.fAlgorithmFactory = AlgorithmFactory.getInstance();
        this.fHWKeyCache = HWKeyCache.getInstance();
    }

    public void setEncAlgorithm(String ea) {
        this.encAlgorithm = ea;
    }

    public void setHWKeyStoreName(String keyStoreName) {
        this._hwKeyStoreName = keyStoreName;
    }

    public void setOffload(Boolean offload) {
        this._offload = offload;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String hwConfigName) {
        this._hwConfigName = hwConfigName;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public void setEndpointReference(String endpointReference) {
        this._endpointReference = endpointReference;
    }

    public String getEndpointReference() {
        return this._endpointReference;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWEncAlgorithm(this.encAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setHWAccelerationProvider(Provider p, Integer hardwareCacheSize) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = p;
            this.fHWKeyCache.setProvider(p, hardwareCacheSize);
        }
    }

    public void setHWKeyStoreProvider(Provider p) {
        this.hwKeyStoreProvider = p;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public void clearLocalProviderMap() {
        this.fAlgorithmFactory.clearLocalProviderMap();
    }

    public void setHWConfig(WSSGeneratorConfig gconfig, EncryptionGeneratorConfig config2) {
        Provider p;
        Map<Object, Object> props = config2.getProperties();
        Map<Object, Object> gprops = gconfig.getProperties();
        this.setHWConfigName((String)gprops.get("HWCONFIG"));
        String cryptoOffload = (String)gprops.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        this.setOffload((Boolean)gprops.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (this.shouldChangeProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + this.getHWConfigName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance(this.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                this.setHWAccelerationProvider(p, hardwareCacheSize);
                this.setCryptoOffloadProperty(cryptoOffload);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + p.getName());
                }
            }
        }
        this.setHWKeyStoreName((String)props.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        if (this.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + this.getHWKeyStoreName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance(this.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                this.setHWKeyStoreProvider(p);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + p.getName());
                }
            }
        }
    }

    public void saveHWproviderIntoAlgorithmFactory(String algorithm) {
        if (this.isHWAccelerationProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else if (!(algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
            if (this.debug) {
                System.out.println("HWC: Hardware provider instance is : " + this.getHWAccelerationProvider().getName());
            }
        }
        if (this.isHWKeyStoreProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else if (!(algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
    }

    public void finalizeHWConfig() {
        this.clearLocalProviderMap();
        if (this.isHWAccelerationProvider()) {
            ConfigUtil.returnHWCryptoProviderInstance(this.getHWConfigName(), this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            ConfigUtil.returnHWCryptoProviderInstance(this.getHWKeyStoreName(), this.getHWKeyStoreProvider());
        }
    }

    public void setCryptoOffloadProperty(String cryptoOffload) {
        this.allCryptoOffload = cryptoOffload;
    }

    public void setMTOMOptimize(boolean mtomOptimize) {
        this._mtomOptimize = mtomOptimize;
    }

    public void setData(InputStream in) {
        this.fData = in;
    }

    public void setData(byte[] in) {
        this.fData = in;
    }

    public void setData(OMElement elem) {
        this.fData = elem;
    }

    public void setData(WSSObjectElement elem) {
        this.fData = elem;
    }

    public void setData(Key key) {
        this.fData = key;
    }

    public void setEncryptedData(Object encryptedData) {
        this.fEncryptedData = encryptedData;
    }

    public void setEncryptedType(OMElement encType, String type, OMElement encMeth, OMElement keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    public void setEncryptedType(EncryptedType encType, String type, EncryptionMethod encMeth, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    public void clearEncryptedType() {
        this.fEncryptedType = null;
        this.fWSSObjectEncryptedType = null;
        this.fEncryptedData = null;
    }

    public boolean setHWKeyFromCache(PublicKey publicKey) throws Exception {
        this.fKey = this.fHWKeyCache.translate(publicKey);
        return this.fKey != null;
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setOutputStream(OutputStream out) {
        this.fOut = out;
    }

    public void setAlgorithmFactory(AlgorithmFactory factory) {
        if (factory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
        this.fAlgorithmFactory = factory;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver2) {
        this.fKeyInfoResolver = resolver2;
    }

    public void setEncryptEmptyContent(boolean b) {
        this._encryptEmptyContent = b;
    }

    public InputStream getEncryptedType() {
        ByteArrayInputStream in = null;
        if (this.fEncryptedType != null) {
            in = new ByteArrayInputStream(this.serialize(this.fEncryptedType));
        }
        return in;
    }

    private byte[] serialize(OMElement elem) {
        BufferExportableByteArrayOutputStream os = new BufferExportableByteArrayOutputStream(0);
        DOMSerializationEngine.XMLElement dse = new DOMSerializationEngine.XMLElement();
        ((DOMSerializationEngine)dse).setOutputStream(os);
        try {
            ArrayList<OMElement> al = new ArrayList<OMElement>();
            al.add(elem);
            ((DOMSerializationEngine)dse).serialize(al.iterator());
            os.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return os.toByteArray();
    }

    public OMElement getEncryptedTypeAsElement() {
        return this.fEncryptedType;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void encrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt()");
        }
        OutputStream os = null;
        if (this.fEncryptedData != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encrypt() - EncryptedData already obtained");
            }
        } else {
            if (this.fData == null) {
                throw new NullPointerException("Data not specified");
            }
            if (this.fData instanceof InputStream) {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of InputStream");
                }
                os = this.getEncryptionOutputStream();
                if (this.shower != null) {
                    os = this.getResourceOutputStream(os);
                }
                Util.getBytes((InputStream)this.fData, os);
                if (this.shower != null) {
                    os = this.showResource((ResourceOutputStream)os);
                }
            } else if (this.fData instanceof byte[]) {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of byte[]");
                }
                os = this.getEncryptionOutputStream();
                if (this.shower != null) {
                    os = this.getResourceOutputStream(os);
                }
                os.write((byte[])this.fData);
                if (this.shower != null) {
                    os = this.showResource((ResourceOutputStream)os);
                }
            } else if (this.fData instanceof OMElement) {
                if (this.debug) {
                    System.out.println("HWC: EncryptionContext, encrypt, fData is instance of OMElement");
                }
                os = this.getEncryptionOutputStream();
                if (this.shower != null) {
                    os = this.getResourceOutputStream(os);
                }
                this.serialize((OMElement)this.fData, os);
                if (this.shower != null) {
                    os = this.showResource((ResourceOutputStream)os);
                }
            } else if (this.fData instanceof WSSObjectElement) {
                if (this.debug) {
                    System.out.println("HWC: EncryptionContext, encrypt, fData is instance of WSSObjectElement");
                }
                os = this.getEncryptionOutputStream();
                if (this.shower != null) {
                    os = this.getResourceOutputStream(os);
                }
                this.serialize((WSSObjectElement)this.fData, os);
                if (this.shower != null) {
                    os = this.showResource((ResourceOutputStream)os);
                }
            } else if (this.fData instanceof Key) {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, EncryptionContext, encrypt, fData is instance of Key");
                }
                EncryptionEngine ee = this.getEncryptionEngine(3);
                os = this.getOutputStream();
                try {
                    os.write(ee.wrap((Key)this.fData));
                }
                catch (OutOfMemoryError e) {
                    if (this.isHWAccelerationProvider()) {
                        HWKeyCache.setCapacityReached();
                        os = this.getOutputStream();
                        os.write(ee.wrap((Key)this.fData));
                    }
                    throw e;
                }
                os.flush();
                this.fAlgorithmFactory.releaseEncryptionEngine(ee);
                if (this.shower != null) {
                    this.showResource((Key)this.fData);
                }
            }
        }
        this.doFinal(os);
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, encrypt, after clearLocalProviderMap");
            Provider p = (Provider)this.fAlgorithmFactory.getLocalProvider("HWCONFIG");
            if (p != null) {
                System.out.println("HWC: EncryptionContext, encrypt, alg factory's hw provider: " + p.getName());
            } else {
                System.out.println("HWC: EncryptionContext, encrypt, alg factory's hw provider is cleared");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt()");
        }
    }

    public OutputStream getEncryptionOutputStream() throws IOException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        FilterOutputStream out;
        EncryptionEngine ee = this.getEncryptionEngine(1);
        OutputStream os = this.getOutputStream();
        if (ee instanceof EncryptionEngineExtended) {
            BufferedEncryptionOutputStream beos = (BufferedEncryptionOutputStream)BufferedEncryptionOutputStream.getFactory().getObject();
            beos.init(os, (EncryptionEngineExtended)ee, this.fAlgorithmFactory);
            out = beos;
        } else {
            out = new EncryptionOutputStream(os, ee, this.fAlgorithmFactory);
        }
        return out;
    }

    public EncryptionEngine getEncryptionEngine(int opMode) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod em = this.fEncryptedTypeContainer.getEM();
        if (em == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String s = em.getAlgorithm();
        if (s == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        Key k = this._getKey();
        if (k == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        this.saveHWproviderIntoAlgorithmFactory(s);
        EncryptionEngine engine2 = this.fAlgorithmFactory.getEncryptionEngine(s);
        AlgorithmParameterSpec spec = em.getParameterSpec(this.fAlgorithmFactory);
        engine2.init(opMode, k, spec);
        return engine2;
    }

    private Key _getKey() throws KeyInfoResolvingException {
        KeyInfo ki;
        if (this.fKey == null && (ki = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve(ki, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private OutputStream getOutputStream() throws StructureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream()");
        }
        OutputStream out = null;
        if (this.hasCipherValue()) {
            out = new BufferExportableByteArrayOutputStream();
        } else if (this.fOut != null) {
            out = this.fOut;
        } else {
            throw new NullPointerException("Neither CipherValue element nor output stream specified");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream() returns instance of " + out.getClass().getName());
        }
        return out;
    }

    private boolean hasCipherValue() throws StructureException {
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        return this.getCipherValue(et) != null;
    }

    private CipherValue getCipherValue(EncryptedType encType) throws StructureException {
        CipherData cd = encType.getCipherData();
        if (cd == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type t = cd.getCipherData();
        if (t == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        CipherValue ciphVal = null;
        if (t instanceof CipherValue) {
            ciphVal = (CipherValue)t;
        }
        return ciphVal;
    }

    private void serialize(OMElement elem, OutputStream out) throws IOException, NoSuchAlgorithmException, StructureException {
        String s = this.fEncryptedTypeContainer.getType();
        if (s == null) {
            throw new StructureException("Type attribute not specified");
        }
        Iterator nl = null;
        if (s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            ArrayList<OMElement> a = new ArrayList<OMElement>();
            a.add(elem);
            nl = a.iterator();
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            nl = DOMUtil.getChildNodes(elem);
        } else {
            throw new StructureException("Unknown type: " + s);
        }
        DOMSerializationEngine dse = this.fAlgorithmFactory.getDOMSerializationEngine(s);
        dse.setOutputStream(out);
        dse.serialize(nl);
    }

    private void serialize(WSSObjectElement elem, OutputStream out) throws IOException, NoSuchAlgorithmException, StructureException {
        String s;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serialize(WSSObjectElement elem, OutputStream out)");
        }
        if ((s = this.fEncryptedTypeContainer.getType()) == null) {
            throw new StructureException("Type attribute not specified");
        }
        WSSObjectNormalWriter wSSObjectWriter = new WSSObjectNormalWriter(out);
        if (s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            elem.serialize(wSSObjectWriter, true);
        } else if (s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            if (elem.getChildrenSize() > 0) {
                ArrayList<WSSObject> children = elem.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    WSSObject child = children.get(i);
                    child.serialize(wSSObjectWriter, false);
                }
            }
        } else {
            throw new StructureException("Unknown encryption content type: " + s);
        }
        wSSObjectWriter.flush();
        out.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serialize(WSSObjectElement elem, OutputStream out)");
        }
    }

    public void doFinal(OutputStream out) throws IOException, StructureException {
        FilterOutputStream os;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doFinal(OutputStream out)");
        }
        if (out instanceof EncryptionOutputStream) {
            os = (EncryptionOutputStream)out;
            ((EncryptionOutputStream)os).doFinal();
            os.flush();
            out = ((EncryptionOutputStream)os).getOutputStream();
        } else if (out instanceof BufferedEncryptionOutputStream) {
            os = (BufferedEncryptionOutputStream)out;
            ((BufferedEncryptionOutputStream)os).doFinal();
            ((BufferedEncryptionOutputStream)os).flush();
            out = ((BufferedEncryptionOutputStream)os).getOutputStream();
            ((BufferedEncryptionOutputStream)os).close();
        }
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        if (et.getBaseType() == 1) {
            this.fEncryptedType = this.getEncryptedType(et, out);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OMElement EncryptedType obtained");
            }
        } else if (et.getBaseType() == 2) {
            this.fWSSObjectEncryptedType = this.getWSSObjectEncryptedType(et, out);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSObject EncryptedType obtained");
            }
        } else {
            throw new NullPointerException("No base XML element for EncryptedData nor EncryptedKey specified");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doFinal(OutputStream out)");
        }
    }

    private OMElement getEncryptedType(EncryptedType et, OutputStream out) throws StructureException {
        CipherValue cv = this.getCipherValue(et);
        if (cv != null) {
            if (this.fEncryptedData != null && this.fEncryptedData instanceof ByteArrayHolder) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encrypted data ByteArrayHolder set into CipherData");
                }
                ByteArrayHolder encryptedByteArrayHolder = (ByteArrayHolder)this.fEncryptedData;
                this.fEncryptedData = null;
                this.setWSSObjectCipherValue(cv, encryptedByteArrayHolder);
            } else {
                ByteArrayHolder bah;
                ByteArrayOutputStream os = (ByteArrayOutputStream)out;
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (os instanceof BufferExportableByteArrayOutputStream) {
                    bah = ((BufferExportableByteArrayOutputStream)os).getByteArrayHolder();
                } else {
                    byte[] value = os.toByteArray();
                    bah = new ByteArrayHolder(value, 0, value.length);
                }
                this.setCipherValue(cv, bah);
            }
        }
        return et.getBase();
    }

    private WSSObjectElement getWSSObjectEncryptedType(EncryptedType et, OutputStream out) throws StructureException {
        CipherValue cv = this.getCipherValue(et);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CipherValue WSSObject base is " + (cv.getWSSObjectBase() == null ? "null" : "non-null"));
        }
        if (cv != null) {
            if (this.fEncryptedData != null && this.fEncryptedData instanceof ByteArrayHolder) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Encrypted data ByteArrayHolder set into CipherData");
                }
                ByteArrayHolder encryptedByteArrayHolder = (ByteArrayHolder)this.fEncryptedData;
                this.fEncryptedData = null;
                this.setWSSObjectCipherValue(cv, encryptedByteArrayHolder);
            } else {
                ByteArrayOutputStream os = (ByteArrayOutputStream)out;
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ByteArrayHolder bah = null;
                if (os instanceof BufferExportableByteArrayOutputStream) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got ByteArrayHolder from ByteArrayOutputStream");
                    }
                    bah = ((BufferExportableByteArrayOutputStream)os).getByteArrayHolder();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Had to copy byte[] from ByteArrayOutputStream");
                    }
                    byte[] value = os.toByteArray();
                    bah = new ByteArrayHolder(value, 0, value.length);
                }
                this.setWSSObjectCipherValue(cv, bah);
            }
        }
        return et.getWSSObjectBase();
    }

    private void setCipherValue(CipherValue ciphVal, ByteArrayHolder value) throws StructureException {
        OMElement e = ciphVal.getBase();
        ciphVal = new CipherValue();
        ciphVal.setByteArrayHolder(value);
        OMElement e2 = ciphVal.createElement(e.getOMFactory(), null, this._mtomOptimize);
        DOMUtil.removeChildNodes(e);
        DOMUtil.moveChildNodes(e2, e);
    }

    private void setWSSObjectCipherValue(CipherValue ciphVal, ByteArrayHolder bah) throws StructureException {
        WSSObjectElement e = ciphVal.getWSSObjectBase();
        if (e != null) {
            if (!(e instanceof com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData)) {
                throw new StructureException("Expected base WSSObject of type CipherData, found " + e.getClass().getName());
            }
        } else {
            throw new StructureException("Base CipherData WSSObject not found");
        }
        com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData cipherData = (com.ibm.ws.wssecurity.wssobject.impl.xenc.CipherData)e;
        cipherData.setCipherValue(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(bah));
    }

    public Key generateKey() throws Exception {
        try {
            this.fKey = this.fHWKeyCache.generate(this.getEndpointReference());
        }
        catch (OutOfMemoryError e) {
            HWKeyCache.setCapacityReached();
            this.fKey = this.fHWKeyCache.generate(this.getEndpointReference());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.fKey == null) {
            KeyGenerationEngine ke = this.getKeyGenerationEngine();
            this.fKey = ke.generateKey();
            this.fAlgorithmFactory.releaseKeyGenerationEngine(ke);
            this.fHWKeyCache.addGeneratedKey(this.getEndpointReference(), this.fKey);
            if (this.debug) {
                System.out.println("HWC: EncryptionContext generateKey, about to call clearLocalProviderMap");
            }
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, generateKey, after clearLocalProviderMap");
                Provider p = (Provider)this.fAlgorithmFactory.getLocalProvider("HWCONFIG");
                if (p != null) {
                    System.out.println("HWC: EncryptionContext, generateKey, alg factory's hw provider: " + p.getName());
                } else {
                    System.out.println("HWC: EncryptionContext, generateKey, alg factory's hw provider is cleared");
                }
            }
        }
        return this.fKey;
    }

    private KeyGenerationEngine getKeyGenerationEngine() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        EncryptionMethod em = this.fEncryptedTypeContainer.getEM();
        if (em == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String s = em.getAlgorithm();
        if (s == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        if (this.isHWAccelerationProvider()) {
            this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            if (this.debug) {
                System.out.println("HWC: EncryptionContext, getKeyGenerationEngine, hwprovider: " + this.getHWAccelerationProvider().getName());
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        if (this.debug) {
            System.out.println("HWC: EncryptionContext, getKeyGenerationEngine, about to call AlgorithmFactory's and uri is : " + s);
        }
        KeyGenerationEngine engine2 = this.fAlgorithmFactory.getKeyGenerationEngine(s, this.fEncryptedTypeContainer.getType());
        AlgorithmParameterSpec spec = em.getParameterSpec(this.fAlgorithmFactory);
        engine2.init(spec);
        return engine2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace() throws StructureException {
        if (this.fEncryptedType == null && this.fWSSObjectEncryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
        }
        if (this.fData instanceof OMElement) {
            OMElement e1 = (OMElement)this.fData;
            if (this.fEncryptedType == null) {
                this.fEncryptedType = this.createOMSourcedElement(e1.getOMFactory(), e1 instanceof SOAPHeaderBlock);
            }
            OMElement e2 = this.fEncryptedType;
            String s = this.fEncryptedTypeContainer.getType();
            if (s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                e2 = (OMElement)DOMUtil.replaceNode((OMNode)e1, e2);
            } else {
                if (!s.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown type: " + s);
                Iterator children = DOMUtil.getChildNodes(e1);
                if (children != null && children.hasNext()) {
                    e2 = (OMElement)DOMUtil.replaceNodes(children, e2);
                } else if (this._encryptEmptyContent) {
                    if (e2.getParent() != null) {
                        e2.detach();
                    }
                    e1.addChild(e2);
                }
            }
            this.fEncryptedType = e2;
            return;
        } else {
            if (!(this.fData instanceof WSSObjectElement)) throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
            if (this.fWSSObjectEncryptedType == null) {
                throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
            }
            WSSObjectElement e1 = (WSSObjectElement)this.fData;
            WSSObjectElement e2 = this.fWSSObjectEncryptedType;
            String s = this.fEncryptedTypeContainer.getType();
            if (s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Parent parent = e1.getParent();
                ArrayList<WSSObject> children = parent.getChildren();
                int index = children.indexOf(e1);
                parent.setChild(index, e2);
                return;
            } else {
                int size;
                if (!s.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown encryption content type: " + s);
                for (int i = size = (children = e1.getChildren()) == null ? 0 : children.size(); i > 0; --i) {
                    e1.removeChild(i - 1);
                }
                e1.addChild(e2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace(OMElement elem) throws StructureException {
        if (this.fEncryptedType == null && this.fWSSObjectEncryptedType == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element obtained");
        }
        if (elem == null) throw new RuntimeException("No element specified to replace");
        if (this.fEncryptedType == null) {
            this.fEncryptedType = this.createOMSourcedElement(elem.getOMFactory(), elem instanceof SOAPHeaderBlock);
        }
        OMElement e1 = elem;
        OMElement e2 = this.fEncryptedType;
        String s = this.fEncryptedTypeContainer.getType();
        if (s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            e2 = (OMElement)DOMUtil.replaceNode((OMNode)e1, e2);
        } else {
            if (!s.equals("http://www.w3.org/2001/04/xmlenc#Content")) throw new StructureException("Unknown type: " + s);
            Iterator children = DOMUtil.getChildNodes(e1);
            if (children != null && children.hasNext()) {
                e2 = (OMElement)DOMUtil.replaceNodes(children, e2);
            } else if (this._encryptEmptyContent) {
                if (e2.getParent() != null) {
                    e2.detach();
                }
                e1.addChild(e2);
            }
        }
        this.fEncryptedType = e2;
    }

    private OMElement createOMSourcedElement(OMFactory factory, boolean useSOAPHeaderBlock) {
        String namespace;
        String localName;
        String prefix;
        OMSourcedElement el = null;
        WSSObjectElement wssObj = this.fWSSObjectEncryptedType;
        if (wssObj instanceof EncryptedHeader) {
            prefix = Utf8ByteConstantsNSPrefixPair.PRE_NS_WSSE11;
            localName = LocalNameConstants.LocalNamesWSSE11.LN_ENCRYPTED_HEADER;
            namespace = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
        } else {
            prefix = Utf8ByteConstantsNSPrefixPair.PRE_NS_ENC;
            localName = LocalNameConstants.LocalNamesXENC.LN_ENCRYPTED_DATA;
            namespace = "http://www.w3.org/2001/04/xmlenc#";
        }
        WSSObjectDocumentImpl doc = wssObj.getWSSObjectDocument();
        QName qname = new QName(namespace, localName, prefix);
        OMWSSObjectDataSource omwssoda = new OMWSSObjectDataSource(qname, doc);
        if (useSOAPHeaderBlock && factory instanceof SOAPFactory) {
            OMNamespace omnamespace = factory.createOMNamespace(namespace, prefix);
            el = ((SOAPFactory)factory).createSOAPHeaderBlock(localName, omnamespace, omwssoda);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created OMSourcedElement that is also SOAPHeaderBlock from WSSObject. prefix = " + prefix + ", namespace = " + namespace + ", localName = " + localName);
            }
        } else {
            el = new OMSourcedElementImpl(qname, factory, omwssoda);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created OMSourcedElement from WSSObject. prefix = " + prefix + ", namespace = " + namespace + ", localName = " + localName);
            }
        }
        return el;
    }

    public void setResourceShower(ResourceShower shower) {
        this.shower = shower;
    }

    private ResourceOutputStream getResourceOutputStream(OutputStream out) {
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et.getBaseType() == 2) {
            return new ResourceOutputStream(out, this.shower, this.fData, et.getWSSObjectBase());
        }
        return new ResourceOutputStream(out, this.shower, this.fData, et.getBase());
    }

    private OutputStream showResource(ResourceOutputStream out) {
        out.showResource();
        return out.getOutputStream();
    }

    private void showResource(Key key) {
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et.getBaseType() == 2) {
            this.shower.showEncryptedResource(key.getEncoded(), this.fData, et.getWSSObjectBase());
        } else {
            this.shower.showEncryptedResource(key.getEncoded(), this.fData, et.getBase());
        }
    }
}

