/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import org.apache.axiom.om.OMElement;

class EncryptedTypeContainer {
    private EncryptedType fEncryptedType;
    private String fType;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;

    EncryptedTypeContainer(OMElement encType, String type, OMElement encMeth, OMElement keyInfo) {
        this.fType = type;
        this.setEncryptionMethod(encMeth);
        this.setKeyInfo(keyInfo);
        this.setEncryptedType(encType);
    }

    EncryptedTypeContainer(EncryptedType encType, String type, EncryptionMethod encMeth, KeyInfo keyInfo) {
        this.fType = type;
        this.fEncryptionMethod = encMeth;
        this.fKeyInfo = keyInfo;
        this.setET(encType);
    }

    void setEncryptedType(OMElement encType) {
        EncryptedType et = null;
        if (encType != null) {
            et = EncryptedType.getInstance(encType);
        }
        this.setET(et);
    }

    void setET(EncryptedType encType) {
        this.fEncryptedType = encType;
        if (encType != null) {
            if (this.fType == null) {
                this.fType = encType.getType();
                if (this.fType == null && encType instanceof EncryptedHeader) {
                    this.fType = "http://www.w3.org/2001/04/xmlenc#Element";
                }
            }
            if (this.fEncryptionMethod == null) {
                this.fEncryptionMethod = encType.getEncryptionMethod();
            }
            if (this.fKeyInfo == null) {
                this.fKeyInfo = encType.getKeyInfo();
            }
        }
    }

    OMElement getEncryptedType() {
        OMElement encType = null;
        if (this.fEncryptedType != null) {
            encType = this.fEncryptedType.getBase();
        }
        return encType;
    }

    EncryptedType getET() {
        return this.fEncryptedType;
    }

    void setType(String type) {
        this.fType = type;
    }

    String getType() {
        return this.fType;
    }

    void setEncryptionMethod(OMElement encMeth) {
        EncryptionMethod em = null;
        if (encMeth != null) {
            em = new EncryptionMethod(encMeth);
        }
        this.fEncryptionMethod = em;
    }

    void setEM(EncryptionMethod encMeth) {
        this.fEncryptionMethod = encMeth;
    }

    OMElement getEncryptionMethod() {
        OMElement encMeth = null;
        if (this.fEncryptionMethod != null) {
            encMeth = this.fEncryptionMethod.getBase();
        }
        return encMeth;
    }

    EncryptionMethod getEM() {
        return this.fEncryptionMethod;
    }

    void setKeyInfo(OMElement keyInfo) {
        KeyInfo ki = null;
        if (keyInfo != null) {
            ki = new KeyInfo(keyInfo);
        }
        this.fKeyInfo = ki;
    }

    void setKI(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    OMElement getKeyInfo() {
        OMElement keyInfo = null;
        if (this.fKeyInfo != null) {
            keyInfo = this.fKeyInfo.getBase();
        }
        return keyInfo;
    }

    KeyInfo getKI() {
        return this.fKeyInfo;
    }
}

