/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.MultipleInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.AdoptingDOMBuilder;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.BufferedEncryptionInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedTypeContainer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceInputStream;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.XMLWriter;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DsTransforms;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedType;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Transforms;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.xml.sax.EntityResolver;

public class DecryptionContext {
    private static final boolean DEBUG = false;
    private static final TraceComponent tc = Tr.register(DecryptionContext.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final Class[] adoptNodeArgs = new Class[]{OMNode.class};
    private EncryptedTypeContainer fEncryptedTypeContainer;
    private EncryptionMethod fEncryptionMethod;
    private Key fKey;
    private AlgorithmFactory fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private IDResolver fIdResolver;
    private EntityResolver fEntityResolver;
    private EncryptedKeyRetriever fEncryptedKeyRetriever;
    private HWKeyCache fHWKeyCache;
    private Object fData;
    private String fType;
    private String fMimeType;
    private String fEncoding;
    private ResourceShower shower;
    private String encAlgorithm = null;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private String _hwConfigName = null;
    private String _hwKeyStoreName = null;
    private String allCryptoOffload = null;
    private Boolean _offload = Boolean.TRUE;
    private boolean debug = false;
    private Map fContext = null;

    public DecryptionContext() {
        this.fAlgorithmFactory = AlgorithmFactory.getInstance();
        this.fHWKeyCache = HWKeyCache.getInstance();
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setEncAlgorithm(String ea) {
        this.encAlgorithm = ea;
    }

    public String getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public void setHWKeyStoreName(String keyStoreName) {
        this._hwKeyStoreName = keyStoreName;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String hwConfigName) {
        this._hwConfigName = hwConfigName;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public void setOffload(Boolean offload) {
        this._offload = offload;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWEncAlgorithm(this.encAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public void setHWAccelerationProvider(Provider p, Integer hardwareCacheSize) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = p;
            this.fHWKeyCache.setProvider(p, hardwareCacheSize);
        }
    }

    public void setHWKeyStoreProvider(Provider p) {
        this.hwKeyStoreProvider = p;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public void setCryptoOffloadProperty(String cryptoOffload) {
        this.allCryptoOffload = cryptoOffload;
    }

    public String getCryptoOffladProperty() {
        return this.allCryptoOffload;
    }

    public void clearLocalProviderMap() {
        this.fAlgorithmFactory.clearLocalProviderMap();
    }

    public void initHWConfig(WSSConsumerConfig gconfig, Map<Object, Object> context) {
        Map<Object, Object> gprops = gconfig.getProperties();
        this.setHWConfigName((String)gprops.get("HWCONFIG"));
        String cryptoOffload = (String)gprops.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        this.setHWKeyStoreName((String)context.remove("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        if (this.shouldChangeProvider()) {
            Provider p;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + this.getHWConfigName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance(this.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                this.setHWAccelerationProvider(p, hardwareCacheSize);
                this.setCryptoOffloadProperty(cryptoOffload);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + p.getName());
                }
            }
        }
    }

    public void setHWAcceleration() {
        if (this.useHWKeyStore()) {
            Provider p;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + this.getHWKeyStoreName());
                Tr.debug(tc, "Encryption Algorithm is : " + this.getEncAlgorithm());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance(this.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                this.setHWKeyStoreProvider(p);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + p.getName());
                }
            }
        }
    }

    public void releaseHWAcceleration() {
        if (this.useHWKeyStore()) {
            ConfigUtil.returnHWCryptoProviderInstance(this.getHWKeyStoreName(), this.getHWKeyStoreProvider());
            this.setHWKeyStoreProvider(null);
            this.setHWKeyStoreName(null);
        }
    }

    public void finalizeHWConfig() {
        if (this.isHWAccelerationProvider()) {
            ConfigUtil.returnHWCryptoProviderInstance(this.getHWConfigName(), this.getHWAccelerationProvider());
        }
        if (this.useHWKeyStore()) {
            ConfigUtil.returnHWCryptoProviderInstance(this.getHWKeyStoreName(), this.getHWKeyStoreProvider());
        }
    }

    public void setEncryptedType(InputStream encType, String type, OMElement encMeth, OMElement keyInfo) throws IOException, XMLStreamException {
        OMElement e = null;
        if (encType != null) {
            StAXOMBuilder builder = new StAXOMBuilder(encType);
            e = builder.getDocumentElement();
        }
        this.setEncryptedType(e, type, encMeth, keyInfo);
    }

    public void setEncryptedType(OMElement encType, String type, OMElement encMeth, OMElement keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    void setEncryptedType(EncryptedType encType, String type, EncryptionMethod encMeth, KeyInfo keyInfo) {
        this.fEncryptedTypeContainer = new EncryptedTypeContainer(encType, type, encMeth, keyInfo);
    }

    public void setEncryptionMethod(OMElement encMeth) {
        EncryptionMethod em = null;
        if (encMeth != null) {
            em = new EncryptionMethod(encMeth);
        }
        this.setEncryptionMethod(em);
    }

    void setEncryptionMethod(EncryptionMethod encMeth) {
        this.fEncryptionMethod = encMeth;
    }

    public void updateHWCache() throws Exception {
        this.fKey = this.fHWKeyCache.translate(this.fKey);
    }

    public void setHWKey(Key key) throws Exception {
        this.fKey = this.fHWKeyCache.translate(key);
    }

    public void setKey(Key key) {
        this.fKey = key;
    }

    public void setAlgorithmFactory(AlgorithmFactory factory) {
        if (factory == null) {
            throw new NullPointerException("AlgorithmFacotry is null.");
        }
        this.fAlgorithmFactory = factory;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return this.fAlgorithmFactory;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver2) {
        this.fKeyInfoResolver = resolver2;
    }

    public void setIdResolver(IDResolver resolver2) {
        this.fIdResolver = resolver2;
    }

    public void setEntityResolver(EntityResolver resolver2) {
        this.fEntityResolver = resolver2;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever retriever) {
        this.fEncryptedKeyRetriever = retriever;
    }

    public Object getData() {
        return this.fData;
    }

    public Iterator getDataAsNodeList() throws IOException, StructureException, XMLStreamException {
        if (this.fData != null) {
            if (this.fType == null) {
                throw new StructureException("Type attribute not specified");
            }
            if (this.fType.equals("http://www.w3.org/2001/04/xmlenc#Element") || this.fType.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (this.fData instanceof InputStream) {
                    OMElement e = this.fEncryptedTypeContainer.getET().getBase();
                    InputStream is = (InputStream)this.fData;
                    if (EncryptedHeader.isOfType(e)) {
                        OMElement ed = e.getFirstElement();
                        this.fData = DOMUtil.getChildNodes(this.parseData(is, ed, true));
                        this.fData = this.replaceOMElementWithSOAPHeaderBlock((Iterator)this.fData, e);
                    } else {
                        this.fData = DOMUtil.getChildNodes(this.parseData(is, e, true));
                        if (e instanceof SOAPHeaderBlock) {
                            this.fData = this.replaceOMElementWithSOAPHeaderBlock((Iterator)this.fData, e);
                        }
                    }
                } else if (!(this.fData instanceof Iterator)) {
                    throw new RuntimeException("Instance of unknown class: " + this.fData.getClass().getName());
                }
            } else {
                throw new StructureException("Unknown type: " + this.fType);
            }
        }
        return (Iterator)this.fData;
    }

    private Iterator replaceOMElementWithSOAPHeaderBlock(Iterator omHeaders, OMElement e) throws StructureException {
        ArrayList<OMNode> soapHeaders = new ArrayList<OMNode>();
        SOAPFactory soapFactory = null;
        OMFactory factory = e.getOMFactory();
        if (factory instanceof SOAPFactory) {
            soapFactory = (SOAPFactory)factory;
        } else {
            String namespaceURI = ((OMElement)e.getParent()).getNamespace().getNamespaceURI();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
                soapFactory = OMAbstractFactory.getSOAP11Factory();
            } else if ("http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI)) {
                soapFactory = OMAbstractFactory.getSOAP12Factory();
            }
        }
        if (soapFactory == null) {
            throw new StructureException("No SOAPFactory.");
        }
        while (omHeaders.hasNext()) {
            OMNode node = (OMNode)omHeaders.next();
            if (node instanceof OMElement) {
                OMElement omHeaderBlock = (OMElement)node;
                SOAPHeaderBlock soapHeaderBlock = soapFactory.createSOAPHeaderBlock(omHeaderBlock.getLocalName(), omHeaderBlock.getNamespace());
                Iterator nss = omHeaderBlock.getAllDeclaredNamespaces();
                while (nss.hasNext()) {
                    soapHeaderBlock.declareNamespace((OMNamespace)nss.next());
                }
                Iterator attrs = omHeaderBlock.getAllAttributes();
                while (attrs.hasNext()) {
                    soapHeaderBlock.addAttribute((OMAttribute)attrs.next());
                }
                Iterator i = omHeaderBlock.getChildren();
                while (i.hasNext()) {
                    OMNode child = (OMNode)i.next();
                    soapHeaderBlock.addChild(child);
                }
                soapHeaders.add(soapHeaderBlock);
                continue;
            }
            soapHeaders.add(node);
        }
        return soapHeaders.iterator();
    }

    public String getType() {
        return this.fType;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public Key getKey() {
        return this.fKey;
    }

    public void decrypt() throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        if (this.fEncryptedTypeContainer == null) {
            throw new NullPointerException("Neither encrypted data nor key specified");
        }
        EncryptedType et = this.fEncryptedTypeContainer.getET();
        if (et == null) {
            throw new NullPointerException("Neither EncryptedData nor EncryptedKey element specified");
        }
        if (et instanceof EncryptedData || et instanceof EncryptedHeader) {
            if (this.debug) {
                System.out.println("HWC: decrypt, data");
            }
            EncryptionEngine ee = this.getEncryptionEngine(2);
            InputStream is = this.getInputStream();
            if (ee instanceof EncryptionEngineExtended) {
                BufferedEncryptionInputStream beis = (BufferedEncryptionInputStream)BufferedEncryptionInputStream.getFactory().getObject();
                beis.init(is, (EncryptionEngineExtended)ee, this.fAlgorithmFactory);
                this.fData = beis;
            } else {
                this.fData = new EncryptionInputStream(is, ee, this.fAlgorithmFactory);
            }
            if (this.debug) {
                System.out.println("HWC: decrypt data, after EncryptionInputStream");
            }
            if (this.shower != null) {
                this.fData = this.getResourceInputStream((InputStream)this.fData);
            }
        } else if (et instanceof EncryptedKey) {
            if (this.debug) {
                System.out.println("HWC: decrypt, key");
            }
            EncryptionEngine ee = this.getEncryptionEngine(4);
            byte[] bb = Util.getBytes(this.getInputStream());
            if (this.fEncryptionMethod == null) {
                throw new NullPointerException("EncryptionMethod element not specified");
            }
            String s1 = this.fEncryptionMethod.getAlgorithm();
            if (s1 == null) {
                throw new StructureException("Algorithm attribute not specified");
            }
            String s2 = this.fEncryptedTypeContainer.getType();
            try {
                this.fData = ee.unwrap(bb, s1, s2);
            }
            catch (OutOfMemoryError e) {
                if (this.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    s2 = this.fEncryptedTypeContainer.getType();
                    this.fData = ee.unwrap(bb, s1, s2);
                }
                throw e;
            }
            this.fAlgorithmFactory.releaseEncryptionEngine(ee);
            if (this.debug) {
                System.out.println("HWC: decrypt, key unwrap is done");
            }
            if (this.shower != null) {
                this.showResource((Key)this.fData);
            }
        }
        this.fType = this.fEncryptedTypeContainer.getType();
        this.fMimeType = et.getMimeType();
        this.fEncoding = et.getEncoding();
    }

    private EncryptionEngine getEncryptionEngine(int opMode) throws InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException {
        EncryptionMethod em = this.fEncryptedTypeContainer.getEM();
        if (em == null) {
            throw new StructureException("EncryptionMethod element not specified");
        }
        String s = em.getAlgorithm();
        if (s == null) {
            throw new StructureException("Algorithm attribute not specified");
        }
        Key k = this._getKey();
        if (k == null) {
            throw new NullPointerException("Key not specified or obtained");
        }
        if (this.isHWAccelerationProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else if (!(s.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        if (this.isHWKeyStoreProvider()) {
            if ("true".equals(this.allCryptoOffload)) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else if (!(s.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || s.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc"))) {
                this.fAlgorithmFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
            } else {
                this.fAlgorithmFactory.getProviderMaps().remove("HWCONFIG");
            }
        }
        EncryptionEngine engine2 = this.fAlgorithmFactory.getEncryptionEngine(s);
        AlgorithmParameterSpec spec = em.getParameterSpec(this.fAlgorithmFactory);
        engine2.init(opMode, k, spec);
        return engine2;
    }

    public Key _getKey() throws KeyInfoResolvingException {
        String s;
        KeyInfo ki;
        if (this.fKey == null && (ki = this.fEncryptedTypeContainer.getKI()) != null && this.fKeyInfoResolver != null) {
            this.fKey = this.fKeyInfoResolver.resolve(ki, this.fEncryptedTypeContainer.getEM());
        }
        if (this.fKey == null && (s = this.fEncryptedTypeContainer.getET().getId()) != null && this.fEncryptedKeyRetriever != null && this.fKeyInfoResolver != null) {
            KeyInfo ki2 = new KeyInfo();
            Iterator i = this.fEncryptedKeyRetriever.retrieve(s).iterator();
            while (i.hasNext()) {
                ki2.addEncryptedKey((EncryptedKey)i.next());
            }
            this.fKey = this.fKeyInfoResolver.resolve(ki2, this.fEncryptedTypeContainer.getEM());
        }
        return this.fKey;
    }

    private InputStream getInputStream() throws StructureException, XSignatureException {
        CipherData cd = this.fEncryptedTypeContainer.getET().getCipherData();
        if (cd == null) {
            throw new StructureException("CipherData element not specified");
        }
        Type ty = cd.getCipherData();
        byte[] bb = null;
        if (ty == null) {
            throw new StructureException("Neither CipherValue nor CipherReference element specified");
        }
        if (ty instanceof CipherValue) {
            InputStream is = ((CipherValue)ty).getValueAsInputStream();
            if (is == null) {
                throw new StructureException("Cipher value not specified");
            }
            return is;
        }
        if (ty instanceof CipherReference) {
            CipherReference cr = (CipherReference)ty;
            String s = cr.getURI();
            if (s == null) {
                throw new StructureException("URI attribute not specified");
            }
            OMElement e = cr.getBase();
            Transforms tr = cr.getTransforms();
            if (tr != null) {
                DsTransforms tr2 = new DsTransforms();
                Iterator i = tr.getTransforms().iterator();
                while (i.hasNext()) {
                    tr2.addTransform((Transform)i.next());
                }
                e = e.cloneOMElement();
                OMElement e2 = tr2.createElement(e.getOMFactory(), e);
                e.addChild(e2);
            }
            SignatureContext sc = new SignatureContext();
            sc.setAlgorithmFactory(this.fAlgorithmFactory);
            sc.setIDResolver(this.fIdResolver);
            sc.setEntityResolver(this.fEntityResolver);
            bb = (byte[])sc.retrieve(e);
        }
        return new ByteArrayInputStream(bb);
    }

    public void replace() throws IOException, StructureException, XMLStreamException {
        Iterator nl = this.getDataAsNodeList();
        if (nl == null) {
            throw new NullPointerException("Data not obtained");
        }
        if (nl.hasNext()) {
            this.fData = DOMUtil.replaceNode((OMNode)this.fEncryptedTypeContainer.getET().getBase(), nl);
        } else {
            OMElement oldNode = this.fEncryptedTypeContainer.getET().getBase();
            if (oldNode != null && DOMUtil.hasParentNode(oldNode)) {
                oldNode.detach();
            }
            ArrayList nodeList = new ArrayList();
            this.fData = nodeList.iterator();
        }
    }

    private static void serializeNamespaceDecls(OMNode node, XMLWriter xw) throws IOException {
        Map m = DOMUtil.getNamespaceDeclAttrNodes(node);
        if (m == null || m.size() <= 0) {
            return;
        }
        for (OMNamespace a : m.values()) {
            if (a.getPrefix() == null || a.getPrefix().length() == 0) {
                xw.printText(" xmlns=\"");
            } else {
                if (a.getPrefix().equals("xml")) continue;
                xw.printText(" xmlns:");
                xw.printText(a.getPrefix());
                xw.printText("=\"");
            }
            String s = a.getName();
            if (s == null) {
                s = "";
            }
            xw.printEscaped(s);
            xw.printText('\"');
        }
    }

    public static byte[] wrapData(byte[] data, OMNode node) {
        BufferExportableByteArrayOutputStream os = new BufferExportableByteArrayOutputStream(0);
        try {
            XMLWriter xw = new XMLWriter(os);
            xw.printText("<dummy");
            DecryptionContext.serializeNamespaceDecls(node, xw);
            xw.printText('>');
            xw.flush();
            if (data != null) {
                os.write(data);
            }
            xw.printText("</dummy>");
            xw.flush();
            xw.close();
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toByteArray();
    }

    private OMElement parseData(InputStream is2, OMNode node, boolean closeReader) throws IOException, XMLStreamException {
        if (node == null) {
            return null;
        }
        InputStream[] isArray = new InputStream[3];
        BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
        XMLWriter xw = new XMLWriter(bebaos);
        xw.printText("<dummy");
        DecryptionContext.serializeNamespaceDecls(node, xw);
        xw.printText('>');
        xw.flush();
        bebaos.flush();
        ByteArrayHolder dummyStartTag = bebaos.getByteArrayHolder();
        xw.close();
        isArray[0] = new ByteArrayInputStream(dummyStartTag.getValue(), dummyStartTag.getOffset(), dummyStartTag.getLength());
        isArray[1] = is2;
        isArray[2] = new ByteArrayInputStream(Constants.DUMMY_END_TAG_UTF8_BYTE_ARRAY);
        MultipleInputStream mis = new MultipleInputStream(isArray);
        AdoptingDOMBuilder builder = new AdoptingDOMBuilder();
        return builder.parseElement(mis, closeReader);
    }

    public void setResourceShower(ResourceShower shower) {
        this.shower = shower;
    }

    private ResourceInputStream getResourceInputStream(InputStream in) {
        return new ResourceInputStream(in, this.shower, this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    private void showResource(Key key) {
        this.shower.showEncryptedResource(key.getEncoded(), this.fData, this.fEncryptedTypeContainer.getEncryptedType());
    }

    public Map getContext() {
        return this.fContext;
    }

    public void setContext(Map context) {
        this.fContext = context;
    }
}

