/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Serializer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.DOMUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public abstract class DOMSerializationEngine {
    public abstract String getType();

    public abstract void setOutputStream(OutputStream var1);

    public abstract void serialize(Iterator var1) throws IOException;

    private static Throwable unwrapException(TransformerException exc) {
        Throwable thr = exc.getException();
        if (thr == null) {
            thr = exc;
        }
        return thr;
    }

    public static class XMLElement
    extends XMLContent {
        @Override
        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void serialize(ArrayList nodeList) throws IOException {
            if (nodeList != null) {
                OMElement n = DOMUtil.getFirstElement(nodeList);
                ArrayList<OMElement> nl = new ArrayList<OMElement>();
                if (n != null) {
                    nl.add(n);
                }
                nodeList = nl;
            }
            super.serialize(nodeList.iterator());
        }
    }

    public static class XMLContent
    extends DOMSerializationEngine {
        private Writer fOut;
        private WriterChainHolder fWriterChainHolder;

        @Override
        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        @Override
        public void setOutputStream(OutputStream out) {
            this.fWriterChainHolder = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            this.fWriterChainHolder.getProxyOutputStream().setOutputStream(out);
            this.fOut = this.fWriterChainHolder.getBufferedWriter();
        }

        @Override
        public void serialize(Iterator nodeList) throws IOException {
            if (nodeList != null) {
                while (nodeList.hasNext()) {
                    Serializer.serialize((OMNode)nodeList.next(), this.fOut);
                }
                this.fOut.flush();
                this.fWriterChainHolder.getProxyOutputStream().flush();
                WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(this.fWriterChainHolder);
            }
        }
    }
}

