/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.enc;

import com.ibm.ws.wssecurity.core.EncryptionEngineExtended;
import com.ibm.ws.wssecurity.util.ObjectFactory;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.enc.PseudoIOException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class BufferedEncryptionInputStream
extends FilterInputStream {
    private static final BufferedEncryptionInputStreamFactory FACTORY = new BufferedEncryptionInputStreamFactory();
    protected static final int INPUT_BUFFER_INITIAL_CAPACITY = 1024;
    protected static final int OUTPUT_BUFFER_INITIAL_CAPACITY = 0;
    private EncryptionEngineExtended fEncryptionEngine;
    private AlgorithmFactory fAlgorithmFactory;
    private byte[] fBuffer;
    private byte[] fInputBuffer;
    private int fOutputIndex;
    private int fOutputSize;
    private boolean fDoneFinal;

    public static final BufferedEncryptionInputStreamFactory getFactory() {
        return FACTORY;
    }

    public BufferedEncryptionInputStream() {
        super(null);
        BufferedEncryptionInputStream eis = FACTORY.getObjectWithoutCreateNewInstance();
        if (eis != null) {
            this.fInputBuffer = eis.fInputBuffer;
            this.fBuffer = eis.fBuffer;
            return;
        }
        this.fInputBuffer = new byte[1024];
        this.fBuffer = new byte[0];
    }

    public BufferedEncryptionInputStream(InputStream in, EncryptionEngineExtended engine2, AlgorithmFactory factory) {
        this();
        this.init(in, engine2, factory);
    }

    public void init(InputStream in, EncryptionEngineExtended engine2, AlgorithmFactory factory) {
        this.in = in;
        this.fEncryptionEngine = engine2;
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
        this.fAlgorithmFactory = factory;
        if (this.fAlgorithmFactory == null) {
            throw new NullPointerException("AlgorithmFactory is null.");
        }
        this.fOutputIndex = 0;
        this.fOutputSize = 0;
        this.fDoneFinal = false;
    }

    @Override
    public void reset() {
        if (!this.fDoneFinal) {
            this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
        }
        this.in = null;
        this.fEncryptionEngine = null;
        this.fAlgorithmFactory = null;
    }

    @Override
    public void close() throws IOException {
        super.close();
        BufferedEncryptionInputStream.getFactory().releaseObject(this);
    }

    private void getNextBytes() throws IOException {
        while (!this.fDoneFinal) {
            int estimatedOutputSize;
            if (this.in == null) {
                throw new IOException("Input stream closed");
            }
            int readLen = this.in.read(this.fInputBuffer);
            byte[] o = null;
            if (readLen < 0) {
                try {
                    estimatedOutputSize = this.fEncryptionEngine.getOutputSize(0);
                    if (estimatedOutputSize > this.fBuffer.length) {
                        this.fBuffer = new byte[estimatedOutputSize];
                    }
                    if ((o = this.fEncryptionEngine.doFinal()) == null) {
                        this.fOutputSize = 0;
                        continue;
                    }
                    if (o.length > this.fBuffer.length) {
                        this.fBuffer = o;
                        this.fOutputSize = o.length;
                        continue;
                    }
                    System.arraycopy(o, 0, this.fBuffer, 0, o.length);
                    this.fOutputSize = o.length;
                    continue;
                }
                catch (BadPaddingException e) {
                    throw new PseudoIOException(e);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PseudoIOException(e);
                }
                finally {
                    this.fAlgorithmFactory.releaseEncryptionEngine(this.fEncryptionEngine);
                    this.fOutputIndex = 0;
                    this.fDoneFinal = true;
                    continue;
                }
            }
            estimatedOutputSize = this.fEncryptionEngine.getOutputSize(readLen);
            if (estimatedOutputSize > this.fBuffer.length) {
                this.fBuffer = new byte[estimatedOutputSize];
            }
            this.fOutputSize = 0;
            try {
                this.fOutputSize = this.fEncryptionEngine.update(this.fInputBuffer, 0, readLen, this.fBuffer, 0);
            }
            catch (ShortBufferException e) {
                throw new IOException(e);
            }
            if (this.fOutputSize <= 0) continue;
            this.fOutputIndex = 0;
            break;
        }
    }

    private void pour() throws IOException {
        if (this.fBuffer == null || this.fOutputIndex >= this.fOutputSize) {
            this.getNextBytes();
        }
    }

    @Override
    public int read() throws IOException {
        this.pour();
        int next = -1;
        if (this.fBuffer != null && this.fOutputIndex < this.fOutputSize) {
            next = this.fBuffer[this.fOutputIndex++] & 0xFF;
        }
        return next;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off >= b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.pour();
        if (this.fBuffer == null) {
            return -1;
        }
        int copyLen = this.fOutputSize - this.fOutputIndex;
        if (copyLen == 0 && this.fDoneFinal) {
            return -1;
        }
        if (len < copyLen) {
            copyLen = len;
        }
        System.arraycopy(this.fBuffer, this.fOutputIndex, b, off, copyLen);
        this.fOutputIndex += copyLen;
        return copyLen;
    }

    @Override
    public long skip(long n) throws IOException {
        long remaining;
        int i;
        if (n <= 0L) {
            return 0L;
        }
        byte[] b = new byte[2048];
        for (remaining = n; remaining > 0L && (i = this.read(b, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)i) {
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public static class BufferedEncryptionInputStreamFactory
    extends ObjectFactory<BufferedEncryptionInputStream> {
        private BufferedEncryptionInputStreamFactory() {
        }

        @Override
        protected BufferedEncryptionInputStream createNewInstance() {
            return new BufferedEncryptionInputStream();
        }

        @Override
        protected void reset(BufferedEncryptionInputStream eis) {
            eis.reset();
        }

        protected BufferedEncryptionInputStream getObjectWithoutCreateNewInstance() {
            return (BufferedEncryptionInputStream)this.pool.get();
        }
    }
}

