/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.util;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.om.xpath.DocumentNavigator;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;

public class XPathUtil {
    private static final boolean DEBUG = false;

    private XPathUtil() {
    }

    public static Object evalXPath(OMDocument doc, String expression) {
        try {
            AXIOMXPath xpath = new AXIOMXPath(expression);
            SimpleNamespaceContext context = new SimpleNamespaceContext();
            context.addElementNamespaces(new DocumentNavigator(), doc.getOMDocumentElement());
            xpath.setNamespaceContext(context);
            return xpath.evaluate(doc);
        }
        catch (JaxenException trae) {
            throw new RuntimeException(trae.getMessage());
        }
    }

    public static Vector fixTree(OMNode elem) {
        Vector decls = new Vector();
        XPathUtil.fixElement(elem, decls);
        return decls;
    }

    private static void fixElement(OMNode elem, Vector decls) {
        if (elem.getType() == 1) {
            OMElement el = (OMElement)elem;
            Hashtable alldecls = XPathCanonicalizer.collectNamespaceNodesInAncestors(elem, false);
            Enumeration en = alldecls.elements();
            while (en.hasMoreElements()) {
                OMNamespace ns = (OMNamespace)en.nextElement();
                if (!(ns.getPrefix() != null && ns.getPrefix().length() != 0 || ns.getName() != null && ns.getName().length() != 0)) continue;
                Iterator nsIte = el.getAllDeclaredNamespaces();
                boolean find = false;
                while (nsIte.hasNext()) {
                    OMNamespace _ns = (OMNamespace)nsIte.next();
                    if ((_ns.getPrefix() != null || ns.getPrefix() != null) && !_ns.getPrefix().equals(ns.getPrefix())) continue;
                    find = true;
                }
                if (find) continue;
                ns = new OMNamespaceWithOwner(el, ns);
                el.declareNamespace(ns);
                decls.addElement(ns);
            }
        }
        for (OMNode child = ((OMContainer)((Object)elem)).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            switch (child.getType()) {
                case 1: 
                case 9: {
                    XPathUtil.fixElement(child, decls);
                }
            }
        }
    }

    public static void cleanTree(Vector decls) {
    }

    public static class AXIOMXPathWithIR
    extends BaseXPath {
        public AXIOMXPathWithIR(String xpathExpr, DocumentNavigatorWithIR navigator) throws JaxenException {
            super(xpathExpr, navigator);
        }
    }

    public static class DocumentNavigatorWithIR
    extends DocumentNavigator {
        IDResolver idresolver;

        public DocumentNavigatorWithIR(IDResolver idresolver) {
            this.idresolver = idresolver;
        }

        @Override
        public Object getElementById(Object contextNode, String elementId) {
            OMElement el;
            OMDocument doc = contextNode instanceof OMDocument ? (OMDocument)contextNode : DOMUtil.getOwnerDocument((OMNode)contextNode);
            if (this.idresolver != null && (el = this.idresolver.resolveID(doc, elementId)) != null) {
                return el;
            }
            return super.getElementById(contextNode, elementId);
        }
    }
}

