/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.util;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;

public class HWKeyCache {
    private static final TraceComponent tc = Tr.register(HWKeyCache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLS_NAME = "HWkeyCache";
    private static HWKeyCache s_theInstance;
    private static Provider _provider;
    private static HashMap fKey2TKey;
    private static HashMap fTKey2TTime;
    private static LinkedList fKey;
    private static Hashtable fAlg2Factory;
    private static int maxKeysOnCard;
    private static long entryRefresh;
    private static byte[] lock;
    private static boolean cacheSizeSet;

    private HWKeyCache() {
        fAlg2Factory = new Hashtable();
        fKey2TKey = new HashMap();
        fTKey2TTime = new HashMap();
        fKey = new LinkedList();
    }

    public void setScanParameters(long _entryRefreshHours) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  setScanParameters(_entryRefreshHours[" + _entryRefreshHours + " hours]");
        }
        if ((entryRefresh = _entryRefreshHours * 3600000L) > 300000L) {
            entryRefresh -= 300000L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  entryRefresh:  " + entryRefresh + " ms");
        }
    }

    public static boolean isHWSigAlgorithm(String a) {
        boolean rc = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  isHWSigAlgorithm(String a[" + a + "])");
        }
        if (a != null && (a.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || a.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1"))) {
            rc = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "HWKC:  isHWSigAlgorithm(String a) returns boolean[" + rc + "]");
        }
        return rc;
    }

    public static boolean isHWEncAlgorithm(String a) {
        boolean rc = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  isHWEncAlgorithm(String a[" + a + "])");
        }
        if (a != null && (a.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || a.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"))) {
            rc = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  isHWEncAlgorithm(String a) returns boolean[" + rc + "]");
        }
        return rc;
    }

    public static HWKeyCache getInstance() {
        return s_theInstance;
    }

    public void setProvider(Provider provider, Integer hardwareCacheSize) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "HWKC:  setProvider(Provider provider[" + provider + "])");
            }
            if (_provider == null && provider != null) {
                _provider = provider;
                maxKeysOnCard = hardwareCacheSize;
                try {
                    fAlg2Factory.put("RSA", KeyFactory.getInstance("RSA", provider));
                    fAlg2Factory.put("DSA", KeyFactory.getInstance("DSA", provider));
                }
                catch (NoSuchAlgorithmException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.processException(e, CLS_NAME, "setProvider_1");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  setProvider(Provider provider[" + provider + "])");
        }
    }

    public static boolean cacheInitialized() {
        return _provider != null && maxKeysOnCard > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Key generate(String endpointReference) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  Caching Key for endpoing:  generate(String endpointReference[" + endpointReference + "])");
        }
        Key _key = null;
        Long translatedTime = null;
        if (endpointReference == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  getting cached for endpointReference:  endpointReference == null, cannot generate");
            }
        } else {
            byte[] byArray = lock;
            // MONITORENTER : lock
            _key = (Key)fKey2TKey.get(endpointReference);
            if (_key != null && entryRefresh > 0L && ((translatedTime = (Long)fTKey2TTime.get(_key)) == null || System.currentTimeMillis() - translatedTime > entryRefresh)) {
                if (tc.isDebugEnabled()) {
                    if (translatedTime == null) {
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      key to be refreshed, translatedTime:  null");
                    } else {
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      key to be refreshed, translatedTime:  " + translatedTime);
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      currentTime:  " + System.currentTimeMillis());
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      entryRefresh:  " + entryRefresh);
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      key is " + (System.currentTimeMillis() - translatedTime) + " ms old");
                    }
                }
                HWKeyCache.remove(endpointReference);
                _key = null;
            }
            if (_key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HWKC:  CacheKey for endpointReference:  Key [" + endpointReference.hashCode() + "], Translated Key [" + _key.hashCode() + "] retrieved from cache.");
                }
                fKey.remove(endpointReference);
                fKey.addFirst(endpointReference);
            }
            // MONITOREXIT : byArray
        }
        if (!tc.isEntryEnabled()) return _key;
        Tr.exit(tc, "HWKC:  setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) returns Translated Key[" + _key + "]");
        return _key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGeneratedKey(String endpointReference, Key key) {
        if (endpointReference == null || key == null) return;
        byte[] byArray = lock;
        synchronized (lock) {
            fKey2TKey.put(endpointReference, key);
            fKey.addFirst(endpointReference);
            fTKey2TTime.put(key, new Long(System.currentTimeMillis()));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGeneratedKey(byte[] wrappedKey, Key key) {
        if (wrappedKey == null || key == null) return;
        byte[] byArray = lock;
        synchronized (lock) {
            fKey2TKey.put(wrappedKey, key);
            fKey.addFirst(wrappedKey);
            fTKey2TTime.put(key, new Long(System.currentTimeMillis()));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Key generate(byte[] wrappedKey) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  Caching Key for endpoing:  generate(String wrappedKey[" + wrappedKey + "])");
        }
        Key _key = null;
        Long translatedTime = null;
        if (wrappedKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  getting cached for endpointReference:  endpointReference == null, cannot generate");
            }
        } else {
            byte[] byArray = lock;
            // MONITORENTER : lock
            _key = (Key)fKey2TKey.get(wrappedKey);
            if (_key != null && entryRefresh > 0L && ((translatedTime = (Long)fTKey2TTime.get(_key)) == null || System.currentTimeMillis() - translatedTime > entryRefresh)) {
                if (tc.isDebugEnabled()) {
                    if (translatedTime == null) {
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      key to be refreshed, translatedTime:  null");
                    } else {
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      key to be refreshed, translatedTime:  " + translatedTime);
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      currentTime:  " + System.currentTimeMillis());
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      entryRefresh:  " + entryRefresh);
                        Tr.debug(tc, "HWKC:  CacheKey for endpointReference:      key is " + (System.currentTimeMillis() - translatedTime) + " ms old");
                    }
                }
                HWKeyCache.remove(wrappedKey);
                _key = null;
            }
            if (_key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HWKC:  CacheKey for endpointReference:  Key [" + wrappedKey.hashCode() + "], Translated Key [" + _key.hashCode() + "] retrieved from cache.");
                }
                fKey.remove(wrappedKey);
                fKey.addFirst(wrappedKey);
            }
            // MONITOREXIT : byArray
        }
        if (!tc.isEntryEnabled()) return _key;
        Tr.exit(tc, "HWKC:  setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) returns Translated Key[" + _key + "]");
        return _key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Key translate(Key key) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  translate(Key key[" + key + "])");
        }
        Key _key = null;
        Long translatedTime = null;
        if (!HWKeyCache.cacheInitialized()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  KeyStore not initialized");
            }
        } else if (key == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  key == null, cannot translate");
            }
        } else {
            byte[] byArray = lock;
            // MONITORENTER : lock
            _key = (Key)fKey2TKey.get(key);
            if (_key != null && entryRefresh > 0L) {
                translatedTime = (Long)fTKey2TTime.get(_key);
                if (translatedTime == null || System.currentTimeMillis() - translatedTime > entryRefresh) {
                    if (tc.isDebugEnabled()) {
                        if (translatedTime == null) {
                            Tr.debug(tc, "HWKC:  key to be refreshed, translatedTime:  null");
                        } else {
                            Tr.debug(tc, "HWKC:  key to be refreshed, translatedTime:  " + translatedTime);
                            Tr.debug(tc, "HWKC:      currentTime:  " + System.currentTimeMillis());
                            Tr.debug(tc, "HWKC:      entryRefresh:  " + entryRefresh);
                            Tr.debug(tc, "HWKC:      key is " + (System.currentTimeMillis() - translatedTime) + " ms old");
                        }
                    }
                    HWKeyCache.remove(key);
                    _key = null;
                }
                if (tc.isDebugEnabled() && !(_key instanceof PKCS11Key)) {
                    Tr.debug(tc, "_key is not an instanceof PKCS11Key");
                }
            }
            if (_key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HWKC:  Key [" + key.hashCode() + "], Translated Key [" + _key.hashCode() + "] retrieved from cache.");
                }
                fKey.remove(key);
                fKey.addFirst(key);
            } else {
                KeyFactory kf = null;
                Throwable savedException = null;
                try {
                    block40: {
                        block39: {
                            block38: {
                                if (fKey.size() >= maxKeysOnCard) {
                                    HWKeyCache.reduceKeysOnCardPercent(75);
                                }
                                try {
                                    kf = (KeyFactory)fAlg2Factory.get(key.getAlgorithm());
                                    if (kf == null) {
                                        String algorithm = key.getAlgorithm();
                                        kf = KeyFactory.getInstance(algorithm, _provider);
                                        fAlg2Factory.put(algorithm, kf);
                                    }
                                }
                                catch (Exception e) {
                                    if (!tc.isDebugEnabled()) break block38;
                                    Tr.debug(tc, "HWKC:  Exception caught:  new keyfactory needed for algorithm: [" + key.getAlgorithm() + "]");
                                }
                            }
                            try {
                                _key = kf.translateKey(key);
                                if (_key != null && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HWKC:  Key [" + key.hashCode() + "], Translated Key [" + _key.hashCode() + "] translated to card.");
                                }
                            }
                            catch (OutOfMemoryError e) {
                                if (!cacheSizeSet) {
                                    HWKeyCache.setMaxKeysOnCardPercent(80);
                                    HWKeyCache.reduceKeysOnCardPercent(75);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "HWKC:  OutOfMemoryError from first _keyStore.setKeyEntry: " + e);
                                        Tr.processException(e, CLS_NAME, "translate_1");
                                    }
                                }
                                savedException = e;
                            }
                            catch (Exception e) {
                                savedException = e;
                                if (!tc.isDebugEnabled()) break block39;
                                Tr.debug(tc, "HWKC:  Exception caught in KeyCache.setKeyEntry(): " + e);
                                Tr.processException(e, CLS_NAME, "translate_2");
                            }
                        }
                        if (_key == null && savedException == null) {
                            try {
                                _key = kf.translateKey(key);
                                if (_key != null && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HWKC:  Key [" + key.hashCode() + "], Translated Key [" + _key.hashCode() + "] translated to card.");
                                }
                            }
                            catch (OutOfMemoryError e) {
                                savedException = e;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HWKC:  OutOfMemoryError from 2nd _keyStore.setKeyEntry: " + e);
                                    Tr.processException(e, CLS_NAME, "translate_3");
                                }
                            }
                            catch (Exception e) {
                                savedException = e;
                                if (!tc.isDebugEnabled()) break block40;
                                Tr.debug(tc, "HWKC:  Exception caught in 2nd KeyCache.setKeyEntry(): " + e);
                                Tr.processException(e, CLS_NAME, "translate_4");
                            }
                        }
                    }
                    if (_key == null) {
                        if (savedException == null) throw new Exception("Unable to translate key");
                        throw new Exception("Unable to translate key", savedException);
                    }
                    fKey2TKey.put(key, _key);
                    fKey.addFirst(key);
                    fTKey2TTime.put(_key, new Long(System.currentTimeMillis()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HWKC:  Key [" + key.hashCode() + "], Translated Key [" + _key.hashCode() + "] stored in cache.");
                    }
                }
                catch (Exception e) {
                    _key = null;
                    if (!tc.isDebugEnabled()) throw e;
                    Tr.debug(tc, "HWKC:  Exception caught in setKeyEntry: " + e);
                    Tr.processException(e, CLS_NAME, "translate_5");
                    throw e;
                }
            }
            // MONITOREXIT : byArray
        }
        if (!tc.isEntryEnabled()) return _key;
        Tr.exit(tc, "HWKC:  setKeyEntry(String alias, Key key, char[] password, Certificate[] chain) returns Translated Key[" + _key + "]");
        return _key;
    }

    private static boolean remove(Key key) {
        boolean rc;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "HWKC:  remove(Key[" + key.hashCode() + "])");
            }
            rc = false;
            fKey.remove(key);
            PKCS11Key _key = (PKCS11Key)fKey2TKey.remove(key);
            fTKey2TTime.remove(_key);
            if (_key != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HWKC:  key [" + key.hashCode() + "], translated key [" + _key.hashCode() + "] removed from cache");
                }
                try {
                    _key.rm();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HWKC:  Key [" + key.hashCode() + "], Translated Key [" + _key.hashCode() + "] destroyed on card.");
                    }
                    rc = true;
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "HWKC:  Exception caught");
                    e.printStackTrace(System.err);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  remove(Key) returns boolean[" + rc + "]");
        }
        return rc;
    }

    private static void remove(String endpointReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  CacheKey for endpointReference:  remove(Key[" + endpointReference.hashCode() + "])");
        }
        fKey.remove(endpointReference);
        fTKey2TTime.remove(endpointReference);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  CacheKey for endpointReference:  remove(Key)");
        }
    }

    private static void remove(byte[] wrappedKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  CacheKey for endpointReference:  remove(Key[" + wrappedKey.hashCode() + "])");
        }
        fKey.remove(wrappedKey);
        fTKey2TTime.remove(wrappedKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  CacheKey for endpointReference:  remove(Key)");
        }
    }

    private static boolean removeLast() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  removeLast()");
        }
        boolean rc = false;
        Object lastKey = fKey.getLast();
        if (lastKey instanceof Key) {
            rc = HWKeyCache.remove((Key)lastKey);
        } else if (lastKey instanceof String) {
            HWKeyCache.remove((String)lastKey);
            rc = true;
        } else if (lastKey instanceof byte[]) {
            HWKeyCache.remove((byte[])lastKey);
            rc = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "HWKC:  removeLast() found key of unsupported type in the list.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  removeLast() returns boolean[" + rc + "]");
        }
        return rc;
    }

    private static boolean removeLast(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  removeLast(int n[" + n + "])");
        }
        boolean rc = false;
        if (n > fKey.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  _" + n + "_ exceeds the _" + fKey.size() + "_ entries cached");
            }
            n = fKey.size();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  cache size before:  fKey[" + fKey.size() + "], fKey2Tkey[" + fKey2TKey.size() + "]");
            }
            for (int i = 0; i < n; ++i) {
                rc = HWKeyCache.removeLast();
                if (rc) continue;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "HWKC:  removeLast() failed, _" + n + "_ is too large");
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HWKC:  cache size after:  fKey[" + fKey.size() + "], fKey2Tkey[" + fKey2TKey.size() + "]");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  removeLast(int n) returns boolean[" + rc + "]");
        }
        return rc;
    }

    private static boolean reduceKeysOnCardPercent(int percent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  reduceKeysOnCardPercent(int percent[" + percent + "])");
        }
        int n = fKey.size() - maxKeysOnCard * percent / 100;
        boolean rc = HWKeyCache.removeLast(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  reduceKeysOnCard(int percent) returns boolean[" + rc + "]");
        }
        return rc;
    }

    private static int setMaxKeysOnCardPercent(int percent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  setMaxKeysOnCardPercent(int percent[" + percent + "])");
        }
        maxKeysOnCard = fKey.size() * percent / 100;
        cacheSizeSet = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HWKC:  setMaxKeysOnCardPercent(int percent) returns int[" + maxKeysOnCard + "]");
        }
        return maxKeysOnCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void removeAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  removeAllEntries()");
        }
        if (HWKeyCache.cacheInitialized()) {
            byte[] byArray = lock;
            // MONITORENTER : lock
            HWKeyCache.reduceKeysOnCardPercent(0);
            // MONITOREXIT : byArray
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "HWKC:  removeAllEntries()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setCapacityReached() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HWKC:  setCapacityReached()");
        }
        if (HWKeyCache.cacheInitialized() && !cacheSizeSet) {
            byte[] byArray = lock;
            // MONITORENTER : lock
            HWKeyCache.setMaxKeysOnCardPercent(80);
            HWKeyCache.reduceKeysOnCardPercent(75);
            // MONITOREXIT : byArray
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "HWKC:  setCapacityReached()");
    }

    static {
        _provider = null;
        fKey2TKey = null;
        fTKey2TTime = null;
        fKey = null;
        fAlg2Factory = null;
        maxKeysOnCard = 0;
        entryRefresh = 0L;
        lock = new byte[0];
        cacheSizeSet = false;
        s_theInstance = new HWKeyCache();
    }
}

