/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public class XSLTTransformer
extends Transform {
    private static final boolean DEBUG = false;
    public static final String URI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    OMDocument styledoc = null;

    @Override
    public void setParameter(OMNode node) {
        if (node == null) {
            return;
        }
        OMContainer parent = node.getParent();
        if (parent != null && parent instanceof OMDocument) {
            this.styledoc = (OMDocument)parent;
            return;
        }
        if (node.getType() == 1) {
            OMElement elem = (OMElement)node;
            String uri = elem.getNamespace() == null ? null : elem.getNamespace().getName();
            String local = elem.getLocalName();
            if (uri != null && uri.equals("http://www.w3.org/2000/09/xmldsig#") && local != null && local.equals("XSLT")) {
                node = DOMUtil.getFirstChildElement(node);
            }
        }
        if (node == null) {
            return;
        }
        OMFactory factory = node.getOMFactory();
        OMDocument doc = factory.createOMDocument();
        OMElement newRoot = ((OMElement)node).cloneOMElement();
        Hashtable namespaces = XPathCanonicalizer.collectNamespaceNodesInAncestors(node, false);
        Enumeration en = namespaces.elements();
        while (en.hasMoreElements()) {
            OMNamespace ns = (OMNamespace)en.nextElement();
            if ("xml".equals(ns.getPrefix())) continue;
            newRoot.declareNamespace(ns);
        }
        doc.addChild(newRoot);
        this.styledoc = doc;
    }

    private static void print(OMNode node) {
    }

    public void setParameter(OMDocument doc) {
        this.styledoc = doc;
    }

    @Override
    public String getURI() {
        return URI;
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        if (this.styledoc == null) {
            throw new TransformException("No prameter element.");
        }
        try {
            OMElement node = context.getDocument().getOMDocumentElement();
            XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(node);
            XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(this.styledoc.getOMDocumentElement());
            XSLTTransformer.print(this.styledoc.getOMDocumentElement());
            TransformerFactory trf = TransformerFactory.newInstance();
            ByteArrayOutputStream styleOut = new ByteArrayOutputStream();
            this.styledoc.serialize(styleOut);
            ByteArrayInputStream styleIn = new ByteArrayInputStream(styleOut.toByteArray());
            ByteArrayOutputStream nodeOut = new ByteArrayOutputStream();
            node.serialize(nodeOut);
            ByteArrayInputStream nodeIn = new ByteArrayInputStream(nodeOut.toByteArray());
            Transformer tr = trf.newTransformer(new StreamSource(styleIn));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tr.transform(new StreamSource(nodeIn), new StreamResult(baos));
            context.setContent(baos.toByteArray(), null);
        }
        catch (TransformerException tre) {
            throw TransformException.create(tre);
        }
        catch (XMLStreamException tre) {
            throw TransformException.create(tre);
        }
    }

    @Override
    public OMElement createTransformElement(OMFactory factory, IndentConfig iconf) {
        OMElement trElement = super.createTransformElement(factory, iconf);
        DOMUtil.addIndent(trElement, iconf, 0);
        trElement.addChild(this.styledoc.getOMDocumentElement().cloneOMElement());
        DOMUtil.addIndent(trElement, iconf, 4);
        return trElement;
    }
}

