/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;

public class XPathTransformer
extends Transform
implements ErrorListener {
    private static final boolean DEBUG = false;
    private static final String clsName = XPathTransformer.class.getName();
    OMElement xpathExpression;

    @Override
    public void setParameter(OMNode node) {
        if (node.getType() != 1) {
            throw new IllegalArgumentException("The parameter must be ELEMENT_NODE.");
        }
        this.xpathExpression = (OMElement)node;
    }

    @Override
    public String getURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        try {
            ArrayList nodeset = context.getNodeset();
            OMNode here = this.xpathExpression.getFirstOMChild();
            if (here == null) {
                here = this.xpathExpression;
            }
            ArrayList resultNodeset = new ArrayList(nodeset.size());
            XPath xpath = XPathTransformer.createXPath(this.xpathExpression, context);
            for (int i = 0; i < nodeset.size(); ++i) {
                Object node = nodeset.get(i);
                Object xobj = null;
                if (node instanceof OMNode) {
                    xobj = xpath.evaluate(node);
                } else if (node instanceof OMNamespaceWithOwner) {
                    xobj = xpath.evaluate(((OMNamespaceWithOwner)node).getOwnerElement());
                } else if (node instanceof OMAttributeWithOwner) {
                    xobj = xpath.evaluate(((OMAttributeWithOwner)node).getOwnerElement());
                }
                if (xobj == null || !(xobj instanceof Boolean) || !Boolean.TRUE.equals(xobj)) continue;
                resultNodeset.add(node);
            }
            context.setContent(resultNodeset);
        }
        catch (JaxenException je) {
            if (context.isDebug()) {
                je.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + je.getMessage());
        }
        catch (TransformerException tre) {
            if (context.isDebug()) {
                tre.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + tre.getMessage());
        }
        catch (RuntimeException re) {
            if (context.isDebug()) {
                re.printStackTrace();
            }
            throw new TransformException("Error occured in an XPath transform: " + re.getMessage());
        }
    }

    private static void dumpNode(OMNode n) {
    }

    @Override
    public void error(TransformerException ex) {
        ex.printStackTrace();
    }

    @Override
    public void fatalError(TransformerException ex) {
        ex.printStackTrace();
    }

    @Override
    public void warning(TransformerException ex) {
        ex.printStackTrace();
    }

    public OMElement createTransformElement(OMDocument factory, IndentConfig iconf) {
        OMElement xpathElement = this.xpathExpression;
        OMElement trElement = super.createTransformElement(factory.getOMDocumentElement().getOMFactory(), iconf);
        DOMUtil.addIndent(trElement, iconf, 5);
        trElement.addChild(xpathElement);
        DOMUtil.addIndent(trElement, iconf, 4);
        return trElement;
    }

    static XPath createXPath(OMNode xpathExpression, TransformContext context) throws TransformerException {
        XPathUtil.AXIOMXPathWithIR xpath = null;
        try {
            XPathUtil.DocumentNavigatorWithIR navigator = new XPathUtil.DocumentNavigatorWithIR(context.getIDResolver());
            xpath = new XPathUtil.AXIOMXPathWithIR(DOMUtil.getStringValue(xpathExpression), navigator);
            SimpleNamespaceContext nsContext = new SimpleNamespaceContext();
            nsContext.addElementNamespaces(navigator, xpathExpression);
            xpath.setNamespaceContext(nsContext);
            XPathFunctionContext funcContext = new XPathFunctionContext(false);
            funcContext.registerFunction(null, "here", new FuncHere(xpathExpression));
            xpath.setFunctionContext(funcContext);
        }
        catch (UnsupportedAxisException ex) {
            throw new TransformerException(ex.getClass().getName() + ": " + ex.getMessage());
        }
        catch (JaxenException ex) {
            throw new TransformerException(ex.getClass().getName() + ": " + ex.getMessage());
        }
        return xpath;
    }

    public static class FuncHere
    implements Function {
        OMNode here;

        public FuncHere(OMNode here) {
            this.here = here;
        }

        @Override
        public Object call(Context xcontext, List args) throws FunctionCallException {
            try {
                return this.here;
            }
            catch (Exception ex) {
                throw new FunctionCallException("here(): " + ex.getMessage());
            }
        }
    }
}

