/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.axiom.om.OMNode;

public class W3CCanonicalizer2
extends Transform
implements Canonicalizer {
    @Override
    public String getURI() {
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        switch (context.getType()) {
            case 0: 
            case 1: {
                ByteArrayHolder result = XPathCanonicalizer.serializeAll(context.getDocument(), false);
                context.setContent(result, "UTF-8");
                break;
            }
            case 3: {
                ByteArrayHolder result = XPathCanonicalizer.serializeSubset(context.getNode(), false);
                context.setContent(result, "UTF-8");
                break;
            }
            case 2: {
                ByteArrayHolder result = XPathCanonicalizer.serializeSubset(context.getNodeset(), false);
                context.setContent(result, "UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + context.getType());
            }
        }
    }

    @Override
    public void canonicalize(OMNode node, OutputStream stream) throws IOException {
        WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
        wch.getProxyOutputStream().setOutputStream(stream);
        BufferedWriter wr = wch.getBufferedWriter();
        XPathCanonicalizer.serializeSubset(node, false, (Writer)wr);
        ((Writer)wr).flush();
        WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
    }
}

