/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.DecryptionTransformer;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class BinaryDecryptionTransformer
extends DecryptionTransformer {
    private static final boolean DEBUG = false;

    private void decryptBinary(SignatureContext scontext, ArrayList nodeSet, OutputStream out) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        int l = nodeSet.size();
        for (int i = 0; i < l; ++i) {
            Object n = nodeSet.get(i);
            if (!(n instanceof OMNode) || !this.isEncryptedData((OMNode)n)) continue;
            this.decryptEncryptedData(scontext, (OMElement)n, out);
        }
    }

    private void decryptEncryptedData(SignatureContext scontext, OMElement encData, OutputStream out) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        DecryptionContext dc = this.createDecryptionContext(scontext);
        dc.setEncryptedType(encData, null, null, null);
        dc.decrypt();
        Util.getBytes((InputStream)dc.getData(), out);
    }

    @Override
    public String getURI() {
        return "http://www.w3.org/2002/07/decrypt#Binary";
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        ArrayList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset(context.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        byte[] bb = null;
        if (nl != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.decryptBinary(context.getSignatureContext(), nl, os);
                os.close();
                bb = os.toByteArray();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exception e2;
                if (e instanceof XSignatureException && (e2 = ((XSignatureException)e).getException()) != null) {
                    e = e2;
                }
                throw new TransformException(e.getMessage());
            }
        }
        context.setContent(bb, null);
    }
}

