/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig.transform;

import com.ibm.ws.wssecurity.util.io.Base64Table;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import java.util.ArrayList;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class Base64Transformer
extends Transform {
    @Override
    public String getURI() {
        return "http://www.w3.org/2000/09/xmldsig#base64";
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getCharset() {
        return null;
    }

    @Override
    public void transform(TransformContext context) throws TransformException {
        switch (context.getType()) {
            case 0: 
            case 1: {
                ByteArrayHolder bah = context.getOctets();
                context.setContent(Base64Table.decode(bah.getValue(), bah.getOffset(), bah.getLength()), null);
                break;
            }
            case 3: {
                OMNode node = context.getNode();
                String encoded = "";
                switch (node.getType()) {
                    case 1: 
                    case 4: 
                    case 9: 
                    case 12: {
                        encoded = DOMUtil.getStringValue(node);
                    }
                }
                context.setContent(Base64Table.decode(encoded, 0, encoded.length()), null);
                break;
            }
            case 2: {
                ArrayList list = context.getNodeset();
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < list.size(); ++i) {
                    Object n = list.get(i);
                    if (!(n instanceof OMText)) continue;
                    buffer.append(((OMText)n).getText());
                }
                String str = new String(buffer);
                context.setContent(Base64Table.decode(str, 0, str.length()), null);
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + context.getType());
            }
        }
    }
}

