/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.core.SignatureEngine;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Reference;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Signature;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.SignatureMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.SignedInfo;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairStack;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectC14NWriter;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ValidityDOM;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.ExclusiveC11r;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class XSignature {
    private static final TraceComponent tc = Tr.register(XSignature.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XSignature.class.getName();
    static final boolean DEBUG = false;
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String TYPE_MANIFEST = "http://www.w3.org/2000/09/xmldsig#Manifest";
    public static final String TYPE_OBJECT = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final QName ALGO_Q = new QName("", "Algorithm");
    public static final QName ID_Q = new QName("", "Id");
    public static long signTime = 0L;
    public static long canonicalizeTime = 0L;

    private XSignature() {
    }

    static final OMElement getFirstChild(OMNode parent, String localPart) {
        return DOMUtil.getFirstChildElementNamed(parent, XMLDSIG_NAMESPACE, localPart);
    }

    static final boolean isDsigElement(OMElement element) {
        String ns;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns == null) {
            return false;
        }
        return ns.equals(XMLDSIG_NAMESPACE);
    }

    static final boolean isDsigElement(OMElement element, String localPart) {
        String ns;
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getName();
        if (ns == null) {
            return false;
        }
        return ns.equals(XMLDSIG_NAMESPACE) && element.getLocalName().equals(localPart);
    }

    static ByteArrayHolder getSignedInfoOctets(SignatureContext scontext, OMElement signedInfo) throws SignatureStructureException, NoSuchAlgorithmException, IOException {
        OMElement c14nMethod = XSignature.getFirstChild(signedInfo, "CanonicalizationMethod");
        if (c14nMethod == null) {
            throw new SignatureStructureException("No CanonicalizationMethod element.  This implementation always requires a CanonicalizationMethod.");
        }
        String c14nAlgorithm = c14nMethod.getAttributeValue(ALGO_Q);
        if (c14nAlgorithm == null || c14nAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the CanonicalizationMethod element.");
        }
        AlgorithmFactory afactory = scontext.getAlgorithmFactory();
        Canonicalizer c11r = afactory.getCanonicalizer(c14nAlgorithm);
        if (c11r == null) {
            throw new NoSuchAlgorithmException("No canonicalization algorithm: " + c14nAlgorithm);
        }
        c11r.setParameter(DOMUtil.getFirstChildElement(c14nMethod));
        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream(0);
        long startCanonicalize = System.currentTimeMillis();
        c11r.canonicalize(signedInfo, baos);
        canonicalizeTime += System.currentTimeMillis() - startCanonicalize;
        baos.close();
        ByteArrayHolder result = baos.getByteArrayHolder();
        if (scontext.getResourceShower() != null) {
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), -1, "_SignedInfo_", null, result.getValue(), result.getOffset(), result.getLength(), null);
        }
        return result;
    }

    static ByteArrayHolder getSignedInfoOctets(SignatureContext scontext, SignatureObject signatureObject) throws SignatureStructureException, NoSuchAlgorithmException, IOException {
        String c14nAlgorithm = signatureObject.getC14NMethod();
        OMElement c14nMethod = signatureObject.getC14NMethodElement();
        OMElement signedInfo = signatureObject.getSignedInfoElement();
        if (c14nAlgorithm == null || c14nAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the CanonicalizationMethod element.");
        }
        AlgorithmFactory afactory = scontext.getAlgorithmFactory();
        Canonicalizer c11r = afactory.getCanonicalizer(c14nAlgorithm);
        if (c11r == null) {
            throw new NoSuchAlgorithmException("No canonicalization algorithm: " + c14nAlgorithm);
        }
        c11r.setParameter(DOMUtil.getFirstChildElement(c14nMethod));
        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream(0);
        c11r.canonicalize(signedInfo, baos);
        baos.close();
        ByteArrayHolder result = baos.getByteArrayHolder();
        if (scontext.getResourceShower() != null) {
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), -1, "_SignedInfo_", null, result.getValue(), result.getOffset(), result.getLength(), null);
        }
        return result;
    }

    static ByteArrayHolder getSignedInfoOctets(SignatureContext scontext, SignedInfo signedInfo) throws SignatureStructureException, NoSuchAlgorithmException, IOException {
        WSSObjectElement c14nMethod = WSSObjectUtils.getChild(signedInfo, Utf8ByteConstantsQNames.DSIG.QN_CANONICALIZATION_METHOD);
        if (c14nMethod == null) {
            throw new SignatureStructureException("No CanonicalizationMethod element.  This implementation always requires a CanonicalizationMethod.");
        }
        WSSObjectElement inc = WSSObjectUtils.getChild(c14nMethod, Utf8ByteConstantsQNames.XC14N.QN_NCLUSIVE_NAMESPACES);
        String prefixList = null;
        if (inc != null) {
            prefixList = ExclusiveC11r.getPrefixList(inc);
        }
        HashSet<Object> inclusiveNSPrefixList = null;
        inclusiveNSPrefixList = prefixList == null || prefixList.isEmpty() ? new HashSet() : ExclusiveC11r.parsePrefixList(prefixList);
        BufferExportableByteArrayOutputStream baos = new BufferExportableByteArrayOutputStream(2048);
        WSSObjectC14NWriter wSSObjectC14NWriter = new WSSObjectC14NWriter(baos);
        signedInfo.canonicalize(wSSObjectC14NWriter, new NamespacePrefixPairStack(), inclusiveNSPrefixList, true);
        wSSObjectC14NWriter.flush();
        baos.flush();
        baos.close();
        ByteArrayHolder result = baos.getByteArrayHolder();
        if (scontext.getResourceShower() != null) {
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), -1, "_SignedInfo_", null, result.getValue(), result.getOffset(), result.getLength(), null);
        }
        return result;
    }

    static SignatureEngine getSignatureEngine(OMElement signedInfo, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        OMElement signatureMethodElement = XSignature.getFirstChild(signedInfo, "SignatureMethod");
        if (signatureMethodElement == null) {
            throw new SignatureStructureException("No SignatureMethod element.");
        }
        String signatureAlgorithm = signatureMethodElement.getAttributeValue(ALGO_Q);
        if (signatureAlgorithm == null || signatureAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the SignatureMethod element.");
        }
        AlgorithmParameterSpec spec = afactory.unmarshalParameter(signatureAlgorithm, signatureMethodElement);
        SignatureEngine engine2 = afactory.getSignatureEngine(signatureAlgorithm);
        engine2.setParameter(spec);
        return engine2;
    }

    static SignatureEngine getSignatureEngine(SignatureObject signatureObject, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        OMElement signatureMethodElement = signatureObject.getSignatureMethodElement();
        if (signatureMethodElement == null) {
            throw new SignatureStructureException("No SignatureMethod element.");
        }
        String signatureAlgorithm = signatureObject.getSignatureMethod();
        if (signatureAlgorithm == null || signatureAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the SignatureMethod element.");
        }
        AlgorithmParameterSpec spec = afactory.unmarshalParameter(signatureAlgorithm, signatureMethodElement);
        SignatureEngine engine2 = afactory.getSignatureEngine(signatureAlgorithm);
        engine2.setParameter(spec);
        return engine2;
    }

    static SignatureEngine getSignatureEngine(SignedInfo signedInfo, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        SignatureMethod signatureMethod = signedInfo.getSignatureMethod();
        if (signatureMethod == null) {
            throw new SignatureStructureException("No SignatureMethod element.");
        }
        VariablePartAttributeValue vPartAttr = signatureMethod.getAlgorithm();
        String signatureAlgorithm = null;
        if (vPartAttr != null) {
            signatureAlgorithm = vPartAttr.toString();
        }
        if (signatureAlgorithm == null || signatureAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the SignatureMethod element.");
        }
        AlgorithmParameterSpec spec = afactory.unmarshalParameter(signatureAlgorithm, signatureMethod);
        SignatureEngine engine2 = afactory.getSignatureEngine(signatureAlgorithm);
        engine2.setParameter(spec);
        return engine2;
    }

    public static void resetDigestTime() {
        ReferenceProcessor.digestTime = 0L;
    }

    public static long getDigestTime() {
        return ReferenceProcessor.digestTime;
    }

    static void calculateSignatureValue(OMElement signature, SignatureEngine engine2, Key pkey, ByteArrayHolder signedInfoOctets) throws SignatureStructureException, InvalidKeyException, SignatureException {
        long signStart = System.currentTimeMillis();
        engine2.initSign(pkey);
        engine2.update(signedInfoOctets.getValue(), signedInfoOctets.getOffset(), signedInfoOctets.getLength());
        byte[] value = engine2.sign();
        signTime += System.currentTimeMillis() - signStart;
        OMElement signatureValue = XSignature.getFirstChild(signature, "SignatureValue");
        if (signatureValue == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        DOMUtil.removeAllChildren(signatureValue);
        String strv = Base64.encode(value);
        OMNode prev = signatureValue.getPreviousOMSibling();
        if (prev != null && prev.getType() == 4) {
            StringBuffer buffer = new StringBuffer();
            int ind = (((OMText)prev).getText().length() - 1) * 2;
            buffer.append(Base64.format(strv, ind, "\n", ""));
            for (int i = 0; i < ind / 2; ++i) {
                buffer.append(" ");
            }
            strv = new String(buffer);
        }
        DOMUtil.appendText(signatureValue, strv);
    }

    static void calculateSignatureValue(Signature signature, SignatureEngine engine2, Key pkey, ByteArrayHolder signedInfoOctets) throws SignatureStructureException, InvalidKeyException, SignatureException {
        engine2.initSign(pkey);
        engine2.update(signedInfoOctets.getValue(), signedInfoOctets.getOffset(), signedInfoOctets.getLength());
        byte[] value = engine2.sign();
        byte[] encoded = Base64Table.encode(value, 0, value.length);
        signature.setSignatureValue(VariablePartFactory.getInstance().createTextValueWithAsciiByteWithoutCharRef(encoded));
    }

    static boolean verifySignatureValue(OMElement signature, SignatureEngine engine2, Key pkey, ByteArrayHolder signedInfoOctets) throws SignatureStructureException, InvalidKeyException, SignatureException {
        OMElement signatureValue = XSignature.getFirstChild(signature, "SignatureValue");
        if (signatureValue == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        byte[] valueInSignature = Base64.decode(DOMUtil.getStringValue(signatureValue));
        engine2.initVerify(pkey);
        engine2.update(signedInfoOctets.getValue(), signedInfoOctets.getOffset(), signedInfoOctets.getLength());
        boolean ret = engine2.verify(valueInSignature);
        return ret;
    }

    static boolean verifySignatureValue(String signatureValue, SignatureEngine engine2, Key pkey, ByteArrayHolder signedInfoOctets) throws SignatureStructureException, InvalidKeyException, SignatureException {
        if (signatureValue == null || signatureValue.isEmpty()) {
            throw new SignatureStructureException("No SignatureValue.");
        }
        byte[] valueInSignature = Base64.decode(signatureValue);
        engine2.initVerify(pkey);
        engine2.update(signedInfoOctets.getValue(), signedInfoOctets.getOffset(), signedInfoOctets.getLength());
        boolean ret = engine2.verify(valueInSignature);
        return ret;
    }

    static OMElement internalSign(SignatureContext scontext, Key pkey) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException, TransformException, IOException, SoapSecurityException {
        OMElement signedInfo;
        OMElement signature = scontext.getSignatureElement();
        IDResolverWrapper idr = null;
        if (scontext.getUseInternalIDResolver()) {
            idr = new IDResolverWrapper(DOMUtil.getOwnerDocument(signature), scontext.getIDResolver());
            OMNode ch = DOMUtil.getFirstChild2(signature);
            while (ch != null) {
                String id;
                OMElement el;
                if (ch.getType() == 1 && XSignature.isDsigElement(el = (OMElement)ch) && XSignature.isDsigElement(el, "Object") && (id = el.getAttributeValue(ID_Q)) != null && id.length() != 0) {
                    idr.registerID(id, el);
                }
                ch = DOMUtil.getNextSibling2(ch);
            }
            scontext.setWrappedIDResolver(idr);
        }
        if ((signedInfo = DOMUtil.getFirstChildElement(signature)) == null) {
            throw new SignatureStructureException("No SignedInfo element.");
        }
        int refno = 0;
        OMElement reference = XSignature.getFirstChild(signedInfo, "Reference");
        while (reference != null) {
            if (!XSignature.isDsigElement(reference, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + reference.getLocalName());
            }
            ReferenceProcessor.substDigest(scontext, reference, refno++);
            reference = DOMUtil.getNextElement(reference);
        }
        ByteArrayHolder signedInfoOctets = XSignature.getSignedInfoOctets(scontext, signedInfo);
        if (pkey != null) {
            AlgorithmFactory afactory = scontext.getAlgorithmFactory();
            SignatureEngine engine2 = XSignature.getSignatureEngine(signedInfo, afactory);
            try {
                XSignature.calculateSignatureValue(signature, engine2, pkey, signedInfoOctets);
            }
            catch (OutOfMemoryError e) {
                if (scontext.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    XSignature.calculateSignatureValue(signature, engine2, pkey, signedInfoOctets);
                }
                throw e;
            }
            afactory.releaseSignatureEngine(engine2);
        }
        return signature;
    }

    static Signature internalWSSObjectSign(SignatureContext scontext, Key pkey) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException, TransformException, IOException, SoapSecurityException {
        Signature signature = scontext.getSignatureWSSObject();
        SignedInfo signedInfo = signature.signedInfo;
        if (signedInfo == null) {
            throw new SignatureStructureException("No SignedInfo element.");
        }
        int refno = 0;
        ArrayList<WSSObject> children = signedInfo.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                WSSObject obj = children.get(i);
                if (!(obj instanceof Reference)) continue;
                Reference reference = (Reference)obj;
                ReferenceProcessor.substDigest(scontext, reference, refno++);
            }
        }
        ByteArrayHolder signedInfoOctets = XSignature.getSignedInfoOctets(scontext, signedInfo);
        if (pkey != null) {
            AlgorithmFactory afactory = scontext.getAlgorithmFactory();
            SignatureEngine engine2 = XSignature.getSignatureEngine(signedInfo, afactory);
            try {
                XSignature.calculateSignatureValue(signature, engine2, pkey, signedInfoOctets);
            }
            catch (OutOfMemoryError e) {
                if (scontext.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    XSignature.calculateSignatureValue(signature, engine2, pkey, signedInfoOctets);
                }
                throw e;
            }
            afactory.releaseSignatureEngine(engine2);
        }
        return signature;
    }

    static Validity internalVerify(SignatureContext scontext, Key pkey, SignatureObject signatureObject) {
        OMElement signature = scontext.getSignatureElement();
        IDResolverWrapper idr = null;
        if (scontext.getUseInternalIDResolver()) {
            idr = new IDResolverWrapper(DOMUtil.getOwnerDocument(signature), scontext.getIDResolver());
        }
        ValidityDOM domv = new ValidityDOM();
        try {
            HWKeyCache fHWKeyCache;
            PublicKey key;
            OMElement el = signatureObject.getKey();
            if (pkey == null && el != null) {
                pkey = ProcessKey.processKeyInfo(scontext, el);
            }
            if (pkey == null) {
                throw new SignatureStructureException("No KeyInfo element.");
            }
            if (scontext.isHWAccelerationProvider() && (key = (PublicKey)(fHWKeyCache = HWKeyCache.getInstance()).translate(pkey)) != null) {
                pkey = key;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key translated by HWCache");
                }
            }
            scontext.setWrappedIDResolver(idr);
            XSignature.verify2(scontext, domv, pkey, signatureObject);
        }
        catch (SignatureStructureException sse) {
            domv.setSignedInfoMessage(sse.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            domv.setSignedInfoMessage(nsae.getMessage());
        }
        catch (CertificateException ce) {
            domv.setSignedInfoMessage(ce.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            domv.setSignedInfoMessage(ikse.getMessage());
        }
        catch (IOException ioe) {
            domv.setSignedInfoMessage(ioe.getMessage());
        }
        catch (TransformException ioe) {
            domv.setSignedInfoMessage(ioe.getMessage());
        }
        catch (Exception e) {
            domv.setSignedInfoMessage(e.getMessage());
        }
        domv.setCoreValidity();
        return domv;
    }

    private static void verify2(SignatureContext scontext, Verifier verifier, Key pkey, SignatureObject signatureObject) {
        boolean valid = false;
        try {
            int refno = 0;
            for (ReferenceObject refObject = signatureObject.getReferenceObject(); refObject != null; refObject = refObject.next()) {
                ReferenceValidity rv = ReferenceProcessor.verify(scontext, refObject, refno++);
                verifier.addReferenceValidity(rv);
                refObject.clear();
            }
            AlgorithmFactory afactory = scontext.getAlgorithmFactory();
            ByteArrayHolder signedInfoOctets = XSignature.getSignedInfoOctets(scontext, signatureObject);
            SignatureEngine engine2 = XSignature.getSignatureEngine(signatureObject, afactory);
            try {
                valid = XSignature.verifySignatureValue(signatureObject.getSignatureValue(), engine2, pkey, signedInfoOctets);
            }
            catch (OutOfMemoryError e) {
                if (scontext.isHWAccelerationProvider()) {
                    HWKeyCache.setCapacityReached();
                    valid = XSignature.verifySignatureValue(signatureObject.getSignatureValue(), engine2, pkey, signedInfoOctets);
                }
                throw e;
            }
            afactory.releaseSignatureEngine(engine2);
            if (!valid) {
                verifier.setSignedInfoMessage("SignatureValue mismatched.");
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            verifier.setSignedInfoMessage(sw.toString());
        }
        verifier.setSignedInfoValidity(valid);
    }

    static class IDResolverWrapper
    implements IDResolver {
        IDResolver next;
        Hashtable hash;
        OMDocument doc;

        IDResolverWrapper(OMDocument doc, IDResolver idr) {
            this.doc = doc;
            this.next = idr;
            this.hash = null;
        }

        void registerID(String id, OMElement el) {
            if (this.hash == null) {
                this.hash = new Hashtable();
            }
            this.hash.put(id, el);
        }

        @Override
        public OMElement resolveID(OMDocument doc, String id) {
            OMElement ret = null;
            if (doc == this.doc && this.hash != null && (ret = (OMElement)this.hash.get(id)) != null) {
                return ret;
            }
            if (this.next == null) {
                return null;
            }
            return this.next.resolveID(doc, id);
        }
    }

    static interface Verifier {
        public void addReferenceValidity(ReferenceValidity var1);

        public void setSignedInfoMessage(String var1);

        public void setSignedInfoValidity(boolean var1);
    }
}

