/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.CanonicalizationMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Signature;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.SignatureMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.SignedInfo;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.WSSObjectReference;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class WSSObjectTemplateGenerator
implements IndentConfig {
    Vector objects;
    String defaultDigestAlgorithm;
    String c11r;
    String signatureMethod;
    AlgorithmParameterSpec signatureSpec;
    OMFactory factory;
    SignedInfo signedInfoElement;
    OMElement manifestElement;
    Signature signatureElement;
    WSSObjectDocumentImpl wssObjectDocument;
    String prefix = "ds";
    private static QName ID_Q = new QName("", "Id");
    boolean doIndent = false;
    int indentUnit = 2;

    public WSSObjectTemplateGenerator() {
    }

    public WSSObjectTemplateGenerator(OMFactory factory, String defaultDigestMethod, String c14nURI, String signatureMethod, WSSObjectDocumentImpl wssObjectDocument) {
        this();
        this.setDocument(factory);
        this.setDefaultDigestMethod(defaultDigestMethod);
        this.setCanonicalizer(c14nURI);
        this.setSignatureMethod(signatureMethod);
        this.setWSSObjectDocument(wssObjectDocument);
    }

    public void setDefaultDigestMethod(String algorithmURI) {
        this.defaultDigestAlgorithm = algorithmURI;
    }

    public WSSObjectReference createReference(String uri) {
        WSSObjectReference or = new WSSObjectReference(this, uri, null, this.wssObjectDocument);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public WSSObjectReference createReference(VariablePartAttributeValue uri) {
        WSSObjectReference or = new WSSObjectReference(this, uri, null, this.wssObjectDocument);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public WSSObjectReference createReference(WSSObjectElement objectElement) {
        String idname = null;
        if (idname == null || idname.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        WSSObjectReference or = new WSSObjectReference(this, "#" + idname, objectElement, this.wssObjectDocument);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public WSSObjectReference createReference(WSSObjectElement objectElement, String idname) {
        if (idname == null || idname.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        WSSObjectReference or = new WSSObjectReference(this, "#" + idname, objectElement, this.wssObjectDocument);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public OMElement wrapWithObject(OMNode resource, String idname) {
        OMElement object = this.createElementNS("Object", "dsig");
        WSSObjectTemplateGenerator.fixupNamespace(object);
        object.declareNamespace(resource.getOMFactory().createOMNamespace("", ""));
        object.addAttribute("Id", idname, null);
        object.addChild(resource);
        return object;
    }

    public void addReference(WSSObjectReference obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.addElement(obj);
    }

    public void removeAllReferences() {
        if (this.objects != null) {
            this.objects.removeAllElements();
        }
    }

    public void setCanonicalizer(String algorithmURI) {
        this.c11r = algorithmURI;
    }

    public void setSignatureMethod(String algorithmURI) {
        this.signatureMethod = algorithmURI;
    }

    public void setSignatureMethodParameter(AlgorithmParameterSpec spec) {
        this.signatureSpec = spec;
    }

    public void setDocument(OMFactory factory) {
        this.factory = factory;
    }

    public OMFactory getDocument() {
        return this.factory;
    }

    public void setWSSObjectDocument(WSSObjectDocumentImpl doc) {
        this.wssObjectDocument = doc;
    }

    public WSSObjectDocumentImpl getWSSObjectDocument() {
        return this.wssObjectDocument;
    }

    public void setPrefix(String pre) {
        this.prefix = pre;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setIndentation(boolean ind) {
        this.doIndent = ind;
    }

    @Override
    public boolean doIndentation() {
        return this.doIndent;
    }

    public void setUnit(int u) {
        this.indentUnit = u;
    }

    @Override
    public int getUnit() {
        return this.indentUnit;
    }

    public SignedInfo getSignedInfoElement() {
        try {
            return this.getSignedInfoElement(null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Internal Error: " + nsae.getMessage());
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("Internal Error: " + nspe.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException("Internal Error: " + iape.getMessage());
        }
    }

    public SignedInfo getSignedInfoElement(AlgorithmFactory afactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signedInfoElement != null) {
            return this.signedInfoElement;
        }
        this.signatureElement = new Signature(this.wssObjectDocument);
        this.signedInfoElement = new SignedInfo(this.wssObjectDocument);
        this.signatureElement.setSignedInfo(this.signedInfoElement);
        SignedInfo signedInfo = this.signedInfoElement;
        if (this.c11r == null) {
            throw new RuntimeException("You must specify a CanonicalizationMethod in this implementation.");
        }
        CanonicalizationMethod c14nMethod = new CanonicalizationMethod(this.wssObjectDocument);
        signedInfo.setCanonicalizationMethod(c14nMethod);
        c14nMethod.setAlgorithm(Utf8ByteConstantsVariableParts.VPA_C14N_EXCLUSIVE);
        if (this.signatureMethod == null) {
            throw new RuntimeException("You must specify a SignatureMethod.");
        }
        SignatureMethod sigMethod = new SignatureMethod(this.wssObjectDocument);
        signedInfo.setSignatureMethod(sigMethod);
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(this.signatureMethod)) {
            sigMethod.setAlgorithm(Utf8ByteConstantsVariableParts.VPA_HMAC);
        } else if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(this.signatureMethod)) {
            sigMethod.setAlgorithm(Utf8ByteConstantsVariableParts.VPA_RSA);
        } else {
            sigMethod.setAlgorithm(VariablePartFactory.getInstance().createAttrValueWithString(this.signatureMethod));
        }
        if (afactory != null && this.signatureSpec != null) {
            afactory.marshalParameter(this.signatureMethod, this.signatureSpec, sigMethod);
        }
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            WSSObjectReference ref = (WSSObjectReference)this.objects.elementAt(i);
            com.ibm.ws.wssecurity.wssobject.impl.dsig.Reference refElement = ref.getReferenceElement(this);
            signedInfo.addChild(refElement);
        }
        return signedInfo;
    }

    public OMElement getManifestElement() {
        if (this.manifestElement != null) {
            return this.manifestElement;
        }
        this.manifestElement = this.createElementNS("Manifest");
        WSSObjectTemplateGenerator.fixupNamespace(this.manifestElement);
        DOMUtil.addIndent(this.manifestElement, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference ref = (Reference)this.objects.elementAt(i);
            OMElement refElement = ref.getReferenceElement(this);
            this.manifestElement.addChild(refElement);
            DOMUtil.addIndent(this.manifestElement, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return this.manifestElement;
    }

    public Signature getSignatureElement() {
        try {
            return this.getSignatureElement(null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Internal Error: " + nsae.getMessage());
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("Internal Error: " + nspe.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException("Internal Error: " + iape.getMessage());
        }
    }

    public Signature getSignatureElement(AlgorithmFactory afactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signatureElement != null) {
            return this.signatureElement;
        }
        this.getSignedInfoElement(afactory);
        Signature el = this.signatureElement;
        el.setSignatureValue(Utf8ByteConstantsVariableParts.VPT_DUMMY);
        Vector<WSSObjectElement> v = new Vector<WSSObjectElement>(this.objects.size());
        for (int i = 0; i < this.objects.size(); ++i) {
            WSSObjectElement objectElement;
            WSSObjectReference ref = (WSSObjectReference)this.objects.elementAt(i);
            if (!ref.isEnvelopedObject() || WSSObjectTemplateGenerator.contains(v, objectElement = ref.getObjectElement())) continue;
            v.addElement(objectElement);
            el.addChild(objectElement);
        }
        return el;
    }

    private static boolean contains(Vector v, Object obj) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.elementAt(i) != obj) continue;
            return true;
        }
        return false;
    }

    final OMElement createElementNS(String local) {
        return this.factory.createOMElement(local, "http://www.w3.org/2000/09/xmldsig#", this.prefix);
    }

    final OMElement createElementNS(String local, String pre) {
        return this.factory.createOMElement(local, "http://www.w3.org/2000/09/xmldsig#", pre);
    }

    private static void fixupNamespace(OMElement el) {
        el.declareNamespace(el.getNamespace());
    }
}

