/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.DigestMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Reference;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Transform;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Transforms;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.WSSObjectTemplateGenerator;
import java.util.Vector;

public class WSSObjectReference {
    String uri;
    VariablePartAttributeValue variablePartUri;
    String id;
    String type;
    WSSObjectTemplateGenerator gen;
    WSSObjectElement objectElement;
    WSSObjectDocumentImpl wssObjectDocument;
    Vector transforms;
    String digester;

    protected WSSObjectReference(WSSObjectTemplateGenerator tg, String uri, WSSObjectElement objectElement, WSSObjectDocumentImpl doc) {
        this.gen = tg;
        this.uri = uri;
        this.objectElement = objectElement;
        this.wssObjectDocument = doc;
    }

    protected WSSObjectReference(WSSObjectTemplateGenerator tg, VariablePartAttributeValue uri, WSSObjectElement objectElement, WSSObjectDocumentImpl doc) {
        this.gen = tg;
        this.variablePartUri = uri;
        this.objectElement = objectElement;
        this.wssObjectDocument = doc;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addTransform(Transform transform) {
        if (this.transforms == null) {
            this.transforms = new Vector();
        }
        this.transforms.addElement(transform);
    }

    public void addTransform(String algorithm) {
        Transform transform = new Transform(this.wssObjectDocument);
        transform.setAlgorithm(VariablePartFactory.getInstance().createAttrValueWithString(algorithm));
        this.addTransform(transform);
    }

    public void setDigestMethod(String digester) {
        this.digester = digester;
    }

    protected String getDigestMethod() {
        return this.digester;
    }

    public Reference getReferenceElement() {
        return this.getReferenceElement(null);
    }

    public Reference getReferenceElement(IndentConfig iconf) {
        Reference reference = new Reference(this.wssObjectDocument);
        if (this.variablePartUri != null) {
            reference.setUri(this.variablePartUri);
        } else {
            reference.setUri(VariablePartFactory.getInstance().createAttrValueWithString(this.uri));
        }
        if (this.id != null) {
            reference.setWsuId(VariablePartFactory.getInstance().createAttrValueWithString(this.id));
        }
        if (this.type != null) {
            reference.setType(VariablePartFactory.getInstance().createAttrValueWithString(this.type));
        }
        if (this.transforms != null) {
            Transforms transforms = new Transforms(this.wssObjectDocument);
            for (int i = 0; i < this.transforms.size(); ++i) {
                Transform transform = (Transform)this.transforms.elementAt(i);
                transforms.addChild(transform);
            }
            reference.setTransforms(transforms);
        }
        DigestMethod digestMethod = new DigestMethod(this.wssObjectDocument);
        reference.setDigestMethod(digestMethod);
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(this.digester)) {
            digestMethod.setAlgorithm(Utf8ByteConstantsVariableParts.VPA_SHA1);
        } else {
            digestMethod.setAlgorithm(VariablePartFactory.getInstance().createAttrValueWithString(this.digester));
        }
        return reference;
    }

    protected WSSObjectElement getObjectElement() {
        return this.objectElement;
    }

    protected boolean isEnvelopedObject() {
        return this.objectElement != null;
    }
}

