/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class URITransportSetter {
    private static final int NON_XML_READ_BUFFER = 4096;

    URITransportSetter() {
    }

    public static byte[] getContent(String uri, EntityResolver eresolver, Receiver recv) throws IOException {
        int readLength;
        InputStream is;
        String encoding = null;
        if (eresolver != null) {
            InputSource source = null;
            try {
                source = eresolver.resolveEntity(null, uri);
            }
            catch (SAXException saxe) {
                // empty catch block
            }
            if (source == null) {
                URLConnection conn = new URL(uri).openConnection();
                is = conn.getInputStream();
                encoding = URITransportSetter.getCharset(conn);
            } else {
                is = source.getByteStream();
                encoding = source.getEncoding();
                if (is == null) {
                    throw new RuntimeException("An EntityResolver have to return an InputStream for " + uri);
                }
            }
        } else {
            URLConnection conn = new URL(uri).openConnection();
            is = conn.getInputStream();
            encoding = URITransportSetter.getCharset(conn);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] readBuffer = new byte[4096];
        while ((readLength = is.read(readBuffer)) >= 0) {
            baos.write(readBuffer, 0, readLength);
        }
        is.close();
        baos.close();
        byte[] result = baos.toByteArray();
        if (recv != null) {
            recv.setContent(result, encoding);
        }
        return result;
    }

    public static String getCharset(URLConnection conn) {
        String type = conn.getContentType().trim().toUpperCase();
        int len = type.length();
        String encoding = null;
        if (!type.startsWith("TEXT/")) {
            return null;
        }
        int index = "TEXT/".length();
        while ((index = type.indexOf(59, index)) >= 0) {
            char ch;
            while (++index < len && type.charAt(index) == ' ') {
            }
            if (index >= len) break;
            if (!type.regionMatches(index, "CHARSET=", 0, "CHARSET=".length())) continue;
            if ((index += "CHARSET=".length()) >= len || ((ch = type.charAt(index)) == '\"' || ch == '\'') && ++index >= len) break;
            int namestart = index;
            while (index < len && "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789._-".indexOf(type.charAt(index)) >= 0) {
                ++index;
            }
            if (namestart == index) break;
            encoding = type.substring(namestart, index);
            break;
        }
        return encoding;
    }

    static interface Receiver {
        public void setContent(byte[] var1, String var2);
    }
}

