/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.URITransportSetter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TransformContext
implements URITransportSetter.Receiver {
    private SignatureContext scontext;
    private byte[] content;
    private String encoding;
    private OMNode node;
    private ArrayList nodeset;
    private String uri;
    private WSSObjectElement wssObject;
    private ByteArrayHolder bahContent;
    private int type;
    public static final int TYPE_BINARY = 0;
    public static final int TYPE_URI = 1;
    public static final int TYPE_NODESET = 2;
    public static final int TYPE_NODE = 3;
    public static final int TYPE_WSSOBJECT = 4;

    private TransformContext(SignatureContext scontext) {
        this.scontext = scontext;
        this.clearData();
    }

    private void clearData() {
        this.content = null;
        this.encoding = null;
        this.node = null;
        this.nodeset = null;
        this.uri = null;
        this.wssObject = null;
        this.bahContent = null;
    }

    TransformContext(SignatureContext scontext, byte[] cont, String enc) {
        this(scontext);
        this.content = cont;
        this.encoding = enc;
        this.type = 0;
    }

    public TransformContext(SignatureContext scontext, OMNode node) {
        this(scontext);
        this.node = node;
        this.type = 3;
    }

    TransformContext(SignatureContext scontext, String uri) {
        this(scontext);
        this.uri = uri;
        this.type = 1;
    }

    TransformContext(SignatureContext scontext, ArrayList nodeset) {
        this(scontext);
        this.nodeset = nodeset;
        this.type = 2;
    }

    TransformContext(SignatureContext scontext, XMLElement element) {
        this(scontext);
        if (element != null) {
            if (element.getType() == 1) {
                this.node = element.getOMNode();
                this.type = 3;
            } else if (element.getType() == 2) {
                this.wssObject = element.getWSSObject();
                this.type = 4;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isOctetsOrURI() {
        return this.type == 0 || this.type == 1;
    }

    @Override
    public void setContent(byte[] cont, String enc) {
        this.clearData();
        this.content = cont;
        this.encoding = enc;
        this.type = 0;
    }

    public void setContent(ByteArrayHolder bah, String enc) {
        this.clearData();
        this.bahContent = bah;
        this.encoding = enc;
        this.type = 0;
    }

    public void setContent(ArrayList nodeset) {
        this.clearData();
        this.nodeset = nodeset;
        this.type = 2;
    }

    public ByteArrayHolder getOctets() throws TransformException {
        switch (this.type) {
            case 4: {
                throw new RuntimeException("TransformContext.getOctets() not expected to be called with type = TYPE_WSSOBJECT");
            }
            case 3: {
                this.bahContent = XPathCanonicalizer.serializeSubset(this.node, false);
                this.encoding = "UTF-8";
                this.node = null;
                this.type = 0;
                break;
            }
            case 2: {
                this.bahContent = XPathCanonicalizer.serializeSubset(this.nodeset, false);
                this.encoding = "UTF-8";
                this.nodeset = null;
                this.type = 0;
                break;
            }
            case 1: {
                try {
                    URITransportSetter.getContent(this.uri, this.getEntityResolver(), this);
                    break;
                }
                catch (IOException ioe) {
                    throw TransformException.create(ioe);
                }
            }
        }
        if (this.bahContent == null && this.content != null) {
            this.bahContent = new ByteArrayHolder(this.content, 0, this.content.length);
        }
        return this.bahContent;
    }

    public ByteArrayHolder getByteArrayHolder() throws TransformException {
        if (this.type != 0) {
            throw new RuntimeException("Internal Error: Type must be TYPE_BINARY: type = " + this.type);
        }
        if (this.bahContent == null && this.content != null) {
            this.bahContent = new ByteArrayHolder(this.content, 0, this.content.length);
        }
        return this.bahContent;
    }

    public String getEncoding() throws TransformException {
        this.getOctets();
        return this.encoding;
    }

    public OMNode getNode() throws TransformException {
        if (this.type != 3) {
            throw new RuntimeException("Internal Error: Type mismatch: requested=TYPE_NODE, type=" + this.type);
        }
        return this.node;
    }

    public WSSObjectElement getWSSObject() throws TransformException {
        if (this.type != 4) {
            throw new RuntimeException("Internal Error: Type mismatch: requested=TYPE_WSSOBJECT, type=" + this.type);
        }
        return this.wssObject;
    }

    public ArrayList getNodeset() throws TransformException {
        switch (this.type) {
            case 0: 
            case 1: {
                return XPathCanonicalizer.toNodeset(this.getDocument().getOMDocumentElement(), null, true);
            }
            case 3: {
                OMNode node = this.getNode();
                return XPathCanonicalizer.toNodeset(node, null, false);
            }
            case 2: {
                return this.nodeset;
            }
        }
        throw new RuntimeException("Internal Error: Unknown type: type=" + this.type);
    }

    public OMDocument getDocument() throws TransformException {
        OMDocument doc;
        try {
            InputSource src = null;
            if (this.type == 1) {
                if (this.getEntityResolver() != null) {
                    try {
                        src = this.getEntityResolver().resolveEntity(null, this.uri);
                    }
                    catch (SAXException saxe) {
                        // empty catch block
                    }
                }
                if (src == null) {
                    src = new InputSource(this.uri);
                }
            } else {
                ByteArrayHolder bah = this.getOctets();
                src = new InputSource(new ByteArrayInputStream(bah.getValue(), bah.getOffset(), bah.getLength()));
                if (this.getEncoding() != null) {
                    src.setEncoding(this.getEncoding());
                }
            }
            doc = this.scontext.parse(src);
        }
        catch (IOException ioe) {
            throw TransformException.create(ioe);
        }
        catch (SAXException saxe) {
            throw TransformException.create(saxe);
        }
        catch (XMLStreamException xse) {
            throw TransformException.create(xse);
        }
        return doc;
    }

    public SignatureContext getSignatureContext() {
        return this.scontext;
    }

    public EntityResolver getEntityResolver() {
        return this.scontext.getEntityResolver();
    }

    public IDResolver getIDResolver() {
        return this.scontext.getIDResolver();
    }

    public OMElement getSignatureElement() {
        return this.scontext.getSignatureElement();
    }

    public boolean isDebug() {
        return this.scontext.isDebug();
    }
}

