/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Reference;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class TemplateGenerator
implements IndentConfig {
    Vector objects;
    String defaultDigestAlgorithm;
    String c11r;
    String signatureMethod;
    AlgorithmParameterSpec signatureSpec;
    KeyInfoGenerator keyGen;
    OMFactory factory;
    OMElement signedInfoElement;
    OMElement manifestElement;
    OMElement signatureElement;
    String prefix = "ds";
    private static QName ID_Q = new QName("", "Id");
    boolean doIndent = false;
    int indentUnit = 2;

    public TemplateGenerator() {
    }

    public TemplateGenerator(OMFactory factory, String defaultDigestMethod, String c14nURI, String signatureMethod) {
        this();
        this.setDocument(factory);
        this.setDefaultDigestMethod(defaultDigestMethod);
        this.setCanonicalizer(c14nURI);
        this.setSignatureMethod(signatureMethod);
    }

    public TemplateGenerator(OMFactory factory, String defaultDigestMethod, String c14nURI, String signatureMethod, KeyInfoGenerator keyGen) {
        this();
        this.setDocument(factory);
        this.setDefaultDigestMethod(defaultDigestMethod);
        this.setCanonicalizer(c14nURI);
        this.setSignatureMethod(signatureMethod);
        this.setKeyInfoGenerator(keyGen);
    }

    public void setDefaultDigestMethod(String algorithmURI) {
        this.defaultDigestAlgorithm = algorithmURI;
    }

    public Reference createReference(String uri) {
        Reference or = new Reference(this, uri, null);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public Reference createReference(OMElement objectElement) {
        String idname = objectElement.getAttributeValue(ID_Q);
        if (idname == null || idname.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference or = new Reference(this, "#" + idname, objectElement);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public Reference createReference(OMElement objectElement, String idname) {
        if (idname == null || idname.length() == 0) {
            throw new IllegalArgumentException("This Object element has no Id attribute.");
        }
        Reference or = new Reference(this, "#" + idname, objectElement);
        or.setDigestMethod(this.defaultDigestAlgorithm);
        return or;
    }

    public OMElement wrapWithObject(OMNode resource, String idname) {
        OMElement object = this.createElementNS("Object", "dsig");
        TemplateGenerator.fixupNamespace(object);
        object.declareNamespace(resource.getOMFactory().createOMNamespace("", ""));
        object.addAttribute("Id", idname, null);
        object.addChild(resource);
        return object;
    }

    public void addReference(Reference obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (this.objects == null) {
            this.objects = new Vector();
        }
        this.objects.addElement(obj);
    }

    public void removeAllReferences() {
        if (this.objects != null) {
            this.objects.removeAllElements();
        }
    }

    public void setCanonicalizer(String algorithmURI) {
        this.c11r = algorithmURI;
    }

    public void setSignatureMethod(String algorithmURI) {
        this.signatureMethod = algorithmURI;
    }

    public void setSignatureMethodParameter(AlgorithmParameterSpec spec) {
        this.signatureSpec = spec;
    }

    public void setKeyInfoGenerator(KeyInfoGenerator keyGen) {
        this.keyGen = keyGen;
    }

    public void setDocument(OMFactory factory) {
        this.factory = factory;
    }

    public OMFactory getDocument() {
        return this.factory;
    }

    public void setPrefix(String pre) {
        this.prefix = pre;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setIndentation(boolean ind) {
        this.doIndent = ind;
    }

    @Override
    public boolean doIndentation() {
        return this.doIndent;
    }

    public void setUnit(int u) {
        this.indentUnit = u;
    }

    @Override
    public int getUnit() {
        return this.indentUnit;
    }

    public synchronized OMElement getSignedInfoElement() {
        try {
            return this.getSignedInfoElement(null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Internal Error: " + nsae.getMessage());
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("Internal Error: " + nspe.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException("Internal Error: " + iape.getMessage());
        }
    }

    public synchronized OMElement getSignedInfoElement(AlgorithmFactory afactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signedInfoElement != null) {
            return this.signedInfoElement;
        }
        this.signatureElement = this.createElementNS("Signature");
        TemplateGenerator.fixupNamespace(this.signatureElement);
        DOMUtil.addIndent(this.signatureElement, this, 1);
        this.signedInfoElement = this.createElementNS("SignedInfo");
        this.signatureElement.addChild(this.signedInfoElement);
        OMElement signedInfo = this.signedInfoElement;
        DOMUtil.addIndent(signedInfo, this, 2);
        if (this.c11r == null) {
            throw new RuntimeException("You must specify a CanonicalizationMethod in this implementation.");
        }
        OMElement c14nMethod = this.createElementNS("CanonicalizationMethod");
        c14nMethod.addAttribute("Algorithm", this.c11r, null);
        signedInfo.addChild(c14nMethod);
        DOMUtil.addIndent(signedInfo, this, 2);
        if (this.signatureMethod == null) {
            throw new RuntimeException("You must specify a SignatureMethod.");
        }
        OMElement sigMethod = this.createElementNS("SignatureMethod");
        sigMethod.addAttribute("Algorithm", this.signatureMethod, null);
        signedInfo.addChild(sigMethod);
        if (afactory != null && this.signatureSpec != null) {
            afactory.marshalParameter(this.signatureMethod, this.signatureSpec, sigMethod);
        }
        DOMUtil.addIndent(signedInfo, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference ref = (Reference)this.objects.elementAt(i);
            OMElement refElement = ref.getReferenceElement(this);
            signedInfo.addChild(refElement);
            DOMUtil.addIndent(signedInfo, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return signedInfo;
    }

    public synchronized OMElement getManifestElement() {
        if (this.manifestElement != null) {
            return this.manifestElement;
        }
        this.manifestElement = this.createElementNS("Manifest");
        TemplateGenerator.fixupNamespace(this.manifestElement);
        DOMUtil.addIndent(this.manifestElement, this, 2);
        if (this.objects == null || this.objects.size() == 0) {
            throw new RuntimeException("No resources are registered.");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            Reference ref = (Reference)this.objects.elementAt(i);
            OMElement refElement = ref.getReferenceElement(this);
            this.manifestElement.addChild(refElement);
            DOMUtil.addIndent(this.manifestElement, this, i == this.objects.size() - 1 ? 1 : 2);
        }
        return this.manifestElement;
    }

    public synchronized OMElement getSignatureElement() {
        try {
            return this.getSignatureElement(null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Internal Error: " + nsae.getMessage());
        }
        catch (NoSuchProviderException nspe) {
            throw new RuntimeException("Internal Error: " + nspe.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new RuntimeException("Internal Error: " + iape.getMessage());
        }
    }

    public synchronized OMElement getSignatureElement(AlgorithmFactory afactory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (this.signatureElement != null) {
            return this.signatureElement;
        }
        this.getSignedInfoElement(afactory);
        OMElement el = this.signatureElement;
        DOMUtil.addIndent(el, this, 1);
        el.addChild(this.createElementNS("SignatureValue"));
        if (this.keyGen != null) {
            DOMUtil.addIndent(el, this, 1);
            el.addChild(this.keyGen.getKeyInfoElement(this.factory));
        }
        Vector<OMElement> v = new Vector<OMElement>(this.objects.size());
        for (int i = 0; i < this.objects.size(); ++i) {
            OMElement objectElement;
            Reference ref = (Reference)this.objects.elementAt(i);
            if (!ref.isEnvelopedObject() || TemplateGenerator.contains(v, objectElement = ref.getObjectElement())) continue;
            v.addElement(objectElement);
            DOMUtil.addIndent(el, this, 1);
            el.addChild(objectElement);
        }
        DOMUtil.addIndent(el, this, 0);
        return el;
    }

    private static boolean contains(Vector v, Object obj) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.elementAt(i) != obj) continue;
            return true;
        }
        return false;
    }

    final OMElement createElementNS(String local) {
        return this.factory.createOMElement(local, "http://www.w3.org/2000/09/xmldsig#", this.prefix);
    }

    final OMElement createElementNS(String local, String pre) {
        return this.factory.createOMElement(local, "http://www.w3.org/2000/09/xmldsig#", pre);
    }

    private static void fixupNamespace(OMElement el) {
        el.declareNamespace(el.getNamespace());
    }
}

