/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.core.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineHMAC
implements SignatureEngine {
    private MessageDigest digest;
    private int outputLength;
    private String uri;
    private byte[] key_opad;
    private static final int B = 64;
    static final byte[] MASK_BITS = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128};

    public SignatureEngineHMAC(String u, Provider provider) throws NoSuchAlgorithmException {
        this.digest = provider == null ? MessageDigest.getInstance("SHA") : MessageDigest.getInstance("SHA", provider);
        this.outputLength = -1;
        this.uri = u;
    }

    @Override
    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec == null) {
            this.outputLength = -1;
            return;
        }
        if (!(spec instanceof HMACParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid paremeter class: " + spec.getClass().getName());
        }
        HMACParameterSpec hspec = (HMACParameterSpec)spec;
        if (hspec.getOutputLength() <= 0) {
            throw new InvalidAlgorithmParameterException("Output length is less than 1: " + hspec.getOutputLength());
        }
        this.outputLength = hspec.getOutputLength();
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void initSign(Key key) throws InvalidKeyException {
        this.init(key);
    }

    @Override
    public void initVerify(Key key) throws InvalidKeyException {
        this.init(key);
    }

    @Override
    public void update(byte[] data) throws SignatureException {
        this.digest.update(data);
    }

    @Override
    public void update(byte[] data, int off, int len) throws SignatureException {
        this.digest.update(data, off, len);
    }

    @Override
    public byte[] sign() throws SignatureException {
        byte[] value1 = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.key_opad);
        this.digest.update(value1);
        return this.mask(this.digest.digest());
    }

    @Override
    public boolean verify(byte[] signature) throws SignatureException {
        return MessageDigest.isEqual(this.mask(signature), this.sign());
    }

    private void init(Key key) {
        byte[] rawKey = key.getEncoded();
        byte[] normalizedKey = new byte[64];
        if (rawKey.length > 64) {
            this.digest.reset();
            rawKey = this.digest.digest(rawKey);
        }
        System.arraycopy(rawKey, 0, normalizedKey, 0, rawKey.length);
        for (int i = rawKey.length; i < 64; ++i) {
            normalizedKey[i] = 0;
        }
        byte[] key_ipad = new byte[64];
        this.key_opad = new byte[64];
        for (int i = 0; i < 64; ++i) {
            key_ipad[i] = (byte)(normalizedKey[i] ^ 0x36);
            this.key_opad[i] = (byte)(normalizedKey[i] ^ 0x5C);
        }
        this.digest.reset();
        this.digest.update(key_ipad);
    }

    private byte[] mask(byte[] in) {
        if (this.outputLength < 0) {
            return in;
        }
        int byteLen = (this.outputLength + 7) / 8;
        int extraBits = byteLen * 8 - this.outputLength;
        if (byteLen > in.length) {
            return in;
        }
        if (byteLen == in.length && extraBits == 0) {
            return in;
        }
        byte[] ret = new byte[byteLen];
        System.arraycopy(in, 0, ret, 0, byteLen);
        if (extraBits == 0) {
            return ret;
        }
        int n = byteLen - 1;
        ret[n] = (byte)(ret[n] & MASK_BITS[extraBits]);
        return ret;
    }

    public static class HMACParameterSpec
    implements AlgorithmParameterSpec {
        private int outputLength;

        public HMACParameterSpec(int len) {
            this.outputLength = len;
        }

        public HMACParameterSpec(int len, boolean checkHMACoutputLength) throws InvalidAlgorithmParameterException {
            if (checkHMACoutputLength && len < 80) {
                throw new InvalidAlgorithmParameterException("Invalid HMACOutputLength value");
            }
            this.outputLength = len;
        }

        public int getOutputLength() {
            return this.outputLength;
        }
    }
}

