/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.util.XMLIdResolver;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.Signature;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ManifestProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.NullURIHandler;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureObject;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Key;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SignatureContext {
    private EncryptedKeyRetriever encryptedKeyRetriever = null;
    private KeyInfoResolver keyInfoResolver = null;
    EntityResolver entityResolver = null;
    IDResolver idResolver = null;
    AlgorithmFactory aFactory = null;
    ResourceShower shower = null;
    NullURIHandler nullHandler = null;
    boolean useInternalIDResolver = true;
    IDResolver wrappedIDResolver = null;
    boolean verifyManifest = false;
    OMElement signature;
    OMElement owner;
    Map _context = null;
    private Signature signatureWSSObject = null;
    private WSSObjectElement ownerWSSObject = null;
    private OMDocument _document = null;
    private XMLIdResolver xmlIdResolver = null;
    protected boolean lastIsDigestValue = false;
    private boolean isForSigning = false;
    private String _hwKeyStoreName;
    private String _hwConfigName;
    private String sigAlgorithm = null;
    private Boolean _offload = Boolean.TRUE;
    private Provider hwAccelerationProvider = null;
    private Provider hwKeyStoreProvider = null;
    private boolean _onlySignEntireHeadersAndBody = false;
    private Boolean _incNSForSTRDT = null;
    private static QName TYPE_Q = new QName("", "Type");

    public SignatureContext() {
        this.aFactory = AlgorithmFactory.getInstance();
    }

    public Provider getHWAccelerationProvider() {
        return this.hwAccelerationProvider;
    }

    public Provider getHWKeyStoreProvider() {
        return this.hwKeyStoreProvider;
    }

    public void setHWAccelerationProvider(Provider p) {
        if (this.shouldChangeProvider()) {
            this.hwAccelerationProvider = p;
        }
    }

    public void setHWKeyStoreProvider(Provider p) {
        this.hwKeyStoreProvider = p;
    }

    public boolean isHWAccelerationProvider() {
        return this.hwAccelerationProvider != null;
    }

    public boolean isHWKeyStoreProvider() {
        return this.hwKeyStoreProvider != null;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver2) {
        this.entityResolver = resolver2;
    }

    public void setSigAlgorithm(String sa) {
        this.sigAlgorithm = sa;
    }

    public String getSigAlgorithm() {
        return this.sigAlgorithm;
    }

    public void setHWKeyStoreName(String keyStoreName) {
        this._hwKeyStoreName = keyStoreName;
    }

    public String getHWKeyStoreName() {
        return this._hwKeyStoreName;
    }

    public void setHWConfigName(String hwConfigName) {
        this._hwConfigName = hwConfigName;
    }

    public void setOffload(Boolean offload) {
        this._offload = offload;
    }

    public String getHWConfigName() {
        return this._hwConfigName;
    }

    public boolean shouldChangeProvider() {
        return this._hwConfigName != null && this._hwConfigName.length() > 0 && HWKeyCache.isHWSigAlgorithm(this.sigAlgorithm) && this._offload != false;
    }

    public boolean useHWKeyStore() {
        return this._hwKeyStoreName != null && this._hwKeyStoreName.length() > 0;
    }

    public IDResolver getIDResolver() {
        return this.idResolver;
    }

    public void setIDResolver(IDResolver resolver2) {
        this.idResolver = resolver2;
    }

    void setWrappedIDResolver(IDResolver resolver2) {
        this.wrappedIDResolver = resolver2;
    }

    IDResolver getIDResolver0() {
        return this.wrappedIDResolver != null ? this.wrappedIDResolver : this.idResolver;
    }

    public void setXMLIdResolver(XMLIdResolver resolver2) {
        this.xmlIdResolver = resolver2;
    }

    public XMLIdResolver getXMLIdResolver() {
        return this.xmlIdResolver;
    }

    public EncryptedKeyRetriever getEncryptedKeyRetriever() {
        return this.encryptedKeyRetriever;
    }

    public void setEncryptedKeyRetriever(EncryptedKeyRetriever kr) {
        this.encryptedKeyRetriever = kr;
    }

    public KeyInfoResolver getKeyInfoResolver() {
        return this.keyInfoResolver;
    }

    public void setKeyInfoResolver(KeyInfoResolver kr) {
        this.keyInfoResolver = kr;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return this.aFactory;
    }

    public void setAlgorithmFactory(AlgorithmFactory factory) {
        this.aFactory = factory;
    }

    public ResourceShower getResourceShower() {
        return this.shower;
    }

    public void setResourceShower(ResourceShower shower) {
        this.shower = shower;
    }

    public NullURIHandler getNullURIHandler() {
        return this.nullHandler;
    }

    public void setNullURIHandler(NullURIHandler nuh) {
        this.nullHandler = nuh;
    }

    public boolean getUseInternalIDResolver() {
        return this.useInternalIDResolver;
    }

    public void setUseInternalIDResolver(boolean use) {
        this.useInternalIDResolver = use;
    }

    OMElement getSignatureElement() {
        return this.signature;
    }

    OMElement setSignatureElement(OMElement newSig) {
        OMElement prev = this.signature;
        this.signature = newSig;
        return prev;
    }

    OMElement getOwnerElement() {
        return this.owner;
    }

    OMElement setOwnerElement(OMElement newOwner) {
        OMElement prevOwner = this.owner;
        this.owner = newOwner;
        return prevOwner;
    }

    Signature getSignatureWSSObject() {
        return this.signatureWSSObject;
    }

    Signature setSignatureWSSObject(Signature newSig) {
        Signature prev = this.signatureWSSObject;
        this.signatureWSSObject = newSig;
        return prev;
    }

    WSSObjectElement getOwnerWSSObject() {
        return this.ownerWSSObject;
    }

    WSSObjectElement setOwnerWSSObject(WSSObjectElement newOwner) {
        WSSObjectElement prevOwner = this.ownerWSSObject;
        this.ownerWSSObject = newOwner;
        return prevOwner;
    }

    public OMElement sign(OMElement signature, Key pkey) throws XSignatureException {
        Object fHWKeyCache;
        this.signature = signature;
        this.owner = signature;
        this.isForSigning = true;
        if (this.isHWAccelerationProvider()) {
            fHWKeyCache = HWKeyCache.getInstance();
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            try {
                pkey = ((HWKeyCache)fHWKeyCache).translate(pkey);
            }
            catch (Exception e) {
                throw new XSignatureException(e);
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            fHWKeyCache = XSignature.internalSign(this, pkey);
            return fHWKeyCache;
        }
        catch (Exception ex) {
            System.out.println("HARDWARE: Signature signing with HW crypto provider failed, Continue using software provider");
            try {
                OMElement e = XSignature.internalSign(this, pkey);
                return e;
            }
            catch (Exception e) {
                throw new XSignatureException(e);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public Signature sign(Signature signature, Key pkey) throws XSignatureException {
        Object fHWKeyCache;
        this.signatureWSSObject = signature;
        this.ownerWSSObject = signature;
        this.isForSigning = true;
        if (this.isHWAccelerationProvider()) {
            fHWKeyCache = HWKeyCache.getInstance();
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
            try {
                pkey = ((HWKeyCache)fHWKeyCache).translate(pkey);
            }
            catch (Exception e) {
                throw new XSignatureException(e);
            }
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            fHWKeyCache = XSignature.internalWSSObjectSign(this, pkey);
            return fHWKeyCache;
        }
        catch (Exception ex) {
            System.out.println("HARDWARE: Signature signing with HW crypto provider failed, Continue using software provider");
            try {
                Signature e = XSignature.internalWSSObjectSign(this, pkey);
                return e;
            }
            catch (Exception e) {
                throw new XSignatureException(e);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Validity verify(OMElement signature, Key pkey, SignatureObject signatureObject) {
        this.signature = signature;
        this.owner = signature;
        Validity validity = null;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            validity = XSignature.internalVerify(this, pkey, signatureObject);
        }
        catch (Exception e) {
            if (!this.isHWKeyStoreProvider() && this.isHWAccelerationProvider()) {
                this.aFactory.clearLocalProviderMap();
                System.out.println("HARDWARE: signature verification with HW crypto provider failed, Continue using software provider");
                validity = XSignature.internalVerify(this, pkey, signatureObject);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
        return validity;
    }

    public OMElement digestManifest(OMElement manifest) throws XSignatureException {
        this.signature = null;
        this.owner = manifest;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            OMElement oMElement = ManifestProcessor.digest(this);
            return oMElement;
        }
        catch (Exception ex) {
            System.out.println("HARDWARE: Digest with HW crypto provider failed, Continue using software provider");
            try {
                OMElement oMElement = ManifestProcessor.digest(this);
                return oMElement;
            }
            catch (Exception e) {
                throw new XSignatureException(e);
            }
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public Validity verifyManifest(OMElement manifest) throws Exception {
        this.signature = null;
        this.owner = manifest;
        if (this.isHWAccelerationProvider()) {
            this.aFactory.setLocalProvider("HWCONFIG", this.getHWAccelerationProvider());
        }
        if (this.isHWKeyStoreProvider()) {
            this.aFactory.setLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef", this.getHWKeyStoreProvider());
        }
        try {
            Validity validity = ManifestProcessor.verify(this);
            return validity;
        }
        catch (Exception e) {
            System.out.println("HARDWARE: Verify with HW crypto provider failed, Continue using software provider");
            Validity validity = ManifestProcessor.verify(this);
            return validity;
        }
        finally {
            if (this.isHWAccelerationProvider() || this.isHWKeyStoreProvider()) {
                this.aFactory.clearLocalProviderMap();
            }
        }
    }

    public static void setKeyInfo(OMElement signature, KeyInfoGenerator keyGen) throws SignatureStructureException {
        ProcessKey.setKeyInfo(signature, keyGen);
    }

    protected OMDocument parse(InputSource src) throws IOException, SAXException, XMLStreamException {
        XMLStreamReader reader = null;
        InputStream in = src.getByteStream();
        if (in != null) {
            reader = StAXUtils.createXMLStreamReader(in);
        } else {
            Reader r = src.getCharacterStream();
            reader = StAXUtils.createXMLStreamReader(r);
        }
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMDocument doc = builder.getDocument();
        XPathUtil.fixTree(doc.getOMDocumentElement());
        return doc;
    }

    private OMDocument parse(ByteArrayHolder octets) throws IOException, TransformException {
        try {
            return this.parse(new InputSource(new ByteArrayInputStream(octets.getValue(), octets.getOffset(), octets.getLength())));
        }
        catch (SAXException se) {
            throw TransformException.create(se);
        }
        catch (XMLStreamException xse) {
            throw TransformException.create(xse);
        }
    }

    private OMElement parseWithConfirmingRoot(ByteArrayHolder octets, String expected) throws SignatureStructureException, IOException, TransformException {
        OMDocument doc = this.parse(octets);
        OMElement root = doc.getOMDocumentElement();
        if (!XSignature.isDsigElement(root, expected)) {
            throw new SignatureStructureException("Type mismatch: Type=" + expected + ", root=" + root.getQName());
        }
        return root;
    }

    public Object retrieve(OMElement retrieve) throws XSignatureException {
        try {
            this.signature = null;
            this.owner = retrieve;
            ByteArrayHolder octets = ReferenceProcessor.getTransformedOctets(this, DOMUtil.getOwnerDocument(retrieve), retrieve, -1);
            Object result = octets;
            OMAttribute typeAttr = retrieve.getAttribute(TYPE_Q);
            if (typeAttr == null) {
                return result;
            }
            String type = typeAttr.getAttributeValue();
            if (type.equals("http://www.w3.org/2000/09/xmldsig#X509Data")) {
                OMElement root = this.parseWithConfirmingRoot(octets, "X509Data");
                result = new KeyInfo.X509Data(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#PGPData")) {
                OMElement root = this.parseWithConfirmingRoot(octets, "PGPData");
                result = new KeyInfo.PGPData(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#SPKIData")) {
                OMElement root = this.parseWithConfirmingRoot(octets, "SPKIData");
                result = new KeyInfo.SPKIData(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#MgmtData")) {
                OMElement root = this.parseWithConfirmingRoot(octets, "MgmgtData");
                result = DOMUtil.getStringValue(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream is = new ByteArrayInputStream(octets.getValue(), octets.getOffset(), octets.getLength());
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
                result = cert;
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#DSAKeyValue")) {
                OMElement root = this.parseWithConfirmingRoot(octets, "DSAKeyValue");
                result = ProcessKey.createDSAKey(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#RSAKeyValue")) {
                OMElement root = this.parseWithConfirmingRoot(octets, "RSAKeyValue");
                result = ProcessKey.createRSAKey(root);
            } else if (type.equals("http://www.w3.org/2001/04/xmlenc#EncryptedKey")) {
                ByteArrayInputStream is = new ByteArrayInputStream(octets.getValue(), octets.getOffset(), octets.getLength());
                StAXOMBuilder builder = new StAXOMBuilder(is);
                OMElement e = builder.getDocumentElement();
                result = new EncryptedKey(e);
            }
            return result;
        }
        catch (Exception ex) {
            throw new XSignatureException(ex);
        }
    }

    public Map getContext() {
        return this._context;
    }

    public void setContext(Map _idMap) {
        this._context = _idMap;
    }

    public void setDocument(OMDocument document) {
        this._document = document;
    }

    public OMDocument getDocument() {
        return this._document;
    }

    public boolean isDebug() {
        return false;
    }

    public boolean isForSigning() {
        return this.isForSigning;
    }

    public boolean isOnlySignEntireHeadersAndBody() {
        return this._onlySignEntireHeadersAndBody;
    }

    public void setOnlySignEntireHeadersAndBody(boolean onlySignEntireHeadersAndBody) {
        this._onlySignEntireHeadersAndBody = onlySignEntireHeadersAndBody;
    }

    public void setInclusiveNamespacesForSTRDT(boolean addIncNS) {
        this._incNSForSTRDT = new Boolean(addIncNS);
    }

    public Boolean getInclusiveNampespacesForSTRDT() {
        return this._incNSForSTRDT;
    }
}

