/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.SimpleKey;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

class ProcessKey {
    static final boolean DEBUG = false;

    private ProcessKey() {
    }

    private static String encodeBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();
        int off = 0;
        while (data[off] == 0) {
            ++off;
        }
        return Base64.encode(data, off, data.length - off);
    }

    private static boolean matchClass(Class cl, String className) {
        if (cl.getName().equals(className)) {
            return true;
        }
        Class superclass = cl.getSuperclass();
        if (superclass != null && ProcessKey.matchClass(superclass, className)) {
            return true;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!ProcessKey.matchClass(interfaces[i], className)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object obj, String className) {
        return ProcessKey.matchClass(obj.getClass(), className);
    }

    static OMElement createKeyValue(OMFactory doc, IndentConfig iconf, Key key) {
        OMElement keyValue = DOMUtils.createDsigOMElement("KeyValue", doc);
        if (ProcessKey.instanceOf(key, "java.security.interfaces.DSAPublicKey")) {
            DOMUtil.addIndent(keyValue, iconf, 3);
            DSAPublicKey dkey = (DSAPublicKey)key;
            DSAParams params = dkey.getParams();
            OMElement dsakv = DOMUtils.createDsigOMElement("DSAKeyValue", doc, keyValue);
            DOMUtil.addIndent(dsakv, iconf, 4);
            String text = ProcessKey.encodeBigInteger(params.getP());
            if (iconf.doIndentation()) {
                text = Base64.format(text, iconf.getUnit() * 5, "\n", DOMUtil.getSpaces(iconf, 4));
            }
            dsakv.addChild(DOMUtil.createTextElementNS(doc, dsakv, "P", text));
            DOMUtil.addIndent(dsakv, iconf, 4);
            text = ProcessKey.encodeBigInteger(params.getQ());
            dsakv.addChild(DOMUtil.createTextElementNS(doc, dsakv, "Q", text));
            DOMUtil.addIndent(dsakv, iconf, 4);
            text = ProcessKey.encodeBigInteger(params.getG());
            if (iconf.doIndentation()) {
                text = Base64.format(text, iconf.getUnit() * 5, "\n", DOMUtil.getSpaces(iconf, 4));
            }
            dsakv.addChild(DOMUtil.createTextElementNS(doc, dsakv, "G", text));
            DOMUtil.addIndent(dsakv, iconf, 4);
            text = ProcessKey.encodeBigInteger(dkey.getY());
            if (iconf.doIndentation()) {
                text = Base64.format(text, iconf.getUnit() * 5, "\n", DOMUtil.getSpaces(iconf, 4));
            }
            dsakv.addChild(DOMUtil.createTextElementNS(doc, dsakv, "Y", text));
            DOMUtil.addIndent(dsakv, iconf, 3);
            keyValue.addChild(dsakv);
            DOMUtil.addIndent(keyValue, iconf, 2);
        } else if (ProcessKey.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
            RSA.createKeyValue(doc, iconf, key, keyValue);
        } else {
            keyValue.addChild(doc.createOMText(Base64.encode(key.getEncoded())));
        }
        return keyValue;
    }

    static void printKey(Key key) {
        PrintStream ps = System.err;
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dkey = (DSAPublicKey)key;
            DSAParams params = dkey.getParams();
            ps.println("P: " + params.getP());
            ps.println("Q: " + params.getQ());
            ps.println("G: " + params.getG());
            ps.println("Y: " + dkey.getY());
            ps.println("P: " + ProcessKey.encodeBigInteger(params.getP()));
            ps.println("Q: " + ProcessKey.encodeBigInteger(params.getQ()));
            ps.println("G: " + ProcessKey.encodeBigInteger(params.getG()));
            ps.println("Y: " + ProcessKey.encodeBigInteger(dkey.getY()));
            ps.print("P: ");
            ProcessKey.printByteArray(ps, params.getP());
            ps.print("Q: ");
            ProcessKey.printByteArray(ps, params.getQ());
            ps.print("G: ");
            ProcessKey.printByteArray(ps, params.getG());
            ps.print("Y: ");
            ProcessKey.printByteArray(ps, dkey.getY());
        } else if (ProcessKey.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
            RSA.print(ps, key);
        } else {
            ps.println("Neither DSAPublicky nor RsAPublicKey");
        }
    }

    private static void printByteArray(PrintStream ps, BigInteger i) {
        ps.println(Base64.toHexString(i.toByteArray()));
    }

    static Key createKey(OMElement keyValue) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        OMNode node = DOMUtil.getFirstChild2(keyValue);
        while (node != null) {
            if (node.getType() == 1) {
                OMElement el = (OMElement)node;
                if (!XSignature.isDsigElement(el)) {
                    throw new SignatureStructureException("Unknown element: " + el.getQName());
                }
                if (XSignature.isDsigElement(el, "DSAKeyValue")) {
                    return ProcessKey.createDSAKey(el);
                }
                if (XSignature.isDsigElement(el, "RSAKeyValue")) {
                    return ProcessKey.createRSAKey(el);
                }
                throw new SignatureStructureException("Unknown element: " + el.getQName());
            }
            node = DOMUtil.getNextSibling2(node);
        }
        String valueString = DOMUtil.getStringValue(keyValue);
        return new SimpleKey(Base64.decode(valueString));
    }

    static Key createDSAKey(OMElement dsakv) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger p = null;
        BigInteger q = null;
        BigInteger g = null;
        BigInteger y = null;
        OMNode node = DOMUtil.getFirstChild2(dsakv);
        while (node != null) {
            if (node.getType() == 1) {
                OMElement el = (OMElement)node;
                if (XSignature.isDsigElement(el, "P")) {
                    p = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (XSignature.isDsigElement(el, "Q")) {
                    q = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (XSignature.isDsigElement(el, "G")) {
                    g = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (XSignature.isDsigElement(el, "Y")) {
                    y = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else if (!(XSignature.isDsigElement(el, "J") || XSignature.isDsigElement(el, "Seed") || XSignature.isDsigElement(el, "PgenCounter"))) {
                    throw new SignatureStructureException("Unknown element: " + el.getQName());
                }
            }
            node = DOMUtil.getNextSibling2(node);
        }
        if (p == null) {
            throw new SignatureStructureException("No P element in the DSAKeyValue element.");
        }
        if (q == null) {
            throw new SignatureStructureException("No Q element in the DSAKeyValue element.");
        }
        if (g == null) {
            throw new SignatureStructureException("No G element in the DSAKeyValue element.");
        }
        if (y == null) {
            throw new SignatureStructureException("No Y element in the DSAKeyValue element.");
        }
        KeyFactory factory = KeyFactory.getInstance("DSA");
        return factory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
    }

    static Key createRSAKey(OMElement rsakv) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger modulus = null;
        BigInteger exponent = null;
        OMNode node = DOMUtil.getFirstChild2(rsakv);
        while (node != null) {
            if (node.getType() == 1) {
                OMElement el = (OMElement)node;
                if (XSignature.isDsigElement(el, "Modulus")) {
                    byte[] md = Base64.decode(DOMUtil.getStringValue(el));
                    modulus = new BigInteger(1, md);
                } else if (XSignature.isDsigElement(el, "Exponent")) {
                    exponent = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(el)));
                } else {
                    throw new SignatureStructureException("Unknown element: " + el.getQName());
                }
            }
            node = DOMUtil.getNextSibling2(node);
        }
        if (modulus == null) {
            throw new SignatureStructureException("No Modulus element in the RSAKeyValue element.");
        }
        if (exponent == null) {
            throw new SignatureStructureException("No Exponent element in the RSAKeyValue element.");
        }
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(new RSAPublicKeySpec(modulus, exponent));
    }

    static void setKeyInfo(OMElement signature, KeyInfoGenerator keyGen) throws SignatureStructureException {
        OMElement signatureValue = XSignature.getFirstChild(signature, "SignatureValue");
        if (signatureValue == null) {
            throw new SignatureStructureException("The Signature element has no SignatureValue element.");
        }
        OMNode next = signatureValue.getNextOMSibling();
        OMFactory factory = signature.getOMFactory();
        OMElement keyInfo = keyGen.getKeyInfoElement(factory);
        if (next == null) {
            signature.addChild(factory.createOMText("\n  "));
            signature.addChild(keyInfo);
        } else {
            next.insertSiblingBefore(factory.createOMText("\n  "));
            next.insertSiblingBefore(keyInfo);
        }
    }

    static Key processKeyInfo(SignatureContext scontext, OMElement keyInfo) throws CertificateException, NoSuchAlgorithmException, SignatureStructureException, InvalidKeySpecException, IOException, TransformException, SoapSecurityException {
        Key keyValue = null;
        Key certKey = null;
        int nofcerts = 0;
        OMNode ch = DOMUtil.getFirstChild2(keyInfo);
        while (ch != null) {
            if (ch.getType() == 1) {
                OMElement el = (OMElement)ch;
                if (XSignature.isDsigElement(el, "KeyValue")) {
                    keyValue = ProcessKey.createKey(el);
                } else if (XSignature.isDsigElement(el, "RetrievalMethod")) {
                    ByteArrayHolder octets = ReferenceProcessor.getTransformedOctets(scontext, DOMUtil.getOwnerDocument(el), el, -1);
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream is = new ByteArrayInputStream(octets.getValue(), octets.getOffset(), octets.getLength());
                    X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
                    if (keyValue == null) {
                        keyValue = cert.getPublicKey();
                    }
                } else if (XSignature.isDsigElement(el, "X509Data")) {
                    OMNode x5 = DOMUtil.getFirstChild2(el);
                    while (x5 != null) {
                        OMElement x5Element;
                        if (x5.getType() == 1 && XSignature.isDsigElement(x5Element = (OMElement)x5) && XSignature.isDsigElement(x5Element, "X509Certificate")) {
                            ++nofcerts;
                            byte[] certbytes = Base64.decode(DOMUtil.getStringValue(x5Element));
                            ByteArrayInputStream bais = new ByteArrayInputStream(certbytes);
                            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(bais);
                            if (certKey == null) {
                                certKey = cert.getPublicKey();
                            }
                        }
                        x5 = DOMUtil.getNextSibling2(x5);
                    }
                }
            }
            ch = DOMUtil.getNextSibling2(ch);
        }
        if (nofcerts > 1) {
            certKey = null;
        }
        return keyValue != null ? keyValue : certKey;
    }

    private static class RSA {
        private RSA() {
        }

        static void createKeyValue(OMFactory doc, IndentConfig iconf, Key key, OMElement keyValue) {
            DOMUtil.addIndent(keyValue, iconf, 3);
            RSAPublicKey rkey = (RSAPublicKey)key;
            OMElement rsakv = DOMUtils.createDsigOMElement("RSAKeyValue", doc);
            DOMUtil.addIndent(rsakv, iconf, 4);
            String text = ProcessKey.encodeBigInteger(rkey.getModulus());
            if (iconf.doIndentation()) {
                text = Base64.format(text, iconf.getUnit() * 5, "\n", DOMUtil.getSpaces(iconf, 4));
            }
            rsakv.addChild(DOMUtil.createTextElementNS(doc, rsakv, "Modulus", text));
            DOMUtil.addIndent(rsakv, iconf, 4);
            text = ProcessKey.encodeBigInteger(rkey.getPublicExponent());
            rsakv.addChild(DOMUtil.createTextElementNS(doc, rsakv, "Exponent", text));
            DOMUtil.addIndent(rsakv, iconf, 3);
            keyValue.addChild(rsakv);
            DOMUtil.addIndent(keyValue, iconf, 2);
        }

        static void print(PrintStream ps, Key key) {
            RSAPublicKey rkey = (RSAPublicKey)key;
            ps.println("Modulus: " + rkey.getModulus());
            ps.println("Exponent: " + rkey.getPublicExponent());
            ps.println("Modulus: " + ProcessKey.encodeBigInteger(rkey.getModulus()));
            ps.println("Exponent: " + ProcessKey.encodeBigInteger(rkey.getPublicExponent()));
        }
    }
}

