/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ValidityDOM;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

class ManifestProcessor {
    private ManifestProcessor() {
    }

    static OMElement digest(SignatureContext scontext) throws SignatureStructureException, TransformException, IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException, SoapSecurityException {
        int refno = 0;
        OMElement reference = DOMUtil.getFirstChildElement(scontext.getOwnerElement());
        while (reference != null) {
            if (!XSignature.isDsigElement(reference, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + reference.getQName());
            }
            ReferenceProcessor.substDigest(scontext, reference, refno++);
            reference = DOMUtil.getNextElement(reference);
        }
        return scontext.getOwnerElement();
    }

    static Validity verify(SignatureContext scontext) {
        ValidityDOM domv = new ValidityDOM();
        int refno = 0;
        try {
            block6: for (OMNode child = scontext.getOwnerElement().getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                switch (child.getType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        continue block6;
                    }
                    case 1: {
                        OMElement reference = (OMElement)child;
                        if (XSignature.isDsigElement(reference, "Reference")) {
                            ReferenceValidity rv = ReferenceProcessor.verify(scontext, reference, refno++);
                            domv.addReferenceValidity(rv);
                            continue block6;
                        }
                    }
                    default: {
                        throw new SignatureStructureException("Invalid node in the Manifest element:" + ((OMElement)child).getQName());
                    }
                }
            }
        }
        catch (SignatureStructureException sse) {
            domv.setSignedInfoMessage(sse.getMessage());
        }
        domv.setSignedInfoValidity(true);
        domv.setSignedInfoMessage("N/A");
        domv.setCoreValidity();
        return domv;
    }
}

