/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class ToXMLVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected String encoding = null;
    protected boolean isPrintNonSpecifiedAttributes = true;

    public ToXMLVisitor(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public ToXMLVisitor(Writer writer) {
        this(writer, null);
    }

    public void setPrintNonSpecifiedAttributes(boolean print) {
        this.isPrintNonSpecifiedAttributes = print;
    }

    public boolean getPrintNonSpecifiedAttributes() {
        return this.isPrintNonSpecifiedAttributes;
    }

    @Override
    public void visitDocumentPre(OMDocument document) throws Exception {
        this.writer.write("<?xml version=\"1.0\"?>");
    }

    @Override
    public void visitDocumentPost(OMDocument document) throws Exception {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitElementPre(OMElement element) throws Exception {
        Iterator nnm;
        Iterator ns;
        String prefix;
        this.writer.write("<");
        String string = prefix = element.getNamespace() == null ? null : element.getNamespace().getPrefix();
        if (prefix != null && prefix.length() != 0) {
            this.writer.write(prefix);
            this.writer.write(":");
        }
        this.writer.write(element.getLocalName());
        Iterator iterator = ns = element.getAllDeclaredNamespaces();
        synchronized (iterator) {
            while (ns.hasNext()) {
                OMNamespace attr = (OMNamespace)ns.next();
                this.visitNamespacePre(attr);
            }
        }
        Iterator iterator2 = nnm = element.getAllAttributes();
        synchronized (iterator2) {
            while (nnm.hasNext()) {
                OMAttribute attr = (OMAttribute)nnm.next();
                this.visitAttributePre(attr);
            }
        }
        if (element.getChildren().hasNext()) {
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
    }

    @Override
    public void visitElementPost(OMElement element) throws Exception {
        if (element.getChildren().hasNext()) {
            String prefix;
            this.writer.write("</");
            String string = prefix = element.getNamespace() == null ? null : element.getNamespace().getPrefix();
            if (prefix != null && prefix.length() != 0) {
                this.writer.write(prefix);
                this.writer.write(":");
            }
            this.writer.write(element.getLocalName());
            this.writer.write(">");
        }
    }

    @Override
    public void visitAttributePre(OMAttribute attribute) throws Exception {
        String prefix;
        this.writer.write(" ");
        String string = prefix = attribute.getNamespace() == null ? null : attribute.getNamespace().getPrefix();
        if (prefix != null && prefix.length() != 0) {
            this.writer.write(prefix);
            this.writer.write(":");
        }
        this.writer.write(attribute.getLocalName());
        this.writer.write("=\"");
        this.writer.write(attribute.getAttributeValue());
        this.writer.write("\"");
    }

    @Override
    public void visitProcessingInstructionPre(OMProcessingInstruction pi) throws Exception {
        this.writer.write("<?");
        this.writer.write(pi.getTarget());
        if (pi.getValue().length() > 0) {
            this.writer.write(" ");
            this.writer.write(pi.getValue());
        }
        this.writer.write("?>");
    }

    @Override
    public void visitCommentPre(OMComment comment) throws Exception {
        this.writer.write("<!--");
        this.writer.write(comment.getValue());
        this.writer.write("-->");
    }

    @Override
    public void visitTextPre(OMText text) throws Exception {
        this.escapedWrite(this.writer, text.getText(), "<&", this.encoding);
    }

    @Override
    public void visitDocumentTypePre(OMDocType doctype) throws Exception {
        this.writer.write("<!DOCTYPE ");
        this.writer.write(doctype.getValue());
        this.writer.write(">");
    }

    public void escapedWrite(Writer writer, String string, String encoding) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
                continue;
            }
            if ('>' == ch) {
                writer.write("&gt;");
                continue;
            }
            if ('&' == ch) {
                writer.write("&amp;");
                continue;
            }
            if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                }
                if (56320 > (next = string.charAt(++i)) || next >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(next));
                writer.write(";");
                continue;
            }
            writer.write(ch);
        }
    }

    public void escapedWrite(Writer writer, String string, String specials, String encoding) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            int index = specials.indexOf(ch);
            if (index >= 0) {
                writer.write("&#");
                writer.write(Integer.toString(ch));
                writer.write(";");
                continue;
            }
            if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " ?");
                }
                if (56320 > (next = string.charAt(++i)) || next >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(ch) + " " + Integer.toHexString(next));
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(next));
                writer.write(";");
                continue;
            }
            writer.write(ch);
        }
    }
}

