/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class PrintNodeTreeVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected int indent = 0;
    protected int dx = 2;

    public PrintNodeTreeVisitor(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void visitElementPre(OMElement node) throws Exception {
        this.indent();
        this.writer.write("[Element] " + node.getQName() + "\n");
        this.indent += this.dx;
    }

    @Override
    public void visitElementPost(OMElement node) throws Exception {
        this.indent -= this.dx;
    }

    @Override
    public void visitTextPre(OMText node) throws Exception {
        this.indent();
        this.writer.write("[Text] \"");
        this.printText(node.getText());
        this.writer.write("\"\n");
    }

    @Override
    public void visitProcessingInstructionPre(OMProcessingInstruction node) throws Exception {
        this.indent();
        this.writer.write("[ProcessingInstruction] " + node.getTarget() + " \"");
        this.printText(node.getValue());
        this.writer.write("\"\n");
    }

    @Override
    public void visitCommentPre(OMComment node) throws Exception {
        this.indent();
        this.writer.write("[Comment] \"" + node.getValue() + "\"\n");
    }

    @Override
    public void visitDocumentPre(OMDocument node) throws Exception {
        this.indent();
        this.writer.write("[Document]\n");
        this.indent += this.dx;
    }

    @Override
    public void visitDocumentPost(OMDocument node) throws Exception {
        this.indent -= this.dx;
        this.writer.flush();
    }

    @Override
    public void visitDocumentTypePre(OMDocType node) throws Exception {
        this.indent();
        this.writer.write("[DocumentType] " + node.getValue() + "\n");
    }

    @Override
    public void visitUnknownPre(OMNode node) throws Exception {
        this.indent();
        this.writer.write("[???Unknown]\n");
    }

    protected void indent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(" ");
        }
    }

    protected void printText(String str) throws IOException {
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\r': {
                    this.writer.write("&#x0d;");
                    continue block5;
                }
                case '\n': {
                    this.writer.write("&#x0a;");
                    continue block5;
                }
                case '\"': {
                    this.writer.write("&#x22;");
                    continue block5;
                }
                default: {
                    this.writer.write(ch);
                }
            }
        }
    }
}

