/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Exclusive3;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public class ExclusiveCanonicalizer {
    private static final boolean DEBUG = false;
    private static final TraceComponent tc = Tr.register(ExclusiveCanonicalizer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    private ExclusiveCanonicalizer() {
    }

    public static void serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments, Writer wr) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.size());
        for (int i = 0; i < nodeList.size(); ++i) {
            Object obj2;
            OMElement owner;
            Hashtable namespaces;
            Object obj = nodeList.get(i);
            if (obj instanceof OMNode) {
                Object attr;
                Object ns;
                OMNode node = (OMNode)obj;
                nodeVector.addElement(node);
                if (node.getType() != 1) continue;
                namespaces = new Hashtable();
                if (i + 1 < nodeList.size() && (ns = nodeList.get(i + 1)) instanceof OMNamespace && XPathCanonicalizer.isOwnerElement(node, (OMNamespace)ns)) {
                    Object obj22;
                    ++i;
                    while (i < nodeList.size() && (obj22 = nodeList.get(i)) instanceof OMNamespace && XPathCanonicalizer.isOwnerElement(node, (OMNamespace)obj22)) {
                        namespaces.put(((OMNamespace)obj22).getPrefix(), obj22);
                        ++i;
                    }
                    if (namespaces.containsKey("") && ((OMNamespace)namespaces.get("")).getName().length() == 0) {
                        namespaces.remove("");
                    }
                    --i;
                }
                nodeVector.addElement(new XPathCanonicalizer.OMNamespaces(node, namespaces));
                Hashtable attributes = new Hashtable();
                if (i + 1 < nodeList.size() && (attr = nodeList.get(i + 1)) instanceof OMAttribute && XPathCanonicalizer.isOwnerElement(node, (OMAttribute)attr)) {
                    Object obj23;
                    ++i;
                    while (i < nodeList.size() && (obj23 = nodeList.get(i)) instanceof OMAttribute && XPathCanonicalizer.isOwnerElement(node, (OMAttribute)obj23)) {
                        attributes.put(((OMAttribute)obj23).getQName(), obj23);
                        ++i;
                    }
                    --i;
                }
                nodeVector.addElement(new XPathCanonicalizer.OMAttributes(node, attributes));
                continue;
            }
            if (obj instanceof OMNamespaceWithOwner) {
                owner = ((OMNamespaceWithOwner)obj).getOwnerElement();
                namespaces = new Hashtable();
                while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMNamespace && owner == ((OMNamespaceWithOwner)obj2).getOwnerElement()) {
                    namespaces.put(((OMNamespace)obj2).getPrefix(), obj2);
                    ++i;
                }
                nodeVector.addElement(new XPathCanonicalizer.OMNamespaces(owner, namespaces));
                --i;
                continue;
            }
            if (!(obj instanceof OMAttributeWithOwner)) continue;
            owner = ((OMAttributeWithOwner)obj).getOwnerElement();
            Hashtable attributes = new Hashtable();
            while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMAttribute && owner == ((OMNamespaceWithOwner)obj2).getOwnerElement()) {
                attributes.put(((OMAttribute)obj2).getQName(), obj2);
                ++i;
            }
            nodeVector.addElement(new XPathCanonicalizer.OMAttributes(owner, attributes));
            --i;
        }
        if (!(wr instanceof BufferedWriter)) {
            wr = new BufferedWriter(wr);
        }
        Stack nStack = new Stack();
        Stack aStack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            ExclusiveCanonicalizer.serializeSubset(nStack, aStack, prefixList, nodeVector, i, withComments, wr);
        }
        wr.flush();
    }

    private static void serializeSubset(Stack nStack, Stack aStack, Hashtable prefixList, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException {
        OMContainer parent;
        String prefix;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof XPathCanonicalizer.OMNamespaces) {
            nodeVector.setElementAt(null, i);
            ((XPathCanonicalizer.OMNamespaces)obj).serialize(null, prefixList, null, wr);
            return;
        }
        if (obj instanceof XPathCanonicalizer.OMAttributes) {
            nodeVector.setElementAt(null, i);
            ((XPathCanonicalizer.OMAttributes)obj).serialize(null, prefixList, null, wr);
            return;
        }
        OMNode node = (OMNode)obj;
        int type = node.getType();
        if (type != 1) {
            XPathCanonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        OMElement elem = (OMElement)node;
        String string = prefix = elem.getNamespace() == null ? null : elem.getNamespace().getPrefix();
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        XPathCanonicalizer.OMNamespaces ancestorNss = nStack.empty() ? null : (XPathCanonicalizer.OMNamespaces)nStack.peek();
        XPathCanonicalizer.OMNamespaces nss = null;
        int next = i + 1;
        boolean printXmlns = prefixList == null || prefixList.get("") == null ? prefix == null : true;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof OMNode) {
            parent = elem.getParent();
            if (printXmlns && !(parent instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("")) {
                wr.write(" xmlns=\"\"");
            }
        } else if (nodeVector.elementAt(next) instanceof XPathCanonicalizer.OMNamespaces) {
            nss = (XPathCanonicalizer.OMNamespaces)nodeVector.elementAt(next);
            if (!nss.contains("")) {
                parent = elem.getParent();
                if (printXmlns && !(parent instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("")) {
                    wr.write(" xmlns=\"\"");
                }
            }
            if (prefix == null) {
                prefix = "";
            }
            nss.serialize(nStack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
            ++next;
        }
        XPathCanonicalizer.OMAttributes ancestorAttrs = aStack.empty() ? null : (XPathCanonicalizer.OMAttributes)aStack.peek();
        XPathCanonicalizer.OMAttributes attrs = null;
        if (next < nodeVector.size() && nodeVector.elementAt(next) instanceof XPathCanonicalizer.OMAttributes) {
            attrs = (XPathCanonicalizer.OMAttributes)nodeVector.elementAt(next);
            if (prefix == null) {
                prefix = "";
            }
            attrs.serialize(aStack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        nStack.push(nss);
        aStack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            ExclusiveCanonicalizer.serializeSubset(nStack, aStack, prefixList, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        nStack.pop();
        aStack.pop();
        wr.write("</");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        wr.write(">");
    }

    public static void serializeAll(Hashtable prefixList, OMDocument doc, boolean withComments, Writer wr) throws IOException {
        Exclusive3.serializeNode(prefixList, doc.getOMDocumentElement(), withComments, wr);
    }

    public static void serializeSubset(Hashtable prefixList, OMNode node, boolean withComments, Writer wr) throws IOException {
        Exclusive3.serializeNode(prefixList, node, withComments, wr);
    }

    public static void serializeSubset(Hashtable prefixList, Iterator iter, boolean withComments, Writer wr) throws IOException {
        OMNode n;
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        while ((n = (OMNode)iter.next()) != null) {
            list.add(n);
        }
        ExclusiveCanonicalizer.serializeSubset(prefixList, list, withComments, wr);
    }

    public static ByteArrayHolder serializeAll(Hashtable prefixList, OMDocument doc, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            Exclusive3.serializeNode(prefixList, doc.getOMDocumentElement(), withComments, wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static ByteArrayHolder serializeSubset(Hashtable prefixList, OMNode node, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            Exclusive3.serializeNode(prefixList, node, withComments, wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static ByteArrayHolder serializeSubset(Hashtable prefixList, Iterator iter, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            ExclusiveCanonicalizer.serializeSubset(prefixList, iter, withComments, (Writer)wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static ByteArrayHolder serializeSubset(Hashtable prefixList, ArrayList nodeList, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            ExclusiveCanonicalizer.serializeSubset(prefixList, nodeList, withComments, (Writer)wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static Hashtable parsePrefixList(String ssv) {
        Hashtable<String, String> prefixList = null;
        if (ssv == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(ssv, " \t\r\n");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (prefixList == null) {
                prefixList = new Hashtable<String, String>();
            }
            if (tok.equals("#default")) {
                tok = "";
            }
            prefixList.put(tok, tok);
        }
        return prefixList;
    }
}

