/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.filter.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.filter.util.NamespaceStack;
import com.ibm.ws.wssecurity.filter.util.StringSequentialSortedSet;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.Exclusive2;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;

public class Exclusive3 {
    private static final TraceComponent tc = Tr.register(Exclusive3.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final boolean DEBUG = false;
    public static boolean USE_EXCLUSIVE2 = false;

    public static final void serializeNode(Map prefixList, OMNode node, boolean comments, Writer wr) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Exclusive3,serializeNode, prefixList=" + prefixList + ", target=" + DOMUtils.getDisplayName(node) + ", withComment=" + comments + ", writer=" + wr);
        }
        if (USE_EXCLUSIVE2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exclusive3: Exclusive2 is used instead of Exclusive3.");
            }
            Exclusive2.serializeNode(prefixList, node, comments, wr);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeNode");
            }
            return;
        }
        if (prefixList != null && prefixList.size() == 0) {
            prefixList = null;
        }
        NamespaceStack rendered = new NamespaceStack();
        rendered.pushContext();
        StringSequentialSortedSet tobeRenderedSet = new StringSequentialSortedSet();
        AttributeSortedSet attrSortedSet = new AttributeSortedSet();
        if (!(wr instanceof BufferedWriter)) {
            wr = new BufferedWriter(wr);
        }
        Exclusive3.serializeNode(prefixList, node, comments, rendered, tobeRenderedSet, attrSortedSet, wr, true);
        wr.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeNode");
        }
    }

    private static final void serializeElement(Map prefixList, OMElement elem, boolean comments, NamespaceStack nsRendered, StringSequentialSortedSet tobeRenderedSet, AttributeSortedSet attrSortedSet, Writer wr, boolean asRoot) throws IOException {
        int tobeRenderedSize;
        if (elem instanceof OMSourcedElement) {
            OMSourcedElement omse = (OMSourcedElement)elem;
            if (omse.isExpanded()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exclusive3.serializeElement(...) finds OMSourcedElement. But it had been expanded.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exclusive3.serializeElement(...) finds OMSourcedElement. Let's expand it by using omse.getFirstOMChild().");
                }
                omse.getFirstOMChild();
            }
        }
        nsRendered.pushContext();
        if (asRoot && prefixList != null) {
            Exclusive3.gatherToBeRenderedInclusiveNamespaces(elem, prefixList, tobeRenderedSet);
        }
        String elemLocalName = elem.getLocalName();
        OMNamespace elemOMNamespace = elem.getNamespace();
        String elemPrefix = "";
        String elemNamespaceUri = "";
        if (elemOMNamespace != null) {
            elemPrefix = elemOMNamespace.getPrefix();
            if (elemPrefix == null) {
                elemPrefix = "";
            }
            if ((elemNamespaceUri = elemOMNamespace.getNamespaceURI()) == null) {
                elemNamespaceUri = "";
            }
        }
        wr.write("<");
        if (elemPrefix.length() > 0) {
            wr.write(elemPrefix);
            wr.write(":");
        }
        wr.write(elemLocalName);
        if (prefixList == null || !prefixList.containsKey(elemPrefix)) {
            String renderedNsUri = nsRendered.getURI(elemPrefix);
            if (renderedNsUri == null) {
                tobeRenderedSet.add(elemPrefix, elemNamespaceUri);
            } else if (!renderedNsUri.equals(elemNamespaceUri)) {
                tobeRenderedSet.add(elemPrefix, elemNamespaceUri);
            }
        }
        Iterator attrIterator = elem.getAllAttributes();
        int attrCount = 0;
        if (attrIterator.hasNext()) {
            attrSortedSet.reset();
            while (attrIterator.hasNext()) {
                OMAttribute omAttribute = (OMAttribute)attrIterator.next();
                String attrLocal = omAttribute.getLocalName();
                OMNamespace attrOMNamespace = omAttribute.getNamespace();
                String attrPrefix = "";
                String attrNsUri = "";
                if (attrOMNamespace != null) {
                    attrPrefix = attrOMNamespace.getPrefix();
                    if (attrPrefix == null) {
                        attrPrefix = "";
                    }
                    if ((attrNsUri = attrOMNamespace.getNamespaceURI()) == null) {
                        attrNsUri = "";
                    }
                }
                String attrValue = omAttribute.getAttributeValue();
                attrSortedSet.add(attrCount, attrNsUri, attrLocal, attrPrefix, attrValue);
                if (!("".equals(attrPrefix) || prefixList != null && prefixList.containsKey(attrPrefix))) {
                    String renderedNsUri = nsRendered.getURI(attrPrefix);
                    if (renderedNsUri == null) {
                        tobeRenderedSet.add(attrPrefix, attrNsUri);
                    } else if (!renderedNsUri.equals(attrNsUri)) {
                        tobeRenderedSet.add(attrPrefix, attrNsUri);
                    }
                }
                ++attrCount;
            }
        }
        if (prefixList != null) {
            Iterator nsDeclsIterator = elem.getAllDeclaredNamespaces();
            while (nsDeclsIterator.hasNext()) {
                String renderedNsUri;
                OMNamespace nsDeclOMNamespace = (OMNamespace)nsDeclsIterator.next();
                String nsDeclPrefix = nsDeclOMNamespace.getPrefix();
                if (nsDeclPrefix == null) {
                    nsDeclPrefix = "";
                }
                if (!prefixList.containsKey(nsDeclPrefix)) continue;
                String nsDeclUri = nsDeclOMNamespace.getNamespaceURI();
                if (nsDeclUri == null) {
                    nsDeclUri = "";
                }
                if ((renderedNsUri = nsRendered.getURI(nsDeclPrefix)) == null) {
                    tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
                    continue;
                }
                if (renderedNsUri.equals(nsDeclUri)) continue;
                tobeRenderedSet.add(nsDeclPrefix, nsDeclUri);
            }
        }
        if ((tobeRenderedSize = tobeRenderedSet.getSize()) > 0) {
            for (int i = 0; i < tobeRenderedSize; ++i) {
                String toBeRenderedPrefix = tobeRenderedSet.getPrefix(i);
                String toBeRenderedUri = tobeRenderedSet.getNsUri(i);
                C14nUtil.serializeNamespace(toBeRenderedPrefix, toBeRenderedUri, wr, true);
                nsRendered.declarePrefix(toBeRenderedPrefix, toBeRenderedUri);
            }
            tobeRenderedSet.reset();
        }
        if (attrCount > 0) {
            for (int i = 0; i < attrCount; ++i) {
                String attrPrefix = attrSortedSet.getPrefix(i);
                String attrLocalName = attrSortedSet.getLocal(i);
                String attrValue = attrSortedSet.getValue(i);
                C14nUtil.serializeAttribute(attrPrefix, attrLocalName, attrValue, wr, false);
            }
        }
        wr.write(">");
        for (OMNode child = elem.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            Exclusive3.serializeNode(prefixList, child, comments, nsRendered, tobeRenderedSet, attrSortedSet, wr, false);
        }
        wr.write("</");
        if (elemPrefix.length() != 0) {
            wr.write(elemPrefix);
            wr.write(":");
        }
        wr.write(elemLocalName);
        wr.write(">");
        nsRendered.popContext();
    }

    private static final void serializeNode(Map prefixList, OMNode node, boolean comments, NamespaceStack rendered, StringSequentialSortedSet tobeRenderedSet, AttributeSortedSet attrSortedSet, Writer wr, boolean asRoot) throws IOException {
        switch (node.getType()) {
            case 1: {
                Exclusive3.serializeElement(prefixList, (OMElement)node, comments, rendered, tobeRenderedSet, attrSortedSet, wr, asRoot);
                break;
            }
            case 4: 
            case 12: {
                C14nUtil.serializeText(((OMText)node).getText(), wr);
                break;
            }
            case 9: {
                for (OMNode child = ((OMContainer)((Object)node)).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    Exclusive3.serializeNode(prefixList, child, comments, rendered, tobeRenderedSet, attrSortedSet, wr, false);
                }
                break;
            }
            case 3: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 5: {
                if (!comments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
        }
    }

    private static final void gatherToBeRenderedInclusiveNamespaces(OMContainer cont, Map prefixList, StringSequentialSortedSet tobeRenderedSet) {
        boolean foundEmptyPrefixEmptyUri = false;
        while (cont instanceof OMElement) {
            OMElement node = (OMElement)cont;
            Iterator i = node.getAllDeclaredNamespaces();
            while (i.hasNext()) {
                OMNamespace ns = (OMNamespace)i.next();
                String prefix = ns.getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if ("".equals(prefix) && foundEmptyPrefixEmptyUri || !prefixList.containsKey(prefix) || tobeRenderedSet.getNsUri(prefix) != null) continue;
                String nsUri = ns.getNamespaceURI();
                if (nsUri == null) {
                    nsUri = "";
                }
                if ("".equals(nsUri)) {
                    foundEmptyPrefixEmptyUri = true;
                    continue;
                }
                tobeRenderedSet.add(prefix, nsUri);
                if (tobeRenderedSet.getSize() < prefixList.size()) continue;
                return;
            }
            cont = node.getParent();
        }
    }

    static {
        String prop = System.getProperty(Constants.USE_EXCLUSIVE2);
        if (prop != null && ("true".equalsIgnoreCase(prop) || "yes".equalsIgnoreCase(prop) || "1".equalsIgnoreCase(prop) || "on".equalsIgnoreCase(prop))) {
            USE_EXCLUSIVE2 = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exclusive3.static{}, USE_EXCLUSIVE2=" + USE_EXCLUSIVE2);
        }
    }
}

