/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.util.io.Base64Table;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectC14NWriter;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectNormalWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class VariablePart {
    public static final int VT_UTF8_BYTEARRAY_WO_CHAR_REF = 2;
    public static final int VT_STRING = 3;
    public static final int VT_BYTEARRAY_TO_BE_BASE64_ENCODED = 4;
    public static final int VT_QNAME = 5;
    public static final int VT_UTF8_BYTEARRAYHOLDER_WO_CHAR_REF = 6;
    public static final int VT_BYTEARRAYHOLDER_TO_BE_BASE64_ENCODED = 7;
    protected int valueType;
    protected Object valueObj;
    protected boolean hasCache = false;
    protected byte[] utf8S11N;
    protected byte[] utf8C14N;

    protected VariablePart() {
    }

    protected VariablePart(int valueType, Object valueObj) {
        this();
        this.valueType = valueType;
        this.valueObj = valueObj;
    }

    public final int getValueType() {
        return this.valueType;
    }

    public final Object getValueObj() {
        return this.valueObj;
    }

    public final String toString() {
        switch (this.valueType) {
            case 3: {
                return (String)this.valueObj;
            }
            case 2: {
                return new String((byte[])this.valueObj);
            }
            case 6: {
                ByteArrayHolder bah = (ByteArrayHolder)this.valueObj;
                return new String(bah.getValue(), bah.getOffset(), bah.getLength());
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                return this.valueObj.toString();
            }
        }
        return null;
    }

    public void calcCache() throws IOException {
        switch (this.valueType) {
            case 3: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                WSSObjectNormalWriter wssObjectNormalWriter = new WSSObjectNormalWriter(baos);
                wssObjectNormalWriter.write(this);
                wssObjectNormalWriter.flush();
                baos.flush();
                this.utf8S11N = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                WSSObjectC14NWriter wssObjectC14NWriter = new WSSObjectC14NWriter(baos);
                wssObjectC14NWriter.write(this);
                wssObjectC14NWriter.flush();
                baos.flush();
                this.utf8C14N = baos.toByteArray();
                this.hasCache = true;
            }
            case 2: {
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                byte[] binary = (byte[])this.valueObj;
                this.utf8S11N = Base64Table.encode(binary, 0, binary.length);
                this.utf8C14N = this.utf8S11N;
                this.hasCache = true;
                break;
            }
            case 7: {
                ByteArrayHolder bah = (ByteArrayHolder)this.valueObj;
                this.utf8S11N = Base64Table.encode(bah.getValue(), bah.getOffset(), bah.getLength());
                this.utf8C14N = this.utf8S11N;
                this.hasCache = true;
                break;
            }
            case 5: {
                break;
            }
        }
    }
}

