/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsNSPrefixPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;

public final class NamespacesInAncestor {
    protected NamespacePrefixPair soap = null;
    protected NamespacePrefixPair soap12 = null;
    protected ArrayList<OMNamespace> declaredOMNamespacesInAncestor = null;
    protected Map<String, NamespacePrefixPair> declaredNamespacePrefixPairMap = null;

    private void registerDeclaredNamespacePrefixPairInAncestor(NamespacePrefixPair nsPrefixPair) {
        if (this.declaredNamespacePrefixPairMap == null) {
            this.declaredNamespacePrefixPairMap = new HashMap<String, NamespacePrefixPair>();
        }
        this.declaredNamespacePrefixPairMap.put(nsPrefixPair.getPrefix(), nsPrefixPair);
    }

    public boolean isDeclaredInAncestor(NamespacePrefixPair nsPrefixPair) {
        if (this.declaredNamespacePrefixPairMap == null) {
            return false;
        }
        NamespacePrefixPair pair = this.declaredNamespacePrefixPairMap.get(nsPrefixPair.getPrefix());
        if (pair == null) {
            return false;
        }
        return pair.getUri().equals(nsPrefixPair.getUri());
    }

    public void gatherDeclaredOMNamespacesInAncestor(OMElement parent) {
        if (this.declaredOMNamespacesInAncestor == null) {
            this.declaredOMNamespacesInAncestor = new ArrayList();
        }
        while (parent != null) {
            Iterator ite = parent.getAllDeclaredNamespaces();
            while (ite.hasNext()) {
                OMNamespace omNamespace = (OMNamespace)ite.next();
                this.declaredOMNamespacesInAncestor.add(omNamespace);
            }
            OMContainer container = parent.getParent();
            if (container instanceof OMElement) {
                parent = (OMElement)container;
                continue;
            }
            parent = null;
        }
    }

    private NamespacePrefixPair findNamespacePrefixesPair(NamespacePrefixPair registeredNSPrefixPair) {
        NamespacePrefixPair nsPrefixPair = null;
        if (this.declaredOMNamespacesInAncestor != null) {
            nsPrefixPair = this.findNamespacePrefixesPairFromOMNamespaces(registeredNSPrefixPair);
        }
        if (nsPrefixPair == null) {
            nsPrefixPair = registeredNSPrefixPair;
        } else {
            this.registerDeclaredNamespacePrefixPairInAncestor(nsPrefixPair);
        }
        return nsPrefixPair;
    }

    private NamespacePrefixPair findNamespacePrefixesPairFromOMNamespaces(NamespacePrefixPair registeredNSPrefixPair) {
        String nsURI = registeredNSPrefixPair.getUri();
        String prefix = registeredNSPrefixPair.getPrefix();
        NamespacePrefixPair nsPrefixPair = null;
        for (int i = 0; i < this.declaredOMNamespacesInAncestor.size(); ++i) {
            OMNamespace omNamespace = this.declaredOMNamespacesInAncestor.get(i);
            if (!nsURI.equals(omNamespace.getNamespaceURI())) continue;
            if (prefix.equals(omNamespace.getPrefix())) {
                nsPrefixPair = registeredNSPrefixPair;
                break;
            }
            nsPrefixPair = new NamespacePrefixPair(omNamespace.getPrefix(), omNamespace.getNamespaceURI());
            break;
        }
        return nsPrefixPair;
    }

    public NamespacePrefixPair findNamespacePrefixesPairFromOMNamespaces(String prefix) {
        for (int i = 0; i < this.declaredOMNamespacesInAncestor.size(); ++i) {
            OMNamespace omNamespace = this.declaredOMNamespacesInAncestor.get(i);
            if (!prefix.equals(omNamespace.getPrefix())) continue;
            return new NamespacePrefixPair(omNamespace.getPrefix(), omNamespace.getNamespaceURI());
        }
        return null;
    }

    public ArrayList<OMNamespace> getDeclaredOMNamespacesInAncestor() {
        return this.declaredOMNamespacesInAncestor;
    }

    public NamespacePrefixPair getSoap() {
        if (this.soap == null) {
            this.soap = this.findNamespacePrefixesPair(Utf8ByteConstantsNSPrefixPair.NSPP_SOAP11);
        }
        return this.soap;
    }

    public NamespacePrefixPair getSoap12() {
        if (this.soap12 == null) {
            this.soap12 = this.findNamespacePrefixesPair(Utf8ByteConstantsNSPrefixPair.NSPP_SOAP12);
        }
        return this.soap12;
    }
}

