/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsNSPrefixPair;

public class NamespacePrefixPairStack {
    public static final int DEFAULT_CAPACITY = 8;
    public static final int DEFAULT_SIZE = 3;
    protected NamespacePrefixPair[] nsPrefixPairs;
    protected int size;
    protected int[] context;
    protected int contextSize;

    public NamespacePrefixPairStack() {
        this(8);
    }

    public NamespacePrefixPairStack(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 8;
        }
        this.nsPrefixPairs = new NamespacePrefixPair[initialCapacity];
        this.size = 3;
        this.context = new int[initialCapacity];
        this.contextSize = 0;
        this.nsPrefixPairs[0] = Utf8ByteConstantsNSPrefixPair.NSPP_XML;
        this.nsPrefixPairs[1] = Utf8ByteConstantsNSPrefixPair.NSPP_XMLNS;
        this.nsPrefixPairs[2] = Utf8ByteConstantsNSPrefixPair.NSPP_DEFAULT;
    }

    private final void ensureCapacity() {
        int nextCapacity = this.nsPrefixPairs.length * 2;
        NamespacePrefixPair[] nsPrefixPairsTemp = new NamespacePrefixPair[nextCapacity];
        System.arraycopy(this.nsPrefixPairs, 0, nsPrefixPairsTemp, 0, this.size);
        this.nsPrefixPairs = nsPrefixPairsTemp;
    }

    private final void ensureContextCapacity() {
        int nextCapacity = this.context.length * 2;
        int[] temp = new int[nextCapacity];
        System.arraycopy(this.context, 0, temp, 0, this.contextSize);
        this.context = temp;
    }

    public void pushContext() {
        if (this.contextSize >= this.context.length) {
            this.ensureContextCapacity();
        }
        this.context[this.contextSize] = this.size;
        ++this.contextSize;
    }

    public void popContext() {
        --this.contextSize;
        if (this.contextSize < 0) {
            this.contextSize = 0;
        }
        this.size = this.context[this.contextSize];
    }

    public boolean declarePrefix(NamespacePrefixPair namespacePrefixPair) {
        if (this.size >= this.nsPrefixPairs.length) {
            this.ensureCapacity();
        }
        this.nsPrefixPairs[this.size] = namespacePrefixPair;
        ++this.size;
        return true;
    }

    public void clear() {
        for (int i = 3; i < this.size; ++i) {
            this.nsPrefixPairs[i] = null;
        }
        this.size = 3;
        this.contextSize = 0;
    }

    public int size() {
        return this.size;
    }

    public NamespacePrefixPair getNamespacePrefixPair(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.nsPrefixPairs[index];
    }

    public NamespacePrefixPair getNamespacePrefixPair(String prefix) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.nsPrefixPairs[i].getPrefix().equals(prefix)) continue;
            return this.nsPrefixPairs[i];
        }
        return null;
    }
}

