/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsNSPrefixPair;
import java.io.UnsupportedEncodingException;

public final class NamespacePrefixPair
implements Comparable<NamespacePrefixPair> {
    protected int ascendingNumber = 0;
    protected String prefix;
    protected String uri;
    protected byte[] utf8prefix;
    protected byte[] c14nExpression;

    public NamespacePrefixPair(String prefix, String namespace) {
        if (prefix == null) {
            prefix = "";
        }
        if (namespace == null) {
            namespace = "";
        }
        this.prefix = prefix;
        this.uri = namespace;
        this.c14nExpression = null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public QName getQName() {
        return new QName(Utf8ByteConstantsNSPrefixPair.NSPP_XMLNS, this.prefix);
    }

    public byte[] getC14nExpression() throws UnsupportedEncodingException {
        if (this.c14nExpression == null) {
            this.c14nExpression = this.prefix == null || this.prefix.isEmpty() ? (" xmlns=\"" + this.uri + "\"").getBytes("UTF-8") : (" xmlns:" + this.prefix + "=\"" + this.uri + "\"").getBytes("UTF-8");
        }
        return this.c14nExpression;
    }

    public byte[] getSerializationExpression() throws UnsupportedEncodingException {
        return this.getC14nExpression();
    }

    public void setAscendingNumber(int ascendingNumber) {
        this.ascendingNumber = ascendingNumber;
    }

    @Override
    public int compareTo(NamespacePrefixPair o) {
        if (this.ascendingNumber > 0 && o.ascendingNumber > 0) {
            return this.ascendingNumber - o.ascendingNumber;
        }
        return this.prefix.compareTo(o.prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamespacePrefixPair)) {
            return false;
        }
        NamespacePrefixPair namespacePrefixPair = (NamespacePrefixPair)o;
        if (!this.prefix.equals(namespacePrefixPair.prefix)) {
            return false;
        }
        return this.uri.equals(namespacePrefixPair.uri);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ao=").append(this.ascendingNumber).append(", ");
        try {
            sb.append(new String(this.getSerializationExpression()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

