/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;

public final class AttributeSortedSet {
    public static final int INITSIZE = 5;
    QName[] qnames;
    VariablePartAttributeValue[] variableParts;
    int size;

    public AttributeSortedSet() {
        this(5);
    }

    public AttributeSortedSet(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 5;
        }
        this.qnames = new QName[initialCapacity];
        this.variableParts = new VariablePartAttributeValue[initialCapacity];
        this.size = 0;
    }

    private final void ensureCapacity() {
        int nextCapacity = this.qnames.length * 2;
        QName[] qnamesTemp = new QName[nextCapacity];
        VariablePartAttributeValue[] variablePartsTemp = new VariablePartAttributeValue[nextCapacity];
        System.arraycopy(this.qnames, 0, qnamesTemp, 0, this.size);
        System.arraycopy(this.variableParts, 0, this.variableParts, 0, this.size);
        this.qnames = qnamesTemp;
        this.variableParts = variablePartsTemp;
    }

    public void add(QName qname, VariablePartAttributeValue variablePart) {
        int numMoved;
        int i;
        if (this.size >= this.qnames.length) {
            this.ensureCapacity();
        }
        for (i = 0; i < this.size; ++i) {
            int comp = this.qnames[i].compareTo(qname);
            if (comp == 0) {
                this.qnames[i] = qname;
                this.variableParts[i] = variablePart;
                return;
            }
            if (comp > 0) break;
        }
        if ((numMoved = this.size - i) > 0) {
            System.arraycopy(this.qnames, i, this.qnames, i + 1, numMoved);
            System.arraycopy(this.variableParts, i, this.variableParts, i + 1, numMoved);
        }
        this.qnames[i] = qname;
        this.variableParts[i] = variablePart;
        ++this.size;
    }

    public void remove(QName qname) {
        if (qname == null) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!qname.equals(this.qnames[i])) continue;
            this.remove(i);
            break;
        }
    }

    public void remove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.qnames, index + 1, this.qnames, index, numMoved);
            System.arraycopy(this.variableParts, index + 1, this.variableParts, index, numMoved);
        }
        --this.size;
        this.qnames[this.size] = null;
        this.variableParts[this.size] = null;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.qnames[i] = null;
            this.variableParts[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public QName getQName(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.qnames[index];
    }

    public VariablePartAttributeValue getVariableParts(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.variableParts[index];
    }
}

