/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.impl.xenc;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectElementImpl;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;

public final class EncryptionMethod
extends WSSObjectElementImpl {
    public static final int RESERVED_INDEX_KEY_SIZE = 0;
    public static final int RESERVED_INDEX_OAEP_PARAMS = 1;
    public static final int RESERVED_CHILDREN_SIZE = 2;
    protected VariablePartAttributeValue algorithm = null;
    protected VariablePartTextValue keySize = null;
    protected VariablePartTextValue oAEPparams = null;

    public EncryptionMethod(WSSObjectDocumentImpl wssObjectDocumentImpl) {
        super(wssObjectDocumentImpl, Utf8ByteConstantsQNames.XENC.QN_ENCRYPTION_METHOD);
    }

    public VariablePartAttributeValue getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(VariablePartAttributeValue variablePart) {
        this.algorithm = variablePart;
        this.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_ALGORITHM, variablePart);
    }

    @Override
    public int getReservedChildrenSize() {
        return 2;
    }

    public VariablePartTextValue getKeySize() {
        return this.keySize;
    }

    public void setKeySize(VariablePartTextValue keySize) {
        this.keySize = keySize;
        this.setChildAsSimpleTextElement(0, Utf8ByteConstantsQNames.XENC.QN_KEY_SIZE, keySize);
    }

    public VariablePartTextValue getOAEPparams() {
        return this.oAEPparams;
    }

    public void setOAEPparams(VariablePartTextValue oAEPparams) {
        this.oAEPparams = oAEPparams;
        this.setChildAsSimpleTextElement(1, Utf8ByteConstantsQNames.XENC.QN_OAEP_PARAMS, oAEPparams);
    }
}

