/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.impl.wsc;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectElementImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsc.Properties;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.SecurityTokenReference;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;

public final class DerivedKeyToken
extends WSSObjectElementImpl {
    public static final int RESERVED_INDEX_WSSE_SECURITY_TOKEN_REFERENCE = 0;
    public static final int RESERVED_INDEX_PROPERTIES = 1;
    public static final int RESERVED_INDEX_GENERATION = 2;
    public static final int RESERVED_INDEX_OFFSET = 2;
    public static final int RESERVED_INDEX_LENGTH = 3;
    public static final int RESERVED_INDEX_LABEL = 4;
    public static final int RESERVED_INDEX_NONCE = 5;
    public static final int RESERVED_CHILDREN_SIZE = 6;
    protected VariablePartAttributeValue algorithm = null;
    protected SecurityTokenReference securityTokenReference = null;
    protected Properties properties = null;
    protected VariablePartTextValue generation = null;
    protected VariablePartTextValue offset = null;
    protected VariablePartTextValue length = null;
    protected VariablePartTextValue label = null;
    protected VariablePartTextValue nonce = null;

    public DerivedKeyToken(WSSObjectDocumentImpl wssObjectDocumentImpl, QName qname) {
        super(wssObjectDocumentImpl, qname);
    }

    public VariablePartAttributeValue getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(VariablePartAttributeValue variablePart) {
        this.algorithm = variablePart;
        this.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_ALGORITHM, variablePart);
    }

    @Override
    public int getReservedChildrenSize() {
        return 6;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        this.securityTokenReference = securityTokenReference;
        this.setChild(0, securityTokenReference);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.setChild(1, properties);
    }

    public VariablePartTextValue getGeneration() {
        return this.generation;
    }

    public void setGeneration(VariablePartTextValue generation) {
        if (generation != null && this.offset != null) {
            this.setOffset(null);
        }
        this.generation = generation;
        this.setChildAsSimpleTextElement(2, Utf8ByteConstantsQNames.WSC.QN_GENERATION, generation);
    }

    public VariablePartTextValue getOffset() {
        return this.offset;
    }

    public void setOffset(VariablePartTextValue offset) {
        if (offset != null && this.generation != null) {
            this.setGeneration(null);
        }
        this.offset = offset;
        this.setChildAsSimpleTextElement(2, Utf8ByteConstantsQNames.WSC.QN_OFFSET, offset);
    }

    public VariablePartTextValue getLength() {
        return this.length;
    }

    public void setLength(VariablePartTextValue length) {
        this.length = length;
        this.setChildAsSimpleTextElement(3, Utf8ByteConstantsQNames.WSC.QN_LENGTH, length);
    }

    public VariablePartTextValue getLabel() {
        return this.label;
    }

    public void setLabel(VariablePartTextValue label) {
        this.label = label;
        this.setChildAsSimpleTextElement(4, Utf8ByteConstantsQNames.WSC.QN_LABEL, label);
    }

    public VariablePartTextValue getNonce() {
        return this.nonce;
    }

    public void setNonce(VariablePartTextValue nonce) {
        this.nonce = nonce;
        this.setChildAsSimpleTextElement(5, Utf8ByteConstantsQNames.WSC.QN_NONCE, nonce);
    }
}

