/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.impl.dsig;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectElementImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.X509IssuerSerial;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;

public final class X509Data
extends WSSObjectElementImpl {
    public static final int RESERVED_INDEX_X509_ISSUER_SERIAL = 0;
    public static final int RESERVED_INDEX_X509_SKI = 0;
    public static final int RESERVED_INDEX_X509_SUBJECT_NAME = 0;
    public static final int RESERVED_INDEX_X509_CERTIFICATE = 0;
    public static final int RESERVED_INDEX_X509_CRL = 0;
    public static final int RESERVED_CHILDREN_SIZE = 1;
    protected X509IssuerSerial x509IssuerSerial = null;
    protected VariablePartTextValue x509Ski = null;
    protected VariablePartTextValue x509SubjectName = null;
    protected VariablePartTextValue x509Certificate = null;
    protected VariablePartTextValue x509Crl = null;

    public X509Data(WSSObjectDocumentImpl wssObjectDocumentImpl) {
        super(wssObjectDocumentImpl, Utf8ByteConstantsQNames.DSIG.QN_X509_DATA);
    }

    @Override
    public int getReservedChildrenSize() {
        return 1;
    }

    public X509IssuerSerial getX509IssuerSerial() {
        return this.x509IssuerSerial;
    }

    public void setX509IssuerSerial(X509IssuerSerial issuerSerial) {
        if (issuerSerial != null) {
            if (this.x509Ski != null) {
                this.setX509Ski(null);
            }
            if (this.x509SubjectName != null) {
                this.setX509SubjectName(null);
            }
            if (this.x509Certificate != null) {
                this.setX509Certificate(null);
            }
            if (this.x509Crl != null) {
                this.setX509Crl(null);
            }
        }
        this.x509IssuerSerial = issuerSerial;
        this.setChild(0, issuerSerial);
    }

    public VariablePartTextValue getX509Ski() {
        return this.x509Ski;
    }

    public void setX509Ski(VariablePartTextValue ski) {
        if (ski != null) {
            if (this.x509IssuerSerial != null) {
                this.setX509IssuerSerial(null);
            }
            if (this.x509SubjectName != null) {
                this.setX509SubjectName(null);
            }
            if (this.x509Certificate != null) {
                this.setX509Certificate(null);
            }
            if (this.x509Crl != null) {
                this.setX509Crl(null);
            }
        }
        this.x509Ski = ski;
        this.setChildAsSimpleTextElement(0, Utf8ByteConstantsQNames.DSIG.QN_X509_SKI, ski);
    }

    public VariablePartTextValue getX509SubjectName() {
        return this.x509SubjectName;
    }

    public void setX509SubjectName(VariablePartTextValue subjectName) {
        if (subjectName != null) {
            if (this.x509IssuerSerial != null) {
                this.setX509IssuerSerial(null);
            }
            if (this.x509Ski != null) {
                this.setX509Ski(null);
            }
            if (this.x509Certificate != null) {
                this.setX509Certificate(null);
            }
            if (this.x509Crl != null) {
                this.setX509Crl(null);
            }
        }
        this.x509SubjectName = subjectName;
        this.setChildAsSimpleTextElement(0, Utf8ByteConstantsQNames.DSIG.QN_X509_SUBJECT_NAME, subjectName);
    }

    public VariablePartTextValue getX509Certificate() {
        return this.x509Certificate;
    }

    public void setX509Certificate(VariablePartTextValue certificate) {
        if (certificate != null) {
            if (this.x509IssuerSerial != null) {
                this.setX509IssuerSerial(null);
            }
            if (this.x509Ski != null) {
                this.setX509Ski(null);
            }
            if (this.x509SubjectName != null) {
                this.setX509SubjectName(null);
            }
            if (this.x509Crl != null) {
                this.setX509Crl(null);
            }
        }
        this.x509Certificate = certificate;
        this.setChildAsSimpleTextElement(0, Utf8ByteConstantsQNames.DSIG.QN_X509_CERTIFICATE, certificate);
    }

    public VariablePartTextValue getX509Crl() {
        return this.x509Crl;
    }

    public void setX509Crl(VariablePartTextValue crl) {
        if (crl != null) {
            if (this.x509IssuerSerial != null) {
                this.setX509IssuerSerial(null);
            }
            if (this.x509Ski != null) {
                this.setX509Ski(null);
            }
            if (this.x509SubjectName != null) {
                this.setX509SubjectName(null);
            }
            if (this.x509Certificate != null) {
                this.setX509Certificate(null);
            }
        }
        this.x509Crl = crl;
        this.setChildAsSimpleTextElement(0, Utf8ByteConstantsQNames.DSIG.QN_X509_CRL, crl);
    }
}

