/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.impl.dsig;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectElementImpl;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;

public final class SignatureMethod
extends WSSObjectElementImpl {
    public static final int RESERVED_INDEX_HMAC_OUTPUT_LENGTH = 0;
    public static final int RESERVED_CHILDREN_SIZE = 1;
    protected VariablePartAttributeValue algorithm = null;
    protected VariablePartTextValue hMACOutputLength = null;

    public SignatureMethod(WSSObjectDocumentImpl wssObjectDocumentImpl) {
        super(wssObjectDocumentImpl, Utf8ByteConstantsQNames.DSIG.QN_SIGNATURE_METHOD);
    }

    public VariablePartAttributeValue getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(VariablePartAttributeValue variablePart) {
        this.algorithm = variablePart;
        this.setAttributeToSortedSet(Utf8ByteConstantsQNames.AttributeDefaultNS.QN_ALGORITHM, variablePart);
    }

    @Override
    public int getReservedChildrenSize() {
        return 1;
    }

    public VariablePartTextValue getHMACOutputLength() {
        return this.hMACOutputLength;
    }

    public void setHMACOutputLength(VariablePartTextValue outputLength) {
        this.hMACOutputLength = outputLength;
        this.setChildAsSimpleTextElement(0, Utf8ByteConstantsQNames.DSIG.QN_HMAC_OUTPUT_LENGTH, outputLength);
    }
}

