/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.impl;

import com.ibm.ws.wssecurity.wssobject.interfaces.BelongsToNamespace;
import com.ibm.ws.wssecurity.wssobject.interfaces.HasNamspaceDeclarations;
import com.ibm.ws.wssecurity.wssobject.interfaces.Parent;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.NamespacesInAncestor;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WSSObjectDocumentImpl
implements Parent,
HasNamspaceDeclarations {
    public static final int NSDECLS_MODE_OUTBOUND_CENTRALIZED = 1;
    public static final int NSDECLS_MODE_INBOUND_DISTRIBUTED = 2;
    public static final int RESERVED_CHILDREN_SIZE = 1;
    protected int namespaceDeclarationMode = 1;
    protected WSSObject rootWSSObject;
    protected Map<String, WSSObject> idMap = new HashMap<String, WSSObject>();
    protected NamespacePrefixPairSortedSet namespaceDeclarations = new NamespacePrefixPairSortedSet();
    protected NamespacesInAncestor namespacesInAncestor = new NamespacesInAncestor();

    public WSSObjectDocumentImpl(int nsDeclsMode) {
        this.namespaceDeclarationMode = nsDeclsMode;
        switch (nsDeclsMode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("WSSObjectDocumentImpl: namespace declaration mode  is not supported.");
            }
        }
    }

    public void setRootWSSObject(WSSObject rootWSSObject) {
        this.rootWSSObject = rootWSSObject;
    }

    public WSSObject getRootWSSObject() {
        return this.rootWSSObject;
    }

    @Override
    public int getReservedChildrenSize() {
        return 1;
    }

    @Override
    public void addChild(WSSObject wssObject) {
        if (this.rootWSSObject == null) {
            this.rootWSSObject = wssObject;
        }
        if (wssObject != null) {
            wssObject.setParent(this);
        }
        if (wssObject instanceof BelongsToNamespace) {
            BelongsToNamespace belongsToNamespace = (BelongsToNamespace)((Object)wssObject);
            this.declareNamespace(belongsToNamespace.getNamespace());
        }
    }

    @Override
    public WSSObject getChild(int index) {
        if (index == 0) {
            return this.rootWSSObject;
        }
        return null;
    }

    @Override
    public ArrayList<WSSObject> getChildren() {
        ArrayList<WSSObject> children = new ArrayList<WSSObject>(1);
        children.add(this.rootWSSObject);
        return children;
    }

    @Override
    public void insertChildBefore(int index, WSSObject wssObject) {
        if (index == 0) {
            this.rootWSSObject = wssObject;
        }
    }

    @Override
    public void setChild(int index, WSSObject wssObject) {
        if (index == 0) {
            this.rootWSSObject = wssObject;
        }
    }

    @Override
    public WSSObject removeChild(int index) {
        if (index == 0) {
            WSSObject ret = this.rootWSSObject;
            this.rootWSSObject = null;
            return ret;
        }
        return null;
    }

    @Override
    public int getChildrenSize() {
        if (this.rootWSSObject != null) {
            return 1;
        }
        return 0;
    }

    public Map<String, WSSObject> getIdMap() {
        if (this.idMap == null) {
            this.idMap = new HashMap<String, WSSObject>();
        }
        return this.idMap;
    }

    public WSSObject getWSSObjectById(String id) {
        if (this.idMap == null) {
            return null;
        }
        WSSObject ret = this.idMap.get(id);
        if (ret == null) {
            return null;
        }
        Parent root = ret.getParent();
        while (root instanceof WSSObject) {
            root = ((WSSObject)((Object)root)).getParent();
        }
        if (this != root) {
            return null;
        }
        return ret;
    }

    @Override
    public NamespacePrefixPairSortedSet getDeclaredNamespaces() {
        return this.namespaceDeclarations;
    }

    @Override
    public void declareNamespace(NamespacePrefixPair namespacePrefixPair) {
        if (this.getNamespacesInAncestor().isDeclaredInAncestor(namespacePrefixPair)) {
            return;
        }
        this.namespaceDeclarations.add(namespacePrefixPair);
    }

    public NamespacesInAncestor getNamespacesInAncestor() {
        return this.namespacesInAncestor;
    }

    public void setNamespacesInAncestor(NamespacesInAncestor namespacesInAncestor) {
        this.namespacesInAncestor = namespacesInAncestor;
    }

    public int getNSDeclsMode() {
        return this.namespaceDeclarationMode;
    }

    public void setNSDeclsMode(int mode) {
        this.namespaceDeclarationMode = mode;
    }

    static {
        Utf8ByteConstantsQNames.AssignAcendingNumber();
    }
}

